package org.gcube.indexmanagement.featureindexlibrary.vafile.algo;

import org.apache.log4j.Logger;

/**
 * Computes the Lower bounds of the query point to all grid cells
 * 
 * @author UoA
 */
public class ComputeBoundsL{
	/**
	 * Logger used by the class
	 */
	private static Logger log = Logger.getLogger(ComputeBoundsL.class);
	/**
	 * The partiton points
	 */
	private float [][]partitionPoints=null;
	/**
	 * The bucets in each dimention
	 */
	private int buckets=0;
	/**
	 * The lower bound difference
	 */
	private float [][]dLow=null;
	
	/**
	 * Creates a new instance
	 * 
	 * @param partitionPoints The partition points
	 * @param buckets The buckets in the dimention
	 */
	public ComputeBoundsL(float [][]partitionPoints, int buckets){
		this.partitionPoints=partitionPoints;
		this.buckets=buckets;
		dLow=new float[partitionPoints.length][buckets-1];
	}
	
	/**
	 * Retrieves the lower bound of the given bitstring
	 * 
	 * @param bitString The bit string
	 * @return the lower bound
	 */
	public float getLowerBound(byte []bitString){
		float bound=0;
		for(int i=0;i<bitString.length;i+=1){
			bound+=this.dLow[i][(int)bitString[i]];
		}
		return bound;
	}
	
	/**
	 * precmputes the dinstance differences
	 * 
	 * @param vector The query vector
	 * @throws Exception An error
	 */
	public void preCompute(float []vector) throws Exception{
		try{
			for(int j=0;j<partitionPoints.length;j+=1){
				for(int i=0;i<buckets-1;i+=1){
	//				if(vector[j]<this.getFloor(j,(byte)i)){
					if(vector[j]<this.getFloor(j,i)){
	//					dLow[j][i]=(this.getFloor(j,(byte)i)-vector[j])*(this.getFloor(j,(byte)i)-vector[j]);
						dLow[j][i]=(this.getFloor(j,i)-vector[j])*(this.getFloor(j,i)-vector[j]);
					}
	//				else if(vector[j]>this.getCeiling(j,(byte)i)){
					else if(vector[j]>this.getCeiling(j,i)){
	//					dLow[j][i]=(vector[j]-this.getCeiling(j,(byte)i))*(vector[j]-this.getCeiling(j,(byte)i));
						dLow[j][i]=(vector[j]-this.getCeiling(j,i))*(vector[j]-this.getCeiling(j,i));
					}
					else{
						dLow[j][i]=0;
					}
				}
			}
		}catch(Exception e){
			log.error("Could not compute Dbounds for query. Throwing Exception",e);
			throw new Exception("Could not compute Dbounds for query");
		}
//		this.dBounds=new BoundDistances(Dlow,Dhigh);
	}
	
//	private float getFloor(int dim,byte bitString) throws Exception{
	/**
	 * The floor partition point in the given dimention
	 * 
	 * @param dim The dimention 
	 * @param bitString the bit string
	 * @return the floor partition point
	 */
	private float getFloor(int dim,int bitString){
		return partitionPoints[dim][((int)bitString)];
	}

//	private float getCeiling(int dim,byte bitString){
	/**
	 * The ceiling partition point in the given dimention
	 * 
	 * @param dim The dimention 
	 * @param bitString the bit string
	 * @return the ceiling partition point
	 */
	private float getCeiling(int dim,int bitString){
		return partitionPoints[dim][((int)bitString)+1];
	}
}
