/*
 * SynonymPlugin.java
 *
 * $Author: tsakas $
 * $Date: 2007/12/20 14:37:40 $
 * $Id: SynonymPlugin.java,v 1.1 2007/12/20 14:37:40 tsakas Exp $
 *
 * <pre>
 *             Copyright (c) : 2006 Fast Search & Transfer ASA
 *                             ALL RIGHTS RESERVED
 * </pre>
 */

package org.gcube.indexmanagement.common.linguistics.synonymplugin;

/**
 * The synonym plugin interface.
 */
public interface SynonymPlugin {

    /**
     * Method to initialise this plugin, the configuration file is optional,
     * but most language detection tools need some sort of statistics,
     * references and so on.
     * @param optConfigFile - The config file
     **/
    void init(String optConfigFile);

    /**
     * Method to detect the language.
     * @param document    The document
     * @return            The language string
     **/
    String detectLanguage(Object document);

    /**
     * Method to detect encoding.
     * @param document     The document
     * @return             The encoding string
     **/
    String detectEncoding(Object document);
}
