/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.indexmanagement.geo.shape;

import java.util.ArrayList;
import java.util.Collection;
import org.gcube.indexmanagement.geo.shape.Point;
import org.gcube.indexmanagement.geo.shape.Rectangle;

public class Polygon {
    private ArrayList<Point> vertices = new ArrayList();

    public Polygon() {
    }

    public Polygon(Collection<Point> vertices) {
        this.addVertices(vertices);
    }

    public Polygon(Point[] vertices) {
        this.addVertices(vertices);
    }

    public void addVertex(Point vertex) {
        this.vertices.add(vertex);
    }

    public void addVertices(Collection<Point> vertices) {
        this.vertices.addAll(vertices);
    }

    public void addVertices(Point[] vertices) {
        for (int i = 0; i < vertices.length; ++i) {
            this.vertices.add(vertices[i]);
        }
    }

    public ArrayList<Point> getVertices() {
        return this.vertices;
    }

    public Point[] getVertexArray() {
        return this.vertices.toArray(new Point[this.vertices.size()]);
    }

    public Rectangle getBoundingBox() {
        ArrayList<Point> vertices = this.getVertices();
        long minX = vertices.get(0).getX();
        long maxX = vertices.get(0).getX();
        long minY = vertices.get(0).getY();
        long maxY = vertices.get(0).getY();
        for (Point vertex : vertices) {
            if (vertex.getX() < minX) {
                minX = vertex.getX();
            } else if (vertex.getX() > maxX) {
                maxX = vertex.getX();
            }
            if (vertex.getY() < minY) {
                minY = vertex.getY();
                continue;
            }
            if (vertex.getY() <= maxY) continue;
            maxY = vertex.getY();
        }
        return new Rectangle(minX, maxX, minY, maxY);
    }

    public boolean isValid() {
        int length = this.vertices.size();
        if (length > 2) {
            Point lineStart = null;
            Point lineEnd = null;
            for (int i = 1; i < length; ++i) {
                long curStartX = this.vertices.get(i - 1).getX();
                long curEndX = this.vertices.get(i).getX();
                long curStartY = this.vertices.get(i - 1).getY();
                long curEndY = this.vertices.get(i).getY();
                for (int j = 2; j < length - 1; ++j) {
                    lineStart = this.vertices.get((j + i - 1) % length);
                    lineEnd = this.vertices.get((j + i) % length);
                    if (!this.doLinesCross(curStartX, curStartY, curEndX, curEndY, lineStart.getX(), lineStart.getY(), lineEnd.getX(), lineEnd.getY())) continue;
                    return false;
                }
                lineStart = this.vertices.get((i + length - 2) % length);
                lineEnd = this.vertices.get((i + length - 1) % length);
                if (!this.doesLastCross(lineStart.getX(), lineStart.getY(), lineEnd.getX(), lineEnd.getY(), curEndX, curEndY)) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private int ccw(long x1, long y1, long x2, long y2, long x3, long y3) {
        long dy1 = y2 - y1;
        long dx2 = x3 - x1;
        long dy2 = y3 - y1;
        long dx1 = x2 - x1;
        if (dy1 * dx2 < dy2 * dx1) {
            return 1;
        }
        if (dy1 * dx2 > dy2 * dx1) {
            return -1;
        }
        if (dx1 * dx2 < 0L || dy1 * dy2 < 0L) {
            return -1;
        }
        if (dx1 * dx1 + dy1 * dy1 >= dx2 * dx2 + dy2 * dy2) {
            return 0;
        }
        return 1;
    }

    private boolean doLinesCross(long x1, long y1, long x2, long y2, long x3, long y3, long x4, long y4) {
        return this.ccw(x1, y1, x2, y2, x3, y3) * this.ccw(x1, y1, x2, y2, x4, y4) <= 0 && this.ccw(x3, y3, x4, y4, x1, y1) * this.ccw(x3, y3, x4, y4, x2, y2) <= 0;
    }

    private boolean doesLastCross(long x1, long y1, long x2, long y2, long pointX, long pointY) {
        long dy1 = y2 - y1;
        long dx2 = pointX - x1;
        long dy2 = pointY - y1;
        long dx1 = x2 - x1;
        return dy1 * dx2 == dy2 * dx1 && dx1 * dx1 + dy1 * dy1 >= dx2 * dx2 + dy2 * dy2;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        boolean first = true;
        String separator = "";
        buffer.append("Poly[");
        for (Point vertex : this.vertices) {
            buffer.append(separator).append(vertex.getX()).append(", ").append(vertex.getY());
            if (!first) continue;
            separator = " ; ";
        }
        buffer.append("]");
        return buffer.toString();
    }
}

