/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.index.service.ckan;

import com.google.gson.Gson;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.core.MultivaluedMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import net.minidev.json.JSONArray;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.gcube.rest.index.service.ckan.beans.Item;
import org.gcube.rest.index.service.ckan.beans.Licence;
import org.gcube.rest.index.service.ckan.beans.Organisation;
import org.gcube.rest.index.service.ckan.beans.Resource;
import org.gcube.rest.index.service.resources.ServiceProperties;
import org.json.simple.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class CKANBridge {
    static final Logger logger = LoggerFactory.getLogger(CKANBridge.class);
    private static String SERVICE_NAME = "Catalogue-WS";
    private static String SERVICE_CLASS = "Data-Catalogue";
    private Set<String> restEndpoints = null;
    private String CKAN_TOKEN = null;
    private String CKAN_SCOPE = null;
    private String CKAN_ORGANISATION = null;
    private String CKAN_LICENCE_ID = null;
    private String CKAN_ITEM_PROFILE_NAME = null;
    private Client jerseyClient;
    private final Gson gson;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CKANBridge() {
        CKANBridge cKANBridge = this;
        synchronized (cKANBridge) {
            ServiceProperties props = new ServiceProperties();
            this.CKAN_TOKEN = props.getCkanToken();
            this.CKAN_SCOPE = props.getCkanScope();
            this.CKAN_ORGANISATION = props.getCkanOrganisationNameOrID();
            this.CKAN_LICENCE_ID = props.getCkanLicenceID();
            this.CKAN_ITEM_PROFILE_NAME = props.getCkanItemProfileName();
        }
        this.restEndpoints = this.getEndpoints(this.CKAN_SCOPE);
        logger.info("Found the following " + this.restEndpoints.size() + ": " + this.restEndpoints.toString() + " CKAN service endpoints on scope " + this.CKAN_SCOPE);
        this.jerseyClient = Client.create();
        this.gson = new Gson();
    }

    private Set<String> getEndpoints(String scope) {
        ScopeProvider.instance.set(scope);
        XQuery query = ICFactory.queryFor(GCoreEndpoint.class);
        query.addCondition("$resource/Profile/ServiceClass/text() eq '" + SERVICE_CLASS + "'").addCondition("$resource/Profile/ServiceName/text() eq '" + SERVICE_NAME + "'");
        DiscoveryClient client = ICFactory.clientFor(GCoreEndpoint.class);
        List eprs = client.submit((Query)query);
        HashSet<String> clusterHosts = new HashSet<String>();
        for (GCoreEndpoint epr : eprs) {
            if (!"ready".equals(epr.profile().deploymentData().status().toLowerCase())) continue;
            for (GCoreEndpoint.Profile.Endpoint e : epr.profile().endpointMap().values().toArray(new GCoreEndpoint.Profile.Endpoint[epr.profile().endpointMap().values().size()])) {
                if (e.uri().toString().endsWith("/gcube/resource")) continue;
                clusterHosts.add(e.uri().toString());
            }
        }
        return clusterHosts;
    }

    public String createOrganisation(Organisation organisation) {
        String listEP = "/api/organizations/create";
        for (String restEndpoint : this.restEndpoints) {
            WebResource tempWebResource = this.jerseyClient.resource(restEndpoint).path(listEP);
            try {
                ClientResponse resp = (ClientResponse)((WebResource.Builder)((WebResource.Builder)tempWebResource.accept(new String[]{"application/json; charset=UTF-8"}).type("application/json")).header("gcube-token", (Object)this.CKAN_TOKEN)).post(ClientResponse.class, (Object)this.gson.toJson((Object)organisation));
                String json = (String)resp.getEntity(String.class);
                return json;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return "";
    }

    public String showOrganisation(String name) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"id", (Object)name);
        String listEP = "/api/organizations/show";
        for (String restEndpoint : this.restEndpoints) {
            try {
                WebResource tempWebResource = this.jerseyClient.resource(restEndpoint).path(listEP).queryParams((MultivaluedMap)params);
                ClientResponse resp = (ClientResponse)((WebResource.Builder)tempWebResource.accept(new String[]{"application/json; charset=UTF-8"}).header("gcube-token", (Object)this.CKAN_TOKEN)).get(ClientResponse.class);
                String json = (String)resp.getEntity(String.class);
                if (resp.getStatus() <= 199 || resp.getStatus() >= 300) continue;
                return json;
            }
            catch (Exception exception) {
            }
        }
        return "";
    }

    public List<String> getOrganisations() {
        String listEP = "/api/organizations/list";
        for (String restEndpoint : this.restEndpoints) {
            try {
                WebResource tempWebResource = this.jerseyClient.resource(restEndpoint).path(listEP);
                ClientResponse resp = (ClientResponse)((WebResource.Builder)((WebResource.Builder)tempWebResource.accept(new String[]{"application/json; charset=UTF-8"}).type("application/x-www-form-urlencoded; charset=UTF-8")).header("gcube-token", (Object)this.CKAN_TOKEN)).get(ClientResponse.class);
                String json = (String)resp.getEntity(String.class);
                if (resp.getStatus() < 200 || resp.getStatus() > 299) continue;
                List organisations = (List)JsonPath.read((String)json, (String)"$.result[*]", (Predicate[])new Predicate[0]);
                return organisations;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new ArrayList<String>();
    }

    public List<String> getDefaultOrganisationItemNames() {
        return this.getOrganisationItemNames(null);
    }

    public List<String> getOrganisationItemNames(String organisationName) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        if (organisationName == null || organisationName.isEmpty()) {
            params.add((Object)"id", (Object)this.CKAN_ORGANISATION);
        } else {
            params.add((Object)"id", (Object)organisationName);
        }
        params.add((Object)"include_datasets", (Object)"true");
        String listEP = "/api/organizations/show";
        for (String restEndpoint : this.restEndpoints) {
            try {
                WebResource tempWebResource = this.jerseyClient.resource(restEndpoint).path(listEP).queryParams((MultivaluedMap)params);
                ClientResponse resp = (ClientResponse)((WebResource.Builder)tempWebResource.accept(new String[]{"application/json; charset=UTF-8"}).header("gcube-token", (Object)this.CKAN_TOKEN)).get(ClientResponse.class);
                String json = (String)resp.getEntity(String.class);
                List groupNames = (List)JsonPath.read((String)json, (String)"$.result.packages[*].name", (Predicate[])new Predicate[0]);
                return groupNames;
            }
            catch (Exception exception) {
            }
        }
        return new ArrayList<String>();
    }

    public List<Licence> listLicences() {
        String listEP = "/api/licenses/list";
        for (String restEndpoint : this.restEndpoints) {
            try {
                WebResource tempWebResource = this.jerseyClient.resource(restEndpoint).path(listEP);
                ClientResponse resp = (ClientResponse)((WebResource.Builder)tempWebResource.accept(new String[]{"application/json; charset=UTF-8"}).header("gcube-token", (Object)this.CKAN_TOKEN)).get(ClientResponse.class);
                String jsonResp = (String)resp.getEntity(String.class);
                JSONArray licencesJsonArray = (JSONArray)JsonPath.read((String)jsonResp, (String)"$.result[*]", (Predicate[])new Predicate[0]);
                return licencesJsonArray.parallelStream().map(jsonLicence -> (Licence)this.gson.fromJson(this.gson.toJson(jsonLicence), Licence.class)).collect(Collectors.toList());
            }
            catch (Exception exception) {
            }
        }
        return new ArrayList<Licence>();
    }

    public List<String> listGroups() {
        String listEP = "/api/groups/list";
        for (String restEndpoint : this.restEndpoints) {
            try {
                WebResource tempWebResource = this.jerseyClient.resource(restEndpoint).path(listEP);
                ClientResponse resp = (ClientResponse)((WebResource.Builder)tempWebResource.accept(new String[]{"application/json; charset=UTF-8"}).header("gcube-token", (Object)this.CKAN_TOKEN)).get(ClientResponse.class);
                String json = (String)resp.getEntity(String.class);
                List groupNames = (List)JsonPath.read((String)json, (String)"$.result[*]", (Predicate[])new Predicate[0]);
                return groupNames;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new ArrayList<String>();
    }

    public String getGroup(String name) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"id", (Object)name);
        String listEP = "/api/groups/show";
        for (String restEndpoint : this.restEndpoints) {
            try {
                WebResource tempWebResource = this.jerseyClient.resource(restEndpoint).path(listEP).queryParams((MultivaluedMap)params);
                ClientResponse resp = (ClientResponse)((WebResource.Builder)tempWebResource.accept(new String[]{"application/json; charset=UTF-8"}).header("gcube-token", (Object)this.CKAN_TOKEN)).get(ClientResponse.class);
                String json = (String)resp.getEntity(String.class);
                return json;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public String createGroup(String groupName) {
        String listEP = "/api/groups/create";
        Iterator iter = this.restEndpoints.iterator();
        if (iter.hasNext()) {
            String restEndpoint = (String)iter.next();
            try {
                WebResource tempWebResource = this.jerseyClient.resource(restEndpoint).path(listEP);
                ClientResponse resp = (ClientResponse)((WebResource.Builder)((WebResource.Builder)tempWebResource.accept(new String[]{"application/json; charset=UTF-8"}).type("application/json")).header("gcube-token", (Object)this.CKAN_TOKEN)).post(ClientResponse.class, (Object)("{\"name\":\"" + groupName + "\"}"));
                String json = (String)resp.getEntity(String.class);
                return json;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return "";
            }
        }
        return null;
    }

    public boolean deleteGroup(String name) {
        String listEP = "/api/groups/delete";
        for (String restEndpoint : this.restEndpoints) {
            try {
                WebResource tempWebResource = this.jerseyClient.resource(restEndpoint).path(listEP);
                ClientResponse resp = (ClientResponse)((WebResource.Builder)((WebResource.Builder)tempWebResource.accept(new String[]{"application/json; charset=UTF-8"}).type("application/json")).header("gcube-token", (Object)this.CKAN_TOKEN)).post(ClientResponse.class, (Object)("{\"id\":\"" + name + "\"}"));
                String json = (String)resp.getEntity(String.class);
                if (resp.getStatus() <= 199 || resp.getStatus() >= 300) continue;
                return true;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return false;
    }

    public List<String> getGroupItems(String groupName) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"id", (Object)groupName);
        params.add((Object)"include_datasets", (Object)"true");
        String listEP = "/api/groups/show";
        for (String restEndpoint : this.restEndpoints) {
            try {
                WebResource tempWebResource = this.jerseyClient.resource(restEndpoint).path(listEP).queryParams((MultivaluedMap)params);
                ClientResponse resp = (ClientResponse)((WebResource.Builder)tempWebResource.accept(new String[]{"application/json; charset=UTF-8"}).header("gcube-token", (Object)this.CKAN_TOKEN)).get(ClientResponse.class);
                String json = (String)resp.getEntity(String.class);
                List groupNames = (List)JsonPath.read((String)json, (String)"$.result.packages[*].name", (Predicate[])new Predicate[0]);
                return groupNames;
            }
            catch (Exception exception) {
            }
        }
        return new ArrayList<String>();
    }

    public String groupsFormer(List<String> groups) {
        if (groups == null) {
            groups = new ArrayList<String>();
        }
        String g = "[" + groups.parallelStream().map(groupName -> "{\"name\":\"" + groupName + "\"}").collect(Collectors.joining(",")) + "]";
        return g;
    }

    public List<String> listProfiles() {
        String listEP = "/api/profiles/profile_names";
        for (String restEndpoint : this.restEndpoints) {
            try {
                WebResource tempWebResource = this.jerseyClient.resource(restEndpoint).path(listEP);
                ClientResponse resp = (ClientResponse)((WebResource.Builder)tempWebResource.accept(new String[]{"application/json; charset=UTF-8"}).header("gcube-token", (Object)this.CKAN_TOKEN)).get(ClientResponse.class);
                String json = (String)resp.getEntity(String.class);
                List profileNames = (List)JsonPath.read((String)json, (String)"$.result[*]", (Predicate[])new Predicate[0]);
                return profileNames;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return new ArrayList<String>();
    }

    public String getProfile(String name) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"name", (Object)name);
        String listEP = "/api/profiles/profile";
        for (String restEndpoint : this.restEndpoints) {
            try {
                WebResource tempWebResource = this.jerseyClient.resource(restEndpoint).path(listEP).queryParams((MultivaluedMap)params);
                ClientResponse resp = (ClientResponse)((WebResource.Builder)tempWebResource.type("application/json").header("gcube-token", (Object)this.CKAN_TOKEN)).get(ClientResponse.class);
                String json = (String)resp.getEntity(String.class);
                return json;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public Item createItem(Item itm, List<String> tags, String profileName) {
        JSONObject item = new JSONObject();
        item.put((Object)"name", (Object)itm.getName());
        item.put((Object)"title", (Object)itm.getTitle());
        if (itm.getLicense_id() == null || itm.getLicense_id().isEmpty()) {
            item.put((Object)"license_id", (Object)this.CKAN_LICENCE_ID);
        } else {
            item.put((Object)"license_id", (Object)itm.getLicense_id());
        }
        if (itm.getOwner_org() == null || itm.getOwner_org().isEmpty()) {
            item.put((Object)"owner_org", (Object)this.CKAN_ORGANISATION);
        } else {
            item.put((Object)"owner_org", (Object)itm.getOwner_org());
        }
        if (tags != null && !tags.isEmpty()) {
            JSONArray tagsArray = new JSONArray();
            tags.stream().forEach(tag -> {
                JSONObject t = new JSONObject();
                t.put((Object)"name", tag);
                tagsArray.add((Object)t);
            });
            item.put((Object)"tags", (Object)tagsArray);
        }
        JSONArray extras = new JSONArray();
        JSONObject sysTypeObject = new JSONObject();
        sysTypeObject.put((Object)"key", (Object)"system:type");
        sysTypeObject.put((Object)"value", (Object)this.getProfileType(this.CKAN_ITEM_PROFILE_NAME));
        extras.add((Object)sysTypeObject);
        item.put((Object)"extras", (Object)extras);
        System.out.println("Publishing item to CKAN: " + item.toJSONString());
        logger.info("Publishing item to CKAN: " + item.toJSONString());
        String restPath = "/api/items/create";
        for (String restEndpoint : this.restEndpoints) {
            try {
                WebResource tempWebResource = this.jerseyClient.resource(restEndpoint).path(restPath);
                ClientResponse resp = (ClientResponse)((WebResource.Builder)((WebResource.Builder)tempWebResource.accept(new String[]{"application/json; charset=UTF-8"}).type("application/json; charset=UTF-8")).header("gcube-token", (Object)this.CKAN_TOKEN)).post(ClientResponse.class, (Object)item.toJSONString());
                String json = (String)resp.getEntity(String.class);
                try {
                    String itemJson = this.gson.toJson(JsonPath.read((String)json, (String)"$.result", (Predicate[])new Predicate[0]));
                    return (Item)this.gson.fromJson(itemJson, Item.class);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return null;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    public boolean deleteItem(String nameOrId) {
        JSONObject item = new JSONObject();
        item.put((Object)"id", (Object)nameOrId);
        String deleteResourceEP = "/api/items/delete";
        for (String restEndpoint : this.restEndpoints) {
            try {
                WebResource tempWebResource = this.jerseyClient.resource(restEndpoint).path(deleteResourceEP);
                ClientResponse resp = (ClientResponse)((WebResource.Builder)((WebResource.Builder)tempWebResource.accept(new String[]{"application/json; charset=UTF-8"}).type("application/json; charset=UTF-8")).header("gcube-token", (Object)this.CKAN_TOKEN)).delete(ClientResponse.class, (Object)item.toJSONString());
                String json = (String)resp.getEntity(String.class);
                System.out.println(json);
                try {
                    return (Boolean)JsonPath.read((String)json, (String)"$.success", (Predicate[])new Predicate[0]);
                }
                catch (Exception ex) {
                    return false;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return false;
    }

    public Item getItem(String name) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"id", (Object)name);
        String listEP = "/api/items/show";
        for (String restEndpoint : this.restEndpoints) {
            try {
                WebResource tempWebResource = this.jerseyClient.resource(restEndpoint).path(listEP).queryParams((MultivaluedMap)params);
                ClientResponse resp = (ClientResponse)((WebResource.Builder)tempWebResource.accept(new String[]{"application/json; charset=UTF-8"}).header("gcube-token", (Object)this.CKAN_TOKEN)).get(ClientResponse.class);
                String json = (String)resp.getEntity(String.class);
                try {
                    String itemJson = this.gson.toJson(JsonPath.read((String)json, (String)"$.result", (Predicate[])new Predicate[0]));
                    return (Item)this.gson.fromJson(itemJson, Item.class);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return null;
                }
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public List<Resource> getItemResources(String name) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"id", (Object)name);
        String listEP = "/api/items/show";
        for (String restEndpoint : this.restEndpoints) {
            try {
                WebResource tempWebResource = this.jerseyClient.resource(restEndpoint).path(listEP).queryParams((MultivaluedMap)params);
                ClientResponse resp = (ClientResponse)tempWebResource.header("gcube-token", (Object)this.CKAN_TOKEN).get(ClientResponse.class);
                String json = (String)resp.getEntity(String.class);
                if (!((Boolean)JsonPath.read((String)json, (String)"$.success", (Predicate[])new Predicate[0])).booleanValue()) {
                    return new ArrayList<Resource>();
                }
                JSONArray resources = (JSONArray)JsonPath.read((String)json, (String)"$.result.resources[*]", (Predicate[])new Predicate[0]);
                return resources.stream().map(obj -> this.gson.toJson(obj)).map(resourceJson -> (Resource)this.gson.fromJson(resourceJson, Resource.class)).collect(Collectors.toList());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public Resource createItemResource(Resource resource) {
        JSONObject item = new JSONObject();
        item.put((Object)"package_id", (Object)resource.getPackage_id());
        item.put((Object)"url", (Object)resource.getUrl());
        item.put((Object)"description", (Object)resource.getDescription());
        item.put((Object)"name", (Object)resource.getName());
        String createResourceEP = "/api/resources/create";
        for (String restEndpoint : this.restEndpoints) {
            try {
                WebResource tempWebResource = this.jerseyClient.resource(restEndpoint).path(createResourceEP);
                ClientResponse resp = (ClientResponse)((WebResource.Builder)((WebResource.Builder)tempWebResource.accept(new String[]{"application/json; charset=UTF-8"}).type("application/json; charset=UTF-8")).header("gcube-token", (Object)this.CKAN_TOKEN)).post(ClientResponse.class, (Object)item.toJSONString());
                String json = (String)resp.getEntity(String.class);
                try {
                    String resourceJson = this.gson.toJson(JsonPath.read((String)json, (String)"$.result", (Predicate[])new Predicate[0]));
                    return (Resource)this.gson.fromJson(resourceJson, Resource.class);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return null;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    public String deleteItemResource(String resourceID) {
        JSONObject item = new JSONObject();
        item.put((Object)"id", (Object)resourceID);
        String deleteResourceEP = "/api/resources/delete";
        for (String restEndpoint : this.restEndpoints) {
            try {
                WebResource tempWebResource = this.jerseyClient.resource(restEndpoint).path(deleteResourceEP);
                ClientResponse resp = (ClientResponse)((WebResource.Builder)((WebResource.Builder)tempWebResource.accept(new String[]{"application/json; charset=UTF-8"}).type("application/json; charset=UTF-8")).header("gcube-token", (Object)this.CKAN_TOKEN)).delete(ClientResponse.class, (Object)item.toJSONString());
                String json = (String)resp.getEntity(String.class);
                return json;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    public List<String> getItemResourcesIDs(String name) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.add((Object)"id", (Object)name);
        String listEP = "/api/items/show";
        for (String restEndpoint : this.restEndpoints) {
            try {
                WebResource tempWebResource = this.jerseyClient.resource(restEndpoint).path(listEP).queryParams((MultivaluedMap)params);
                ClientResponse resp = (ClientResponse)((WebResource.Builder)tempWebResource.accept(new String[]{"application/json; charset=UTF-8"}).header("gcube-token", (Object)this.CKAN_TOKEN)).get(ClientResponse.class);
                String json = (String)resp.getEntity(String.class);
                List resources = (List)JsonPath.read((String)json, (String)"$.result.resources[*].id", (Predicate[])new Predicate[0]);
                return resources;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    private String getProfileType(String profileName) {
        try {
            String profileXML = this.getProfile(profileName);
            ByteArrayInputStream is = new ByteArrayInputStream(profileXML.getBytes(StandardCharsets.UTF_8.name()));
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = builderFactory.newDocumentBuilder();
            Document xmlDocument = builder.parse(is);
            XPath xPath = XPathFactory.newInstance().newXPath();
            String expression = "/metadataformat";
            NodeList nodeList = (NodeList)xPath.compile(expression).evaluate(xmlDocument, XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                if (!nodeList.item(i).getNodeName().equals("metadataformat")) continue;
                return nodeList.item(i).getAttributes().getNamedItem("type").getNodeValue();
            }
            logger.info("COULD NOT FIND THE PROFILE TYPE FOR THE GIVEN PROFILE NAME: " + profileName + " Expect FAILURE of CKAN POSTING");
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) throws Exception {
        CKANBridge bridge = new CKANBridge();
        System.out.println(bridge.listProfiles());
    }
}

