/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.index.service.helpers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.bucket.terms.DoubleTerms;
import org.elasticsearch.search.aggregations.bucket.terms.LongTerms;
import org.elasticsearch.search.aggregations.bucket.terms.StringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.UnmappedTerms;
import org.gcube.rest.index.common.search.SearchResult;
import org.gcube.rest.index.common.search.Search_Response;
import org.gcube.rest.index.common.search.facets.Facet;
import org.gcube.rest.index.common.search.facets.Facets;

public class IndexResponseFunctions {
    public static Search_Response buildSearchResponse(SearchRequestBuilder search_results, Map<String, Map<String, String>> inversedMapAlias, Map<String, List<String>> flatInversedMapAlias, boolean noneFacetType) {
        SearchHit[] search_hits;
        SearchResponse response = (SearchResponse)search_results.execute().actionGet();
        long totalHits = response.getHits().getTotalHits();
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        for (SearchHit hit : search_hits = response.getHits().getHits()) {
            Map source_alias_map = hit.getSource();
            HashMap source_map = new HashMap();
            for (String fieldName2 : source_alias_map.keySet()) {
                Object fieldValue = source_alias_map.get(fieldName2);
                Map<String, String> collection_inversed_alias = inversedMapAlias.get(hit.getIndex());
                if (collection_inversed_alias != null) {
                    String fieldAliasName = collection_inversed_alias.get(fieldName2);
                    if (fieldAliasName == null) {
                        source_map.put(fieldName2, fieldValue);
                        continue;
                    }
                    source_map.put(fieldAliasName, fieldValue);
                    continue;
                }
                source_map.put(fieldName2, fieldValue);
            }
            SearchResult searchResult = new SearchResult(hit.getId(), hit.getIndex(), source_map);
            results.add(searchResult);
        }
        Search_Response searchResponse = new Search_Response();
        searchResponse.setTotalHits(totalHits);
        searchResponse.setSearchResultList(results);
        if (!noneFacetType) {
            Map aggregations = response.getAggregations().getAsMap();
            Facets facets = new Facets();
            aggregations.forEach((fieldName, terms) -> {
                Facet facet = new Facet();
                List buckets = terms instanceof StringTerms ? ((StringTerms)terms).getBuckets() : (terms instanceof DoubleTerms ? ((DoubleTerms)terms).getBuckets() : (terms instanceof LongTerms ? ((LongTerms)terms).getBuckets() : ((UnmappedTerms)terms).getBuckets()));
                buckets.forEach(bucket -> facet.addPair(bucket.getKeyAsString(), bucket.getDocCount()));
                List inversedAlias = (List)flatInversedMapAlias.get(fieldName);
                if (inversedAlias != null) {
                    String fieldAliasName = (String)inversedAlias.get(0);
                    facets.addFacet(fieldAliasName, facet);
                } else {
                    facets.addFacet(fieldName, facet);
                }
            });
            searchResponse.setFacets(facets);
        }
        return searchResponse;
    }
}

