/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.index.service.resources;

import com.google.common.io.Resources;
import com.google.gson.Gson;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.gcube.elasticsearch.FullTextNode;
import org.gcube.rest.commons.resourceawareservice.resources.ResourceFactory;
import org.gcube.rest.commons.resourceawareservice.resources.exceptions.StatefulResourceException;
import org.gcube.rest.index.common.resources.IndexResource;
import org.gcube.rest.index.service.IndexClientWrapper;
import org.gcube.rest.resourceawareservice.exceptions.ResourceNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class IndexResourceFactory
extends ResourceFactory<IndexResource> {
    private static final Logger logger = LoggerFactory.getLogger(IndexResourceFactory.class);
    private static final String DEFAULT_SAME_CLUSTER_PROP = "defaultSameCluster";
    private Map<String, IndexClientWrapper> indexClientWrappers = new ConcurrentHashMap();
    private Provider<IndexClientWrapper> ftnClientProvider;

    @Inject
    public IndexResourceFactory(Provider<IndexClientWrapper> ftnClientProvider) {
        this.ftnClientProvider = ftnClientProvider;
    }

    public FullTextNode getIndexNode(IndexResource resource) throws ResourceNotFoundException {
        if (!this.indexClientWrappers.containsKey(resource.getResourceID())) {
            throw new ResourceNotFoundException("resource with id : " + resource.getResourceID() + " not in map factory : " + this.indexClientWrappers.keySet());
        }
        return ((IndexClientWrapper)this.indexClientWrappers.get(resource.getResourceID())).getFullTextNode();
    }

    public IndexResource createResource(String resourceID, String params) throws StatefulResourceException {
        logger.info("IndexResource createResource");
        IndexResource resource = (IndexResource)new Gson().fromJson(params, IndexResource.class);
        if (resource.getScope() != null && !resource.getScope().equalsIgnoreCase(this.getScope())) {
            logger.error("scope set to : " + resource.getScope() + " but different to : " + this.getScope());
            throw new StatefulResourceException("scope set to : " + resource.getScope() + " but different to : " + this.getScope());
        }
        resource.setResourceID(resourceID);
        logger.info("IndexClientWrapper initializing");
        IndexClientWrapper clientWrapper = (IndexClientWrapper)this.ftnClientProvider.get();
        IndexResourceFactory.initICWToResource((IndexClientWrapper)clientWrapper, (IndexResource)resource);
        this.indexClientWrappers.put(resourceID, clientWrapper);
        resource.setHostname(clientWrapper.getFullTextNode().getHostname());
        logger.info("hostname set to resource : " + resource.getHostname());
        return resource;
    }

    public void loadResource(IndexResource resource) throws StatefulResourceException {
        logger.info("IndexResource loadResource");
        if (resource.getScope() != null && !resource.getScope().equalsIgnoreCase(this.getScope())) {
            logger.error("scope set to : " + resource.getScope() + " but different to : " + this.getScope());
            throw new StatefulResourceException("scope set to : " + resource.getScope() + " but different to : " + this.getScope());
        }
        logger.info("IndexClientWrapper loading");
        IndexClientWrapper clientWrapper = (IndexClientWrapper)this.ftnClientProvider.get();
        IndexResourceFactory.loadICWToResource((IndexClientWrapper)clientWrapper, (IndexResource)resource);
        resource.setHostname(clientWrapper.getFullTextNode().getHostname());
        logger.info("hostname set to resource : " + resource.getHostname());
        resource.onLoad();
        this.indexClientWrappers.put(resource.getResourceID(), clientWrapper);
    }

    public void closeResource(IndexResource resource) throws StatefulResourceException {
        IndexClientWrapper icw = (IndexClientWrapper)this.indexClientWrappers.get(resource.getResourceID());
        logger.info("Closing index...");
        icw.getFullTextNode().close();
        logger.info("Closing index...OK");
        this.indexClientWrappers.remove(resource.getResourceID());
    }

    public void destroyResource(IndexResource resource) throws StatefulResourceException {
        IndexClientWrapper icw = (IndexClientWrapper)this.indexClientWrappers.get(resource.getResourceID());
        try {
            logger.info("Deleting index");
            icw.getFullTextNode().deleteIndex();
        }
        catch (Exception e) {
            logger.error("Error while deleting the index. Maybe it does not exist", (Throwable)e);
            throw new StatefulResourceException("Error while deleting the index. Maybe it does not exist", e);
        }
        finally {
            this.closeResource(resource);
        }
    }

    private static void initICWToResource(IndexClientWrapper indexClientWrapper, IndexResource resource) throws StatefulResourceException {
        if (resource.getIndexID() == null || resource.getIndexID().trim().length() == 0) {
            logger.info("No indexID given, assigning a new one: " + resource.getResourceID());
            resource.setIndexID(resource.getResourceID());
        }
        String transformedClusterName = IndexResourceFactory.transformClusterName((String)resource.getClusterID(), (String)resource.getResourceID(), (String)resource.getScope());
        resource.setClusterID(IndexResourceFactory.changeClusterID((String)resource.getClusterID(), (String)resource.getResourceID(), (String)resource.getScope()));
        try {
            logger.info("initializing FullTextNodeClient : ");
            indexClientWrapper.initialize(transformedClusterName, resource.getClusterID());
        }
        catch (Exception e) {
            throw new StatefulResourceException("error while initializing the fulltext index client", e);
        }
        String transportAddress = indexClientWrapper.getFullTextNode().getESTransportAddress();
        resource.setEsTransportAddress(transportAddress);
        logger.info("getting meta index values for existing index");
        List collectionsOfMetaIndex = indexClientWrapper.getFullTextNode().getCollectionOfIndex();
        List fieldsOfMetaIndex = indexClientWrapper.getFullTextNode().getFieldsOfIndex();
        if (collectionsOfMetaIndex != null && fieldsOfMetaIndex != null) {
            resource.setCollections(collectionsOfMetaIndex);
            resource.setFields(fieldsOfMetaIndex);
        } else {
            resource.setCollections(Collections.emptyList());
            resource.setFields(Collections.emptyList());
        }
        resource.setSupportedRelations(IndexResource.getSupportedRelationsSet());
    }

    private static void loadICWToResource(IndexClientWrapper indexClientWrapper, IndexResource resource) throws StatefulResourceException {
        String transformedClusterName = IndexResourceFactory.transformClusterName((String)resource.getClusterID(), (String)resource.getResourceID(), (String)resource.getScope());
        resource.setClusterID(IndexResourceFactory.changeClusterID((String)resource.getClusterID(), (String)resource.getResourceID(), (String)resource.getScope()));
        try {
            logger.info("initializing FullTextNodeClient : ");
            indexClientWrapper.initialize(transformedClusterName, resource.getClusterID());
        }
        catch (Exception e) {
            throw new StatefulResourceException("error while initializing the fulltext index client", e);
        }
        String transportAddress = indexClientWrapper.getFullTextNode().getESTransportAddress();
        resource.setEsTransportAddress(transportAddress);
        logger.info("getting meta index values for existing index");
        List collectionsOfMetaIndex = indexClientWrapper.getFullTextNode().getCollectionOfIndex();
        List fieldsOfMetaIndex = indexClientWrapper.getFullTextNode().getFieldsOfIndex();
        if (collectionsOfMetaIndex != null && fieldsOfMetaIndex != null) {
            resource.setCollections(collectionsOfMetaIndex);
            resource.setFields(fieldsOfMetaIndex);
        } else {
            resource.setCollections(Collections.emptyList());
            resource.setFields(Collections.emptyList());
        }
        resource.setSupportedRelations(IndexResource.getSupportedRelationsSet());
    }

    private static String transformClusterName(String initClusterID, String resourceID, String scope) {
        logger.info("calling transformedClusterName for parameters. initClusterID : " + initClusterID + ", resourceID : " + resourceID + ", scope : " + scope);
        String clusterName = IndexResourceFactory.changeClusterID((String)initClusterID, (String)resourceID, (String)scope);
        String ret = "es-cluster-" + scope + "-" + clusterName;
        ret = ret.replace("/", "-");
        logger.info("transformedClusterName : " + ret);
        return ret;
    }

    static String changeClusterID(String initClusterID, String resourceID, String scope) {
        Properties properties = new Properties();
        try (InputStream is = Resources.getResource((String)"deploy.properties").openStream();){
            properties.load(is);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("could not load property file  : deploy.properties");
        }
        Boolean defaultSameCluster = Boolean.valueOf(properties.getProperty("defaultSameCluster"));
        String clusterName = null;
        clusterName = initClusterID != null ? initClusterID : (defaultSameCluster == true ? "default-cluster-name" : resourceID);
        return clusterName;
    }
}

