/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.index.client.tasks;

import java.util.List;
import org.gcube.rest.index.client.internals.EndpointsHelper;
import org.quartz.InterruptableJob;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.SchedulerContext;
import org.quartz.SchedulerException;
import org.quartz.UnableToInterruptJobException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateEndpoints
implements InterruptableJob {
    private static final Logger logger = LoggerFactory.getLogger(UpdateEndpoints.class);

    public void execute(JobExecutionContext context) throws JobExecutionException {
        SchedulerContext schedulerContext = null;
        try {
            schedulerContext = context.getScheduler().getContext();
        }
        catch (SchedulerException e) {
            logger.warn("UpdateEndpoints could not get the current endpoint instances. Will not update endpoint list!");
        }
        String scope = context.getJobDetail().getJobDataMap().getString("scope");
        List endpoints = (List)schedulerContext.get((Object)("endpoints-" + scope));
        List<String> latestEndpoints = EndpointsHelper.getEndpointsOfScope(scope);
        endpoints.clear();
        for (String ep : latestEndpoints) {
            endpoints.add(ep);
        }
    }

    public void interrupt() throws UnableToInterruptJobException {
        Thread.currentThread().interrupt();
    }
}

