/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.rest.index.client.cache;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.rest.index.client.exceptions.BadCallException;
import org.gcube.rest.index.client.exceptions.IndexException;
import org.gcube.rest.index.client.exceptions.NoAvailableIndexServiceInstance;
import org.gcube.rest.index.client.globals.EndpointProvider;
import org.gcube.rest.index.common.discover.exceptions.IndexDiscoverException;
import org.gcube.rest.index.common.entities.CollectionInfo;
import org.gcube.rest.index.common.entities.fields.Field;
import org.gcube.rest.index.common.search.Query;
import org.gcube.rest.index.common.search.Search_Response;
import org.gcube.rest.index.common.tools.Toolbox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;

public class IndexClient {
    private static Gson prettygson = new GsonBuilder().setPrettyPrinting().create();
    private Client jerseyClient;
    private EndpointProvider endpointProvider = null;
    private String scope = null;
    private static final Logger logger = LoggerFactory.getLogger(IndexClient.class);

    protected IndexClient() {
    }

    public void initiateClient(String scope) {
        this.scope = scope;
        this.jerseyClient = Client.create();
        this.endpointProvider = new EndpointProvider(scope);
        logger.debug("Found " + this.endpointProvider.endpointsNumber() + " index endpoints");
    }

    public EndpointProvider getEndpointProvider() {
        return this.endpointProvider;
    }

    @Deprecated
    public boolean createEmptyIndex(CollectionInfo collectionInfo) throws NoAvailableIndexServiceInstance {
        if (!collectionInfo.isValid()) {
            logger.debug("Trying to create an index with the following invalid collectionInfo: " + collectionInfo.toString());
            return false;
        }
        int code = -1;
        while (this.endpointProvider.endpointsNumber() > 0) {
            String ep = "";
            try {
                ep = this.endpointProvider.getAnEndpoint();
                WebResource webResource = this.jerseyClient.resource(ep);
                WebResource tempWebResource = webResource.path("createEmptyIndex");
                MultivaluedMapImpl formData = new MultivaluedMapImpl();
                formData.add((Object)"cci", (Object)prettygson.toJson((Object)collectionInfo));
                ClientResponse resp = (ClientResponse)((WebResource.Builder)tempWebResource.type("application/x-www-form-urlencoded; charset=UTF-8").header("gcube-scope", (Object)this.scope)).post(ClientResponse.class, (Object)formData);
                resp.close();
                if (resp.getStatus() != ClientResponse.Status.CREATED.getStatusCode()) {
                    throw new IndexException("Index endpoint at \"" + ep + "\" is not functional. Blacklisting and using another (if available) endpoint");
                }
                return resp.getStatus() == ClientResponse.Status.CREATED.getStatusCode();
            }
            catch (ClientHandlerException | UniformInterfaceException | IndexException ex) {
                logger.debug("Endpoint \"" + ep + "\" seems to be dead. Will be blacklisted for a while");
                this.endpointProvider.remove(ep);
            }
            catch (IndexDiscoverException e) {
                logger.error("No index service found on scope " + this.scope);
            }
        }
        throw new NoAvailableIndexServiceInstance("There are no available index services within scope " + this.scope);
    }

    public boolean reIndex(CollectionInfo collectionInfo) throws NoAvailableIndexServiceInstance {
        if (!collectionInfo.isValid()) {
            logger.debug("Trying to reindex a collection with the following invalid collectionInfo: " + collectionInfo.toString());
            return false;
        }
        int code = -1;
        while (this.endpointProvider.endpointsNumber() > 0) {
            String ep = "";
            try {
                ep = this.endpointProvider.getAnEndpoint();
                WebResource webResource = this.jerseyClient.resource(ep);
                WebResource tempWebResource = webResource.path("reIndex");
                MultivaluedMapImpl formData = new MultivaluedMapImpl();
                formData.add((Object)"cci", (Object)prettygson.toJson((Object)collectionInfo));
                ClientResponse resp = (ClientResponse)((WebResource.Builder)tempWebResource.type("application/x-www-form-urlencoded; charset=UTF-8").header("gcube-scope", (Object)this.scope)).post(ClientResponse.class, (Object)formData);
                resp.close();
                if (resp.getStatus() != ClientResponse.Status.OK.getStatusCode()) {
                    throw new IndexException("Index endpoint at \"" + ep + "\" is not functional. Blacklisting and using another (if available) endpoint");
                }
                return resp.getStatus() == ClientResponse.Status.OK.getStatusCode();
            }
            catch (ClientHandlerException | UniformInterfaceException | IndexException ex) {
                logger.debug("Endpoint \"" + ep + "\" seems to be dead. Will be blacklisted for a while");
                this.endpointProvider.remove(ep);
            }
            catch (IndexDiscoverException e) {
                logger.error("No index service found on scope " + this.scope);
            }
        }
        throw new NoAvailableIndexServiceInstance("There are no available index services within scope " + this.scope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getCollections(String collectionDomain) throws NoAvailableIndexServiceInstance {
        while (this.endpointProvider.endpointsNumber() > 0) {
            List list;
            String ep = "";
            ep = this.endpointProvider.getAnEndpoint();
            WebResource webResource = this.jerseyClient.resource(ep);
            WebResource tempWebResource = webResource.path("listCollections").queryParam("collectionDomain", collectionDomain);
            ClientResponse resp = (ClientResponse)((WebResource.Builder)tempWebResource.accept(new String[]{"application/xml; charset=UTF-8"}).header("gcube-scope", (Object)this.scope)).get(ClientResponse.class);
            if (resp.getStatus() != ClientResponse.Status.OK.getStatusCode()) {
                throw new IndexException("Index endpoint at \"" + ep + "\" is not functional. Blacklisting and using another (if available) endpoint");
            }
            try {
                list = (List)prettygson.fromJson((String)resp.getEntity(String.class), new TypeToken<List<String>>(){}.getType());
            }
            catch (JsonSyntaxException jsonExcep) {
                ArrayList<String> arrayList;
                try {
                    logger.debug("Could not deserialise datasources list. List empty?");
                    arrayList = new ArrayList<String>();
                }
                catch (Throwable throwable) {
                    try {
                        resp.close();
                        throw throwable;
                    }
                    catch (ClientHandlerException | UniformInterfaceException | IndexException ex) {
                        logger.debug("Endpoint \"" + ep + "\" seems to be dead. Will be blacklisted for a while");
                        this.endpointProvider.remove(ep);
                    }
                    catch (IndexDiscoverException e) {
                        logger.error("No index service found on scope " + this.scope);
                    }
                }
                resp.close();
                return arrayList;
            }
            resp.close();
            return list;
        }
        throw new NoAvailableIndexServiceInstance("There are no available index services within scope " + this.scope);
    }

    public Map<String, List<Field>> getAllCollectionFields(String collectionDomain) throws NoAvailableIndexServiceInstance {
        while (this.endpointProvider.endpointsNumber() > 0) {
            String ep = "";
            try {
                ep = this.endpointProvider.getAnEndpoint();
                WebResource webResource = this.jerseyClient.resource(ep);
                WebResource tempWebResource = webResource.path("getAllCollectionFields").queryParam("aliasFields", Boolean.toString(true)).queryParam("collectionDomain", collectionDomain);
                ClientResponse resp = (ClientResponse)tempWebResource.header("gcube-scope", (Object)this.scope).get(ClientResponse.class);
                if (resp.getStatus() != ClientResponse.Status.OK.getStatusCode()) {
                    throw new IndexException("Index endpoint at \"" + ep + "\" is not functional. Blacklisting and using another (if available) endpoint");
                }
                HashMap<String, List<Field>> result = new HashMap();
                result = (Map)prettygson.fromJson((String)resp.getEntity(String.class), new TypeToken<Map<String, List<Field>>>(){}.getType());
                resp.close();
                return result;
            }
            catch (JsonSyntaxException | ClientHandlerException | UniformInterfaceException | IndexException ex) {
                logger.debug("Endpoint \"" + ep + "\" seems to be dead. Will be blacklisted for a while");
                this.endpointProvider.remove(ep);
            }
            catch (IndexDiscoverException e) {
                logger.error("No index service found on scope " + this.scope);
            }
        }
        throw new NoAvailableIndexServiceInstance("There are no available index services within scope " + this.scope);
    }

    public boolean insertJson(String domain, String collectionID, String recordID, String recordJSON) throws NoAvailableIndexServiceInstance {
        while (this.endpointProvider.endpointsNumber() > 0) {
            String ep = "";
            try {
                ep = this.endpointProvider.getAnEndpoint();
                WebResource webResource = this.jerseyClient.resource(ep);
                WebResource tempWebResource = webResource.path("insert").path(collectionID).path(recordID).queryParam("domain", domain);
                MultivaluedMapImpl formData = new MultivaluedMapImpl();
                formData.add((Object)"recordJSON", (Object)recordJSON);
                ClientResponse resp = (ClientResponse)((WebResource.Builder)tempWebResource.type("application/x-www-form-urlencoded; charset=UTF-8").header("gcube-scope", (Object)this.scope)).post(ClientResponse.class, (Object)formData);
                int code = resp.getStatus();
                if (code != ClientResponse.Status.NO_CONTENT.getStatusCode() && code != ClientResponse.Status.CREATED.getStatusCode()) {
                    throw new IndexException("Index endpoint at \"" + ep + "\" is not functional. Blacklisting and using another (if available) endpoint");
                }
                resp.close();
                return code == ClientResponse.Status.CREATED.getStatusCode();
            }
            catch (ClientHandlerException | UniformInterfaceException | IndexException ex) {
                logger.debug("Endpoint \"" + ep + "\" seems to be dead. Will be blacklisted for a while");
                this.endpointProvider.remove(ep);
            }
            catch (IndexDiscoverException e) {
                logger.error("No index service found on scope " + this.scope);
            }
        }
        throw new NoAvailableIndexServiceInstance("There are no available index services within scope " + this.scope);
    }

    public boolean insertJson(String domain, String collectionID, String recordJSON) throws NoAvailableIndexServiceInstance {
        while (this.endpointProvider.endpointsNumber() > 0) {
            String ep = "";
            try {
                ep = this.endpointProvider.getAnEndpoint();
                WebResource webResource = this.jerseyClient.resource(ep);
                WebResource tempWebResource = webResource.path("insert").path(collectionID).queryParam("domain", domain);
                MultivaluedMapImpl formData = new MultivaluedMapImpl();
                formData.add((Object)"recordJSON", (Object)recordJSON);
                ClientResponse resp = (ClientResponse)((WebResource.Builder)tempWebResource.type("application/x-www-form-urlencoded; charset=UTF-8").header("gcube-scope", (Object)this.scope)).post(ClientResponse.class, (Object)formData);
                int code = resp.getStatus();
                if (code != ClientResponse.Status.CREATED.getStatusCode()) {
                    throw new IndexException("Index endpoint at \"" + ep + "\" is not functional. Blacklisting and using another (if available) endpoint");
                }
                resp.close();
                return code == ClientResponse.Status.CREATED.getStatusCode();
            }
            catch (ClientHandlerException | UniformInterfaceException | IndexException ex) {
                logger.debug("Endpoint \"" + ep + "\" seems to be dead. Will be blacklisted for a while");
                this.endpointProvider.remove(ep);
            }
            catch (IndexDiscoverException e) {
                logger.error("No index service found on scope " + this.scope);
            }
        }
        throw new NoAvailableIndexServiceInstance("There are no available index services within scope " + this.scope);
    }

    public boolean delete(String collectionID, String recordID) throws NoAvailableIndexServiceInstance {
        while (this.endpointProvider.endpointsNumber() > 0) {
            String ep = "";
            try {
                ep = this.endpointProvider.getAnEndpoint();
                WebResource webResource = this.jerseyClient.resource(ep);
                WebResource tempWebResource = webResource.path("delete").path(collectionID).path(recordID);
                ClientResponse resp = (ClientResponse)tempWebResource.header("gcube-scope", (Object)this.scope).delete(ClientResponse.class);
                int code = resp.getStatus();
                if (code != ClientResponse.Status.OK.getStatusCode()) {
                    throw new IndexException("Index endpoint at \"" + ep + "\" is not functional. Blacklisting and using another (if available) endpoint");
                }
                resp.close();
                return code == ClientResponse.Status.OK.getStatusCode();
            }
            catch (ClientHandlerException | UniformInterfaceException | IndexException ex) {
                logger.debug("Endpoint \"" + ep + "\" seems to be dead. Will be blacklisted for a while");
                this.endpointProvider.remove(ep);
            }
            catch (IndexDiscoverException e) {
                logger.error("No index service found on scope " + this.scope);
            }
        }
        throw new NoAvailableIndexServiceInstance("There are no available index services within scope " + this.scope);
    }

    public boolean dropCollection(String collectionID) throws NoAvailableIndexServiceInstance {
        this.clearCompletelyCache();
        while (this.endpointProvider.endpointsNumber() > 0) {
            String ep = "";
            try {
                ep = this.endpointProvider.getAnEndpoint();
                WebResource webResource = this.jerseyClient.resource(ep);
                WebResource tempWebResource = webResource.path("dropCollection").path(collectionID);
                ClientResponse resp = (ClientResponse)tempWebResource.header("gcube-scope", (Object)this.scope).delete(ClientResponse.class);
                int code = resp.getStatus();
                if (code != ClientResponse.Status.OK.getStatusCode()) {
                    throw new IndexException("Index endpoint at \"" + ep + "\" is not functional. Blacklisting and using another (if available) endpoint");
                }
                resp.close();
                return code == 200;
            }
            catch (ClientHandlerException | UniformInterfaceException | IndexException ex) {
                logger.debug("Endpoint \"" + ep + "\" seems to be dead. Will be blacklisted for a while");
                this.endpointProvider.remove(ep);
            }
            catch (IndexDiscoverException e) {
                logger.error("No index service found on scope " + this.scope);
            }
        }
        throw new NoAvailableIndexServiceInstance("There are no available index services within scope " + this.scope);
    }

    @Deprecated
    public boolean setCollectionFieldsAlias(String collectionID, Map<String, String> fieldAlias) throws NoAvailableIndexServiceInstance {
        this.clearCompletelyCache();
        while (this.endpointProvider.endpointsNumber() > 0) {
            String ep = "";
            try {
                ep = this.endpointProvider.getAnEndpoint();
                WebResource webResource = this.jerseyClient.resource(ep);
                WebResource tempWebResource = webResource.path("setCollectionFieldsAlias").queryParam("collectionID", collectionID);
                String fieldAliasJSON = prettygson.toJson(fieldAlias);
                MultivaluedMapImpl formData = new MultivaluedMapImpl();
                formData.add((Object)"mappingsJSON", (Object)fieldAliasJSON);
                ClientResponse resp = (ClientResponse)((WebResource.Builder)tempWebResource.type("application/x-www-form-urlencoded").header("gcube-scope", (Object)this.scope)).post(ClientResponse.class, (Object)formData);
                int code = resp.getStatus();
                if (code != ClientResponse.Status.CREATED.getStatusCode() && code != ClientResponse.Status.NO_CONTENT.getStatusCode()) {
                    throw new IndexException("Index endpoint at \"" + ep + "\" is not functional. Blacklisting and using another (if available) endpoint");
                }
                resp.close();
                return code == ClientResponse.Status.CREATED.getStatusCode();
            }
            catch (ClientHandlerException | UniformInterfaceException | IndexException ex) {
                logger.debug("Endpoint \"" + ep + "\" seems to be dead. Will be blacklisted for a while");
                this.endpointProvider.remove(ep);
            }
            catch (IndexDiscoverException e) {
                logger.error("No index service found on scope " + this.scope);
            }
        }
        throw new NoAvailableIndexServiceInstance("There are no available index services within scope " + this.scope);
    }

    @Deprecated
    public boolean deleteCollectionFieldsAlias(String collectionID) throws NoAvailableIndexServiceInstance {
        this.clearCompletelyCache();
        while (this.endpointProvider.endpointsNumber() > 0) {
            String ep = "";
            try {
                ep = this.endpointProvider.getAnEndpoint();
                WebResource webResource = this.jerseyClient.resource(ep);
                WebResource tempWebResource = webResource.path("deleteCollectionFieldsAlias").queryParam("collectionID", collectionID);
                ClientResponse resp = (ClientResponse)tempWebResource.header("gcube-scope", (Object)this.scope).delete(ClientResponse.class);
                int code = resp.getStatus();
                if (code != ClientResponse.Status.OK.getStatusCode()) {
                    throw new IndexException("Index endpoint at \"" + ep + "\" is not functional. Blacklisting and using another (if available) endpoint");
                }
                resp.close();
                return code == 200;
            }
            catch (ClientHandlerException | UniformInterfaceException | IndexException ex) {
                logger.debug("Endpoint \"" + ep + "\" seems to be dead. Will be blacklisted for a while");
                this.endpointProvider.remove(ep);
            }
            catch (IndexDiscoverException e) {
                logger.error("No index service found on scope " + this.scope);
            }
        }
        throw new NoAvailableIndexServiceInstance("There are no available index services within scope " + this.scope);
    }

    @Deprecated
    public Map<String, Map<String, String>> getCollectionFieldsAlias(String collectionID, boolean fromIndexToView, String collectionDomain) throws NoAvailableIndexServiceInstance {
        while (this.endpointProvider.endpointsNumber() > 0) {
            String ep = "";
            try {
                WebResource webResource;
                WebResource tempWebResource;
                ClientResponse resp;
                ep = this.endpointProvider.getAnEndpoint();
                if (collectionID == null || collectionID.isEmpty()) {
                    collectionID = "";
                }
                if ((resp = (ClientResponse)(tempWebResource = (webResource = this.jerseyClient.resource(ep)).path("getCollectionFieldsAlias").queryParam("collectionID", collectionID).queryParam("fromIndexToView", Boolean.toString(fromIndexToView)).queryParam("collectionDomain", collectionDomain)).header("gcube-scope", (Object)this.scope).get(ClientResponse.class)).getStatus() != ClientResponse.Status.OK.getStatusCode()) {
                    throw new IndexException("Index endpoint at \"" + ep + "\" is not functional. Blacklisting and using another (if available) endpoint");
                }
                String jsonCollFieldsAlias = (String)resp.getEntity(String.class);
                resp.close();
                if (jsonCollFieldsAlias == null || jsonCollFieldsAlias.isEmpty()) {
                    return new HashMap<String, Map<String, String>>();
                }
                return (Map)prettygson.fromJson(jsonCollFieldsAlias, new TypeToken<Map<String, Map<String, String>>>(){}.getType());
            }
            catch (ClientHandlerException | UniformInterfaceException | IndexException ex) {
                logger.debug("Endpoint \"" + ep + "\" seems to be dead. Will be blacklisted for a while");
                this.endpointProvider.remove(ep);
            }
            catch (IndexDiscoverException e) {
                logger.error("No index service found on scope " + this.scope);
            }
        }
        throw new NoAvailableIndexServiceInstance("There are no available index services within scope " + this.scope);
    }

    public List<CollectionInfo> getCompleteCollectionInfo(String collectionID, String collectionDomain) throws NoAvailableIndexServiceInstance {
        while (this.endpointProvider.endpointsNumber() > 0) {
            String ep = "";
            try {
                WebResource webResource;
                WebResource tempWebResource;
                ClientResponse resp;
                ep = this.endpointProvider.getAnEndpoint();
                if (collectionID == null || collectionID.isEmpty()) {
                    collectionID = "";
                }
                if ((resp = (ClientResponse)((WebResource.Builder)(tempWebResource = (webResource = this.jerseyClient.resource(ep)).path("getCompleteCollectionInfo").queryParam("collectionID", collectionID).queryParam("collectionDomain", collectionDomain)).accept(new String[]{"application/xml; charset=UTF-8"}).header("gcube-scope", (Object)this.scope)).get(ClientResponse.class)).getStatus() != ClientResponse.Status.OK.getStatusCode()) {
                    throw new IndexException("Index endpoint at \"" + ep + "\" is not functional. Blacklisting and using another (if available) endpoint");
                }
                List collectionInfos = (List)resp.getEntity((GenericType)new GenericType<List<CollectionInfo>>(){});
                resp.close();
                return collectionInfos;
            }
            catch (ClientHandlerException | UniformInterfaceException | IndexException ex) {
                logger.debug("Endpoint \"" + ep + "\" seems to be dead. Will be blacklisted for a while");
                this.endpointProvider.remove(ep);
            }
            catch (IndexDiscoverException e) {
                logger.error("No index service found on scope " + this.scope);
            }
        }
        throw new NoAvailableIndexServiceInstance("There are no available index services within scope " + this.scope);
    }

    public boolean setCompleteCollectionInfo(CollectionInfo coll) throws NoAvailableIndexServiceInstance, BadCallException {
        this.clearCompletelyCache();
        while (this.endpointProvider.endpointsNumber() > 0) {
            String ep = "";
            try {
                ep = this.endpointProvider.getAnEndpoint();
                if (coll == null) {
                    logger.error("Cannot setCompleteCollectionInfo to a NULL collection");
                    throw new BadCallException("Cannot setCompleteCollectionInfo to a NULL collection");
                }
                if (coll.getId() == null || coll.getId().isEmpty()) {
                    logger.error("CollectionInfo.getId() is null... That's a problem...");
                    throw new BadCallException("CollectionInfo.getId() is null... That's a problem...");
                }
                WebResource webResource = this.jerseyClient.resource(ep);
                WebResource tempWebResource = webResource.path("setCompleteCollectionInfo");
                MultivaluedMapImpl formData = new MultivaluedMapImpl();
                formData.add((Object)"cci", (Object)prettygson.toJson((Object)coll));
                ClientResponse resp = (ClientResponse)((WebResource.Builder)tempWebResource.type("application/x-www-form-urlencoded; charset=UTF-8").header("gcube-scope", (Object)this.scope)).post(ClientResponse.class, (Object)formData);
                resp.close();
                if (resp.getStatus() != ClientResponse.Status.CREATED.getStatusCode()) {
                    throw new IndexException("Index endpoint at \"" + ep + "\" is not functional. Blacklisting and using another (if available) endpoint");
                }
                return resp.getStatus() == ClientResponse.Status.CREATED.getStatusCode();
            }
            catch (ClientHandlerException | UniformInterfaceException | IndexException ex) {
                logger.debug("Endpoint \"" + ep + "\" seems to be dead. Will be blacklisted for a while");
                this.endpointProvider.remove(ep);
            }
            catch (IndexDiscoverException e) {
                logger.error("No index service found on scope " + this.scope);
            }
        }
        throw new NoAvailableIndexServiceInstance("There are no available index services within scope " + this.scope);
    }

    public boolean deleteCompleteCollectionInfo(String collectionID) throws NoAvailableIndexServiceInstance {
        this.clearCompletelyCache();
        while (this.endpointProvider.endpointsNumber() > 0) {
            String ep = "";
            try {
                ep = this.endpointProvider.getAnEndpoint();
                WebResource webResource = this.jerseyClient.resource(ep);
                WebResource tempWebResource = webResource.path("deleteCompleteCollectionInfo").queryParam("collectionID", collectionID);
                ClientResponse resp = (ClientResponse)tempWebResource.header("gcube-scope", (Object)this.scope).delete(ClientResponse.class);
                int code = resp.getStatus();
                resp.close();
                if (resp.getStatus() != ClientResponse.Status.OK.getStatusCode()) {
                    throw new IndexException("Index endpoint at \"" + ep + "\" is not functional. Blacklisting and using another (if available) endpoint");
                }
                return code == 200;
            }
            catch (ClientHandlerException | UniformInterfaceException | IndexException ex) {
                logger.debug("Endpoint \"" + ep + "\" seems to be dead. Will be blacklisted for a while");
                this.endpointProvider.remove(ep);
            }
            catch (IndexDiscoverException e) {
                logger.error("No index service found on scope " + this.scope);
            }
        }
        throw new NoAvailableIndexServiceInstance("There are no available index services within scope " + this.scope);
    }

    public Search_Response search(Query query) throws NoAvailableIndexServiceInstance {
        while (this.endpointProvider.endpointsNumber() > 0) {
            String ep = "";
            try {
                ep = this.endpointProvider.getAnEndpoint();
                WebResource webResource = this.jerseyClient.resource(ep);
                WebResource tempWebResource = webResource.path("search");
                String queryJson = prettygson.toJson((Object)query);
                queryJson = Toolbox.encode((String)queryJson);
                MultivaluedMapImpl formData = new MultivaluedMapImpl();
                formData.add((Object)"query", (Object)queryJson);
                ClientResponse resp = (ClientResponse)((WebResource.Builder)tempWebResource.type("application/x-www-form-urlencoded; charset=UTF-8").header("gcube-scope", (Object)this.scope)).post(ClientResponse.class, (Object)formData);
                String jsonResults = (String)resp.getEntity(String.class);
                resp.close();
                if (resp.getStatus() != ClientResponse.Status.OK.getStatusCode()) {
                    throw new IndexException("Index endpoint at \"" + ep + "\" is not functional. Blacklisting and using another (if available) endpoint");
                }
                return (Search_Response)prettygson.fromJson(jsonResults, Search_Response.class);
            }
            catch (ClientHandlerException | UniformInterfaceException | IndexException ex) {
                logger.debug("Endpoint \"" + ep + "\" seems to be dead. Will be blacklisted for a while");
                this.endpointProvider.remove(ep);
            }
            catch (IndexDiscoverException e) {
                logger.error("No index service found on scope " + this.scope);
            }
        }
        throw new NoAvailableIndexServiceInstance("There are no available index services within scope " + this.scope);
    }

    @CacheEvict(value={"COMPLETE_COLLECTION_INFOS", "COLLECTIONS_FIELDS_ALIASES", "COLLECTIONS_FIELDS", "COLLECTION_NAMES", "ENDPOINTS", "JSON_TRANSFORMERS"}, allEntries=true, beforeInvocation=true)
    public void clearCompletelyCache() {
    }
}

