package org.gcube.geoindexupdater.client.library.proxies;

import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.geoindexupdater.client.library.beans.Types.CreateResource;
import org.gcube.geoindexupdater.client.library.beans.Types.CreateResourceResponse;
import org.gcube.geoindexupdater.client.library.exceptions.GeoIndexUpdaterException;
import org.gcube.geoindexupdater.client.library.stubs.GeoIndexUpdaterFactoryStub;

public class GeoIndexUpdaterFactoryCLDefaultProxy implements GeoIndexUpdaterFactoryCLProxyI {

	private final ProxyDelegate<GeoIndexUpdaterFactoryStub> delegate;

	public GeoIndexUpdaterFactoryCLDefaultProxy(ProxyDelegate<GeoIndexUpdaterFactoryStub> config) {
		this.delegate = config;
	}

	@Override
	public CreateResourceResponse createResource(final CreateResource createResource) throws GeoIndexUpdaterException {
		Call<GeoIndexUpdaterFactoryStub, CreateResourceResponse> call = new Call<GeoIndexUpdaterFactoryStub, CreateResourceResponse>() {
			@Override
			public CreateResourceResponse call(GeoIndexUpdaterFactoryStub endpoint) throws Exception {
				return endpoint.createResource(createResource);
			}
		};
		try {
			CreateResourceResponse response = delegate.make(call);

			return response;
		} catch (Exception e) {
			throw new GeoIndexUpdaterException(e);
		}
	}
}
