package org.gcube.geoindexupdater.client.library.plugins;

import static org.gcube.common.clients.stubs.jaxws.StubFactory.stubFor;

import javax.xml.ws.EndpointReference;

import org.gcube.common.clients.config.ProxyConfig;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.fw.plugin.Plugin;
import org.gcube.geoindexupdater.client.library.proxies.GeoIndexUpdaterCLDefaultProxy;
import org.gcube.geoindexupdater.client.library.proxies.GeoIndexUpdaterCLProxyI;
import org.gcube.geoindexupdater.client.library.stubs.GeoIndexUpdaterStub;
import org.gcube.geoindexupdater.client.library.utils.GeoIndexUpdaterCLConstants;

/**
 * FullTextIndexNode Client Library plugin exposes information that allows CL Framework
 * components to act on behalf of FullTextIndexNode CL. 
 * 
 * @author p.liakos - DI NKUA
 * 
 */
public class GeoIndexUpdaterCLPlugin implements Plugin<GeoIndexUpdaterStub, GeoIndexUpdaterCLProxyI> {

	@Override
	public String name() {
		return GeoIndexUpdaterCLConstants.NAME;
	}

	@Override
	public String namespace() {
		return GeoIndexUpdaterCLConstants.NAMESPACE;
	}

	@Override
	public String serviceClass() {
		return GeoIndexUpdaterCLConstants.gcubeClass;
	}

	@Override
	public String serviceName() {
		return GeoIndexUpdaterCLConstants.gcubeName;
	}
	
	@Override
	public Exception convert(Exception fault, ProxyConfig<?, ?> config) {
		return fault;
	}

	@Override
	public GeoIndexUpdaterStub resolve(EndpointReference reference,ProxyConfig<?, ?> proxyConfig) throws Exception {
		return stubFor(GeoIndexUpdaterCLConstants.giu).at(reference);
		
	}
	
	@Override
	public GeoIndexUpdaterCLProxyI newProxy(ProxyDelegate<GeoIndexUpdaterStub> delegate) {
		return new GeoIndexUpdaterCLDefaultProxy(delegate);
	}

}
