package org.gcube.geoindexmanagement.client.library.plugins;

import static org.gcube.common.clients.stubs.jaxws.StubFactory.stubFor;

import javax.xml.ws.EndpointReference;

import org.gcube.common.clients.config.ProxyConfig;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.fw.plugin.Plugin;
import org.gcube.geoindexmanagement.client.library.proxies.GeoIndexManagementCLDefaultProxy;
import org.gcube.geoindexmanagement.client.library.proxies.GeoIndexManagementCLProxyI;
import org.gcube.geoindexmanagement.client.library.stubs.GeoIndexManagementStub;
import org.gcube.geoindexmanagement.client.library.utils.GeoIndexManagementCLConstants;

/**
 * FullTextIndexNode Client Library plugin exposes information that allows CL Framework
 * components to act on behalf of FullTextIndexNode CL. 
 * 
 * @author p.liakos - DI NKUA
 * 
 */
public class GeoIndexManagementCLPlugin implements Plugin<GeoIndexManagementStub, GeoIndexManagementCLProxyI> {

	@Override
	public String name() {
		return GeoIndexManagementCLConstants.NAME;
	}

	@Override
	public String namespace() {
		return GeoIndexManagementCLConstants.NAMESPACE;
	}

	@Override
	public String serviceClass() {
		return GeoIndexManagementCLConstants.gcubeClass;
	}

	@Override
	public String serviceName() {
		return GeoIndexManagementCLConstants.gcubeName;
	}
	
	@Override
	public Exception convert(Exception fault, ProxyConfig<?, ?> config) {
		return fault;
	}

	@Override
	public GeoIndexManagementStub resolve(EndpointReference reference,ProxyConfig<?, ?> proxyConfig) throws Exception {
		return stubFor(GeoIndexManagementCLConstants.gim).at(reference);
		
	}
	
	@Override
	public GeoIndexManagementCLProxyI newProxy(ProxyDelegate<GeoIndexManagementStub> delegate) {
		return new GeoIndexManagementCLDefaultProxy(delegate);
	}

}
