package org.gcube.geoindexlookup.client.library.plugins;

import javax.xml.ws.EndpointReference;

import org.gcube.common.clients.config.ProxyConfig;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.fw.plugin.Plugin;
import org.gcube.common.clients.stubs.jaxws.StubFactory;
import org.gcube.geoindexlookup.client.library.proxies.GeoIndexLookupFactoryCLDefaultProxy;
import org.gcube.geoindexlookup.client.library.proxies.GeoIndexLookupFactoryCLProxyI;
import org.gcube.geoindexlookup.client.library.stubs.GeoIndexLookupFactoryStub;
import org.gcube.geoindexlookup.client.library.utils.GeoIndexLookupCLConstants;

/**
 * DTS Client Library plugin exposes information that allows CL Framework
 * components to act on behalf of DTS CL. 
 * 
 * @author john.gerbesiotis - DI NKUA
 * 
 */
public class GeoIndexLookupFactoryCLPlugin implements Plugin<GeoIndexLookupFactoryStub, GeoIndexLookupFactoryCLProxyI> {

	@Override
	public String name() {
		return GeoIndexLookupCLConstants.FACTORYNAME;
	}

	@Override
	public String namespace() {
		return GeoIndexLookupCLConstants.NAMESPACE;
	}

	@Override
	public String serviceClass() {
		return GeoIndexLookupCLConstants.gcubeClass;
	}

	@Override
	public String serviceName() {
		return GeoIndexLookupCLConstants.gcubeName;
	}
	
	@Override
	public Exception convert(Exception fault, ProxyConfig<?, ?> config) {
		return fault;
	}

	@Override
	public GeoIndexLookupFactoryStub resolve(EndpointReference reference, ProxyConfig<?, ?> proxyConfig) throws Exception {
		return StubFactory.stubFor(GeoIndexLookupCLConstants.gilf).at(reference);
	}

	@Override
	public GeoIndexLookupFactoryCLProxyI newProxy(ProxyDelegate<GeoIndexLookupFactoryStub> delegate) {
		return new GeoIndexLookupFactoryCLDefaultProxy(delegate);
	}

}
