package org.gcube.geoindexlookup.client.library.stubs;

import static org.gcube.geoindexlookup.client.library.utils.GeoIndexLookupCLConstants.*;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.jws.soap.SOAPBinding.ParameterStyle;

import org.gcube.common.clients.stubs.jaxws.JAXWSUtils.Empty;
import org.gcube.geoindexlookup.client.library.beans.Types.Destroy;
import org.gcube.geoindexlookup.client.library.beans.Types.SearchPolygon;

@WebService(name = porttypeLN, targetNamespace = porttypeNS)
public interface GeoIndexLookupStub {
	
	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	public String getIndexTypeID(final Empty empty);
	
	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	public Empty setIndexTypeID(final String indexTypeID);

	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	public String search(final SearchPolygon searchPolygon);

	@SOAPBinding(parameterStyle = ParameterStyle.BARE)
	public Empty loadPlugins(final Empty empty);
	
	@WebMethod(operationName = "Destroy")
	@SOAPBinding(parameterStyle = SOAPBinding.ParameterStyle.BARE)
	public void destroy(@WebParam(name = "Destroy", targetNamespace = "http://docs.oasis-open.org/wsrf/2004/06/wsrf-WS-ResourceLifetime-1.2-draft-01.xsd") Destroy destroy);
}
