package org.gcube.geoindexlookup.client.library.proxies;

import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.stubs.jaxws.JAXWSUtils.Empty;
import org.gcube.geoindexlookup.client.library.beans.Types.Destroy;
import org.gcube.geoindexlookup.client.library.beans.Types.SearchPolygon;
import org.gcube.geoindexlookup.client.library.exceptions.GeoIndexLookupException;
import org.gcube.geoindexlookup.client.library.stubs.GeoIndexLookupStub;
import org.gcube.common.clients.Call;

public class GeoIndexLookupCLDefaultProxy implements GeoIndexLookupCLProxyI {

	private final ProxyDelegate<GeoIndexLookupStub> delegate;

	public GeoIndexLookupCLDefaultProxy(ProxyDelegate<GeoIndexLookupStub> config) {
		this.delegate = config;
	}

	@Override
	public String getIndexTypeID() throws GeoIndexLookupException {
		Call<GeoIndexLookupStub, String> call = new Call<GeoIndexLookupStub, String>() {
			@Override
			public String call(GeoIndexLookupStub endpoint) throws Exception {
				return endpoint.getIndexTypeID(new Empty());
			}
		};
		try {
			String response = delegate.make(call);

			return response;
		} catch (Exception e) {
			throw new GeoIndexLookupException(e);
		}
	}

	@Override
	public void setIndexTypeID(final String indexTypeName) throws GeoIndexLookupException {
		Call<GeoIndexLookupStub, Empty> call = new Call<GeoIndexLookupStub, Empty>() {
			@Override
			public Empty call(GeoIndexLookupStub endpoint) throws Exception {
				return endpoint.setIndexTypeID(indexTypeName);
			}
		};
		try {
			delegate.make(call);
		} catch (Exception e) {
			throw new GeoIndexLookupException(e);
		}
	}

	@Override
	public String search(final SearchPolygon searchPolygon) throws GeoIndexLookupException {
		Call<GeoIndexLookupStub, String> call = new Call<GeoIndexLookupStub, String>() {
			@Override
			public String call(GeoIndexLookupStub endpoint) throws Exception {
				return endpoint.search(searchPolygon);
			}
		};
		try {
			String response = delegate.make(call);

			return response;
		} catch (Exception e) {
			throw new GeoIndexLookupException(e);
		}
	}

	@Override
	public void loadPlugins() throws GeoIndexLookupException {
		Call<GeoIndexLookupStub, Empty> call = new Call<GeoIndexLookupStub, Empty>() {
			@Override
			public Empty call(GeoIndexLookupStub endpoint) throws Exception {
				return endpoint.loadPlugins(new Empty());
			}
		};
		try {
			delegate.make(call);
		} catch (Exception e) {
			throw new GeoIndexLookupException(e);
		}
	}

	@Override
	public void destroy() throws GeoIndexLookupException {
		Call<GeoIndexLookupStub, Empty> call = new Call<GeoIndexLookupStub, Empty>() {
			@Override
			public Empty call(GeoIndexLookupStub endpoint) throws Exception {
				endpoint.destroy(new Destroy());
				return null;
			}
		};
		try {
			delegate.make(call);
		} catch (Exception e) {
			throw new GeoIndexLookupException(e);
		}
	}
	
}
