/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.index.fulltextindexnode;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import org.apache.axis.components.uuid.UUIDGen;
import org.apache.axis.components.uuid.UUIDGenFactory;
import org.gcube.common.core.contexts.GCUBEStatefulPortTypeContext;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.faults.GCUBEUnrecoverableException;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.state.GCUBEWSHome;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.common.core.state.GCUBEWSResourceKey;
import org.gcube.index.fulltextindexnode.FullTextIndexNode;
import org.gcube.index.fulltextindexnode.Resource;
import org.gcube.index.fulltextindexnode.ServiceContext;
import org.gcube.index.fulltextindexnode.StatefulContext;
import org.gcube.index.fulltextindexnode.stubs.CreateResource;
import org.gcube.index.fulltextindexnode.stubs.CreateResourceResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullTextIndexNodeFactory
extends GCUBEPortType {
    private static final Logger logger = LoggerFactory.getLogger(FullTextIndexNodeFactory.class);
    private static final UUIDGen uuidGen = UUIDGenFactory.getUUIDGen();
    private static final int PERIOD = 2000;

    protected ServiceContext getServiceContext() {
        return ServiceContext.getContext();
    }

    public CreateResourceResponse createResource(CreateResource request) throws GCUBEFault {
        String indexID = request.getIndexID();
        String[] collectionIDs = request.getCollectionID();
        String indexType = request.getIndexTypeID();
        String contentType = "" + request.getContentType();
        String indexFormat = "lucene";
        String clusterID = request.getClusterID();
        CreateResourceResponse response = new CreateResourceResponse();
        try {
            GCUBEStatefulPortTypeContext ptcxt = StatefulContext.getContext();
            GCUBEWSHome home = ptcxt.getWSHome();
            GCUBEWSResourceKey key = ptcxt.makeKey(indexID == null ? uuidGen.nextUUID() : indexID);
            logger.info("Created key:" + key.getValue().toString() + " " + indexID);
            GCUBEWSResource resource = home.create(key, new Object[]{key, indexID, collectionIDs, indexType, indexFormat, contentType, clusterID});
            response.setEndpointReference(resource.getEPR());
            response.setIndexID(((Resource)resource).getIndexID());
            resource.store();
            StatefulContext pctx = (StatefulContext)StatefulContext.getContext();
            String epr = resource.getEPR().getAddress().toString();
            HashMap<String, Set<String>> endpoints = null;
            boolean check = false;
            block2: while (endpoints == null || !check) {
                endpoints = FullTextIndexNode.discoverByIndexID("FullTextIndexNode", "Index", Arrays.asList(pctx.getServiceContext().getScope().toString()), key.getValue().toString());
                logger.info("Endpoints size: " + endpoints.size() + " " + endpoints);
                if (endpoints.size() < 1) {
                    Thread.sleep(2000L);
                    continue;
                }
                for (String endpoint : endpoints.keySet()) {
                    if (!endpoint.equalsIgnoreCase(epr)) continue;
                    check = true;
                    continue block2;
                }
            }
            return response;
        }
        catch (Exception e) {
            logger.error("unable to create resource", (Throwable)e);
            throw new GCUBEUnrecoverableException((Throwable)e).toFault(new String[0]);
        }
    }
}

