package org.gcube.index.fulltextindexnode;

import org.apache.axis.components.uuid.UUIDGen;
import org.apache.axis.components.uuid.UUIDGenFactory;
import org.gcube.common.core.contexts.GCUBEStatefulPortTypeContext;
import org.gcube.common.core.faults.GCUBEFault;
import org.gcube.common.core.faults.GCUBEUnrecoverableException;
import org.gcube.common.core.porttypes.GCUBEPortType;
import org.gcube.common.core.state.GCUBEWSHome;
import org.gcube.common.core.state.GCUBEWSResource;
import org.gcube.common.core.state.GCUBEWSResourceKey;
import org.gcube.index.fulltextindexnode.stubs.CreateResource;
import org.gcube.index.fulltextindexnode.stubs.CreateResourceResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullTextIndexNodeFactory extends GCUBEPortType {    

	private static final Logger logger = LoggerFactory.getLogger(FullTextIndexNodeFactory.class);
	
	private static final UUIDGen uuidGen = UUIDGenFactory.getUUIDGen();
	
	/** {@inheritDoc} */
	protected ServiceContext getServiceContext() {return ServiceContext.getContext();}

    
        public CreateResourceResponse createResource(CreateResource request) throws GCUBEFault {		
	
    		String indexID = request.getIndexID();
    		String[] collectionIDs = request.getCollectionID();
    		String indexType = request.getIndexTypeID();
    		String contentType = "" + request.getContentType();
    		String indexFormat = "lucene";
    		String clusterID = request.getClusterID();
        	
    		CreateResourceResponse response = new CreateResourceResponse();
    		
           try {
                GCUBEStatefulPortTypeContext ptcxt = StatefulContext.getContext();
                GCUBEWSHome home = ptcxt.getWSHome();
                // if indexID is given return specific resource, else create new key
                GCUBEWSResourceKey key = ptcxt.makeKey(indexID == null ? uuidGen.nextUUID() : indexID);
                logger.info("Created key:" + key.getValue().toString()+" "+indexID);
                GCUBEWSResource resource = home.create(key, key, indexID, collectionIDs, indexType, indexFormat, contentType, clusterID);
                response.setEndpointReference(resource.getEPR());
                response.setIndexID(((Resource)resource).getIndexID());
                
                resource.store();
                
    			return response;
           } catch (Exception e) {
                logger.error("unable to create resource", e);
                throw new GCUBEUnrecoverableException(e).toFault();
           } 
        }
}