package org.gcube.fulltextindexnode.client.library.plugins;

import static org.gcube.common.clients.stubs.jaxws.StubFactory.stubFor;

import javax.xml.ws.EndpointReference;

import org.gcube.common.clients.config.ProxyConfig;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.fw.plugin.Plugin;
import org.gcube.fulltextindexnode.client.library.proxies.FullTextIndexNodeCLDefaultProxy;
import org.gcube.fulltextindexnode.client.library.proxies.FullTextIndexNodeCLProxyI;
import org.gcube.fulltextindexnode.client.library.stubs.FullTextIndexNodeStub;
import org.gcube.fulltextindexnode.client.library.utils.FullTextIndexNodeCLConstants;

/**
 * FullTextIndexNode Client Library plugin exposes information that allows CL Framework
 * components to act on behalf of FullTextIndexNode CL. 
 * 
 * @author p.liakos - DI NKUA
 * 
 */
public class FullTextIndexNodeCLPlugin implements Plugin<FullTextIndexNodeStub, FullTextIndexNodeCLProxyI> {

	
	public String name() {
		return FullTextIndexNodeCLConstants.NAME;
	}

	
	public String namespace() {
		return FullTextIndexNodeCLConstants.NAMESPACE;
	}

	
	public String serviceClass() {
		return FullTextIndexNodeCLConstants.gcubeClass;
	}

	
	public String serviceName() {
		return FullTextIndexNodeCLConstants.gcubeName;
	}
	
	
	public Exception convert(Exception fault, ProxyConfig<?, ?> config) {
		return fault;
	}

	
	public FullTextIndexNodeStub resolve(EndpointReference reference,ProxyConfig<?, ?> proxyConfig) throws Exception {
		return stubFor(FullTextIndexNodeCLConstants.ftin).at(reference);
		
	}
	
	
	public FullTextIndexNodeCLProxyI newProxy(ProxyDelegate<FullTextIndexNodeStub> delegate) {
		return new FullTextIndexNodeCLDefaultProxy(delegate);
	}

}
