/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.fulltextindexnode.client.library.proxies;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.stubs.jaxws.JAXWSUtils;
import org.gcube.fulltextindexnode.client.library.beans.Types;
import org.gcube.fulltextindexnode.client.library.exceptions.FullTextIndexNodeException;
import org.gcube.fulltextindexnode.client.library.proxies.FullTextIndexNodeCLProxyI;
import org.gcube.fulltextindexnode.client.library.stubs.FullTextIndexNodeStub;

public class FullTextIndexNodeCLDefaultProxy
implements FullTextIndexNodeCLProxyI {
    private final ProxyDelegate<FullTextIndexNodeStub> delegate;

    public FullTextIndexNodeCLDefaultProxy(ProxyDelegate<FullTextIndexNodeStub> config) {
        this.delegate = config;
    }

    @Override
    public Boolean feedLocator(String feedLocator, String indexName, Set<String> sids, Boolean activate) throws FullTextIndexNodeException {
        final Types.FeedLocator feedLocatorRequest = new Types.FeedLocator();
        feedLocatorRequest.resultSetLocation = feedLocator;
        feedLocatorRequest.indexName = indexName;
        feedLocatorRequest.activate = activate;
        feedLocatorRequest.sids = new Types.StringArray();
        if (sids != null) {
            feedLocatorRequest.sids.array = new ArrayList<String>(sids);
        }
        Call<FullTextIndexNodeStub, Boolean> call = new Call<FullTextIndexNodeStub, Boolean>(){

            public Boolean call(FullTextIndexNodeStub endpoint) throws Exception {
                return endpoint.feedLocator(feedLocatorRequest);
            }
        };
        try {
            Boolean response = (Boolean)this.delegate.make((Call)call);
            return response;
        }
        catch (Exception e) {
            throw new FullTextIndexNodeException(e);
        }
    }

    @Override
    public Long collectionCount(final String collectionID) throws FullTextIndexNodeException {
        Call<FullTextIndexNodeStub, Long> call = new Call<FullTextIndexNodeStub, Long>(){

            public Long call(FullTextIndexNodeStub endpoint) throws Exception {
                return endpoint.collectionCount(collectionID);
            }
        };
        try {
            Long response = (Long)this.delegate.make((Call)call);
            return response;
        }
        catch (Exception e) {
            throw new FullTextIndexNodeException(e);
        }
    }

    @Override
    public Boolean activateIndex(final String indexName) throws FullTextIndexNodeException {
        Call<FullTextIndexNodeStub, Boolean> call = new Call<FullTextIndexNodeStub, Boolean>(){

            public Boolean call(FullTextIndexNodeStub endpoint) throws Exception {
                return endpoint.activateIndex(indexName);
            }
        };
        try {
            Boolean response = (Boolean)this.delegate.make((Call)call);
            return response;
        }
        catch (Exception e) {
            throw new FullTextIndexNodeException(e);
        }
    }

    @Override
    public Boolean deleteIndex(final String indexName) throws FullTextIndexNodeException {
        Call<FullTextIndexNodeStub, Boolean> call = new Call<FullTextIndexNodeStub, Boolean>(){

            public Boolean call(FullTextIndexNodeStub endpoint) throws Exception {
                return endpoint.deleteIndex(indexName);
            }
        };
        try {
            Boolean response = (Boolean)this.delegate.make((Call)call);
            return response;
        }
        catch (Exception e) {
            throw new FullTextIndexNodeException(e);
        }
    }

    @Override
    public Boolean feedLocatorUnit(final String feedLocator) throws FullTextIndexNodeException {
        Call<FullTextIndexNodeStub, Boolean> call = new Call<FullTextIndexNodeStub, Boolean>(){

            public Boolean call(FullTextIndexNodeStub endpoint) throws Exception {
                return endpoint.feedLocatorUnit(feedLocator);
            }
        };
        try {
            Boolean response = (Boolean)this.delegate.make((Call)call);
            return response;
        }
        catch (Exception e) {
            throw new FullTextIndexNodeException(e);
        }
    }

    @Override
    public Boolean flush() throws FullTextIndexNodeException {
        Call<FullTextIndexNodeStub, Boolean> call = new Call<FullTextIndexNodeStub, Boolean>(){

            public Boolean call(FullTextIndexNodeStub endpoint) throws Exception {
                return endpoint.flush(new JAXWSUtils.Empty());
            }
        };
        try {
            Boolean response = (Boolean)this.delegate.make((Call)call);
            return response;
        }
        catch (Exception e) {
            throw new FullTextIndexNodeException(e);
        }
    }

    @Override
    public List<String> getCollectionsOfIndex(final String indexName) throws FullTextIndexNodeException {
        Call<FullTextIndexNodeStub, Types.StringArray> call = new Call<FullTextIndexNodeStub, Types.StringArray>(){

            public Types.StringArray call(FullTextIndexNodeStub endpoint) throws Exception {
                return endpoint.getCollectionsOfIndex(indexName);
            }
        };
        try {
            Types.StringArray response = (Types.StringArray)this.delegate.make((Call)call);
            return response.array;
        }
        catch (Exception e) {
            throw new FullTextIndexNodeException(e);
        }
    }

    @Override
    public List<String> getIndicesOfCollection(final String collectionID) throws FullTextIndexNodeException {
        Call<FullTextIndexNodeStub, Types.StringArray> call = new Call<FullTextIndexNodeStub, Types.StringArray>(){

            public Types.StringArray call(FullTextIndexNodeStub endpoint) throws Exception {
                return endpoint.getIndicesOfCollection(collectionID);
            }
        };
        try {
            Types.StringArray response = (Types.StringArray)this.delegate.make((Call)call);
            return response.array;
        }
        catch (Exception e) {
            throw new FullTextIndexNodeException(e);
        }
    }

    public String query(final String queryString, final Set<String> sids) throws FullTextIndexNodeException {
        Call<FullTextIndexNodeStub, String> call = new Call<FullTextIndexNodeStub, String>(){

            public String call(FullTextIndexNodeStub endpoint) throws Exception {
                Types.Query query = new Types.Query();
                query.query = queryString;
                query.sids = new Types.StringArray();
                if (sids != null) {
                    query.sids.array = new ArrayList<String>(sids);
                }
                return endpoint.query(query);
            }
        };
        try {
            String response = (String)this.delegate.make((Call)call);
            return response;
        }
        catch (Exception e) {
            throw new FullTextIndexNodeException(e);
        }
    }

    @Override
    public String query(final String queryString) throws FullTextIndexNodeException {
        Call<FullTextIndexNodeStub, String> call = new Call<FullTextIndexNodeStub, String>(){

            public String call(FullTextIndexNodeStub endpoint) throws Exception {
                Types.Query query = new Types.Query();
                query.query = queryString;
                query.sids = new Types.StringArray();
                return endpoint.query(query);
            }
        };
        try {
            String response = (String)this.delegate.make((Call)call);
            return response;
        }
        catch (Exception e) {
            throw new FullTextIndexNodeException(e);
        }
    }

    public String queryLimited(final String query, final Integer count, final Integer from, final Set<String> sids) throws FullTextIndexNodeException {
        Call<FullTextIndexNodeStub, String> call = new Call<FullTextIndexNodeStub, String>(){

            public String call(FullTextIndexNodeStub endpoint) throws Exception {
                Types.QueryLimited queryLimited = new Types.QueryLimited();
                queryLimited.query = query;
                queryLimited.count = count;
                queryLimited.from = from;
                queryLimited.sids = new Types.StringArray();
                if (sids != null) {
                    queryLimited.sids.array = new ArrayList<String>(sids);
                }
                return endpoint.queryLimited(queryLimited);
            }
        };
        try {
            String response = (String)this.delegate.make((Call)call);
            return response;
        }
        catch (Exception e) {
            throw new FullTextIndexNodeException(e);
        }
    }

    @Override
    public String queryLimited(final String query, final Integer count, final Integer from) throws FullTextIndexNodeException {
        Call<FullTextIndexNodeStub, String> call = new Call<FullTextIndexNodeStub, String>(){

            public String call(FullTextIndexNodeStub endpoint) throws Exception {
                Types.QueryLimited queryLimited = new Types.QueryLimited();
                queryLimited.query = query;
                queryLimited.count = count;
                queryLimited.from = from;
                queryLimited.sids = new Types.StringArray();
                return endpoint.queryLimited(queryLimited);
            }
        };
        try {
            String response = (String)this.delegate.make((Call)call);
            return response;
        }
        catch (Exception e) {
            throw new FullTextIndexNodeException(e);
        }
    }

    @Override
    public boolean shutdown(final String shutdown) throws FullTextIndexNodeException {
        Call<FullTextIndexNodeStub, Boolean> call = new Call<FullTextIndexNodeStub, Boolean>(){

            public Boolean call(FullTextIndexNodeStub endpoint) throws Exception {
                return endpoint.shutdown(shutdown);
            }
        };
        try {
            Boolean response = (Boolean)this.delegate.make((Call)call);
            return response;
        }
        catch (Exception e) {
            throw new FullTextIndexNodeException(e);
        }
    }

    @Override
    public boolean deleteCollection(final String collectionID) throws FullTextIndexNodeException {
        Call<FullTextIndexNodeStub, Boolean> call = new Call<FullTextIndexNodeStub, Boolean>(){

            public Boolean call(FullTextIndexNodeStub endpoint) throws Exception {
                return endpoint.deleteCollection(collectionID);
            }
        };
        try {
            Boolean response = (Boolean)this.delegate.make((Call)call);
            return response;
        }
        catch (Exception e) {
            throw new FullTextIndexNodeException(e);
        }
    }

    @Override
    public boolean destroyNode() throws FullTextIndexNodeException {
        Call<FullTextIndexNodeStub, Boolean> call = new Call<FullTextIndexNodeStub, Boolean>(){

            public Boolean call(FullTextIndexNodeStub endpoint) throws Exception {
                return endpoint.destroyNode(new JAXWSUtils.Empty());
            }
        };
        try {
            Boolean response = (Boolean)this.delegate.make((Call)call);
            return response;
        }
        catch (Exception e) {
            throw new FullTextIndexNodeException(e);
        }
    }

    @Override
    public boolean refresh() throws FullTextIndexNodeException {
        Call<FullTextIndexNodeStub, Boolean> call = new Call<FullTextIndexNodeStub, Boolean>(){

            public Boolean call(FullTextIndexNodeStub endpoint) throws Exception {
                return endpoint.refresh(new JAXWSUtils.Empty());
            }
        };
        try {
            Boolean response = (Boolean)this.delegate.make((Call)call);
            return response;
        }
        catch (Exception e) {
            throw new FullTextIndexNodeException(e);
        }
    }

    @Override
    public boolean rebuildMetaIndex() throws FullTextIndexNodeException {
        Call<FullTextIndexNodeStub, Boolean> call = new Call<FullTextIndexNodeStub, Boolean>(){

            public Boolean call(FullTextIndexNodeStub endpoint) throws Exception {
                return endpoint.rebuildMetaIndex(new JAXWSUtils.Empty());
            }
        };
        try {
            Boolean response = (Boolean)this.delegate.make((Call)call);
            return response;
        }
        catch (Exception e) {
            throw new FullTextIndexNodeException(e);
        }
    }

    @Override
    public Types.GetIndexInformationResponse getIndexInformation() throws FullTextIndexNodeException {
        Call<FullTextIndexNodeStub, Types.GetIndexInformationResponse> call = new Call<FullTextIndexNodeStub, Types.GetIndexInformationResponse>(){

            public Types.GetIndexInformationResponse call(FullTextIndexNodeStub endpoint) throws Exception {
                return endpoint.getIndexInformation(new JAXWSUtils.Empty());
            }
        };
        try {
            Types.GetIndexInformationResponse response = (Types.GetIndexInformationResponse)this.delegate.make((Call)call);
            return response;
        }
        catch (Exception e) {
            throw new FullTextIndexNodeException(e);
        }
    }

    @Override
    public boolean setCollections(final String[] collections) throws FullTextIndexNodeException {
        Call<FullTextIndexNodeStub, Boolean> call = new Call<FullTextIndexNodeStub, Boolean>(){

            public Boolean call(FullTextIndexNodeStub endpoint) throws Exception {
                Types.StringArray request = new Types.StringArray();
                request.array = Arrays.asList(collections);
                return endpoint.setCollections(request);
            }
        };
        try {
            Boolean response = (Boolean)this.delegate.make((Call)call);
            return response;
        }
        catch (Exception e) {
            throw new FullTextIndexNodeException(e);
        }
    }

    @Override
    public boolean setFields(final String[] fields) throws FullTextIndexNodeException {
        Call<FullTextIndexNodeStub, Boolean> call = new Call<FullTextIndexNodeStub, Boolean>(){

            public Boolean call(FullTextIndexNodeStub endpoint) throws Exception {
                Types.StringArray request = new Types.StringArray();
                request.array = Arrays.asList(fields);
                return endpoint.setFields(request);
            }
        };
        try {
            Boolean response = (Boolean)this.delegate.make((Call)call);
            return response;
        }
        catch (Exception e) {
            throw new FullTextIndexNodeException(e);
        }
    }

    @Override
    public void destroy() throws FullTextIndexNodeException {
        Call<FullTextIndexNodeStub, JAXWSUtils.Empty> call = new Call<FullTextIndexNodeStub, JAXWSUtils.Empty>(){

            public JAXWSUtils.Empty call(FullTextIndexNodeStub endpoint) throws Exception {
                endpoint.destroy(new Types.Destroy());
                return null;
            }
        };
        try {
            this.delegate.make((Call)call);
        }
        catch (Exception e) {
            throw new FullTextIndexNodeException(e);
        }
    }
}

