package org.gcube.fulltextindexnode.client.library.proxies;

import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.fulltextindexnode.client.library.beans.Types.CreateResource;
import org.gcube.fulltextindexnode.client.library.beans.Types.CreateResourceResponse;
import org.gcube.fulltextindexnode.client.library.exceptions.FullTextIndexNodeException;
import org.gcube.fulltextindexnode.client.library.stubs.FullTextIndexNodeFactoryStub;

public class FullTextIndexNodeFactoryCLDefaultProxy implements FullTextIndexNodeFactoryCLProxyI {

	private final ProxyDelegate<FullTextIndexNodeFactoryStub> delegate;

	public FullTextIndexNodeFactoryCLDefaultProxy(ProxyDelegate<FullTextIndexNodeFactoryStub> config) {
		this.delegate = config;
	}

	public CreateResourceResponse createResource(final CreateResource createResource) throws FullTextIndexNodeException {
		Call<FullTextIndexNodeFactoryStub, CreateResourceResponse> call = new Call<FullTextIndexNodeFactoryStub, CreateResourceResponse>() {
			public CreateResourceResponse call(FullTextIndexNodeFactoryStub endpoint) throws Exception {
				return endpoint.createResource(createResource);
			}
		};
		try {
			CreateResourceResponse response = delegate.make(call);

			return response;
		} catch (Exception e) {
			throw new FullTextIndexNodeException(e);
		}
	}
}
