package org.gcube.fulltextindexnode.client.library.proxies;

import org.gcube.fulltextindexnode.client.library.beans.Types.GetIndexInformationResponse;
import org.gcube.fulltextindexnode.client.library.beans.Types.QueryLimited;
import org.gcube.fulltextindexnode.client.library.exceptions.FullTextIndexNodeException;

public interface FullTextIndexNodeCLProxyI {
	
	public Boolean feedLocator(final String feedLocator) throws FullTextIndexNodeException;
	
	public String query(final String query) throws FullTextIndexNodeException;
	
	public String queryLimited(final String query, final Integer count, final Integer from) throws FullTextIndexNodeException;
	
	public boolean shutdown(final String shutdown) throws FullTextIndexNodeException;
	
	public boolean deleteCollection(final String collectionID) throws FullTextIndexNodeException;

	public boolean destroyNode() throws FullTextIndexNodeException;

	public boolean refresh() throws FullTextIndexNodeException;
	
	public boolean rebuildMetaIndex() throws FullTextIndexNodeException;
	
	public GetIndexInformationResponse getIndexInformation() throws FullTextIndexNodeException;
	
	public boolean setCollections(final String[] collections) throws FullTextIndexNodeException;
	
	public boolean setFields(final String[] fields) throws FullTextIndexNodeException;
	
	public void destroy() throws FullTextIndexNodeException;
	
}
