package org.gcube.fulltextindexnode.client.library.proxies;

import java.net.URI;

import org.gcube.common.clients.fw.queries.StatefulQuery;
import org.gcube.fulltextindexnode.client.library.utils.FullTextIndexNodeCLConstants;

public class SourceQueryBuilder {

	private final StatefulQuery query;
	
	private String indexID;
	
	public SourceQueryBuilder(StatefulQuery query) {
		query.addNamespace("ns1",URI.create(FullTextIndexNodeCLConstants.NAMESPACE));
		this.query=query;
	}

	public SourceQueryBuilder withIndexID(String indexID) {
		this.indexID = indexID;
		return this;
	}

	/**
	 * Returns the query.
	 * @return the query.
	 */
	public StatefulQuery build() {
	
		if (indexID!=null)
			query.addCondition("$resource/Data/ns1:IndexID/text() eq '" + indexID + "'");
		
		return query;
		
		
	}

}
