/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.index.forwardindexnode;

import gr.uoa.di.madgik.rr.ResourceRegistryException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.couchbase.CouchBaseNode;
import org.gcube.index.forwardindexnode.ForwardIndexNode;
import org.gcube.index.forwardindexnode.ServiceContext;
import org.gcube.index.forwardindexnode.StatefulContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForwardNodeClient {
    private static final String NO_REPLICAS = "noReplicas";
    private static final String RAMQUOTA = "ramQuota";
    private static final String USE_CLUSTER_ID = "useClusterId";
    private static final String COUCHBASE_SERVER_IP = "couchbaseIP";
    private static final String COUCHBASE_SERVER_PORT = "couchbasePort";
    private static final String COUCHBASE_USERNAME = "couchbaseUsername";
    private static final String COUCHBASE_PASSWORD = "couchbasePassword";
    private static final Integer DEFAULT_PORT = 8091;
    private CouchBaseNode ftn;
    private static final Logger logger = LoggerFactory.getLogger(ForwardNodeClient.class);

    public ForwardNodeClient(String clusterID, boolean isNew) throws ResourceRegistryException, InterruptedException {
        try {
            StatefulContext pctx = (StatefulContext)StatefulContext.getContext();
            Integer noReplicas = (Integer)pctx.getProperty(NO_REPLICAS, new boolean[0]);
            Integer ramQuota = (Integer)pctx.getProperty(RAMQUOTA, new boolean[0]);
            boolean useClusterID = (Boolean)pctx.getProperty(USE_CLUSTER_ID, new boolean[0]);
            String couchbaseServerIP = (String)pctx.getProperty(COUCHBASE_SERVER_IP, new boolean[0]);
            String couchbaseServerPort = (String)pctx.getProperty(COUCHBASE_SERVER_PORT, new boolean[0]);
            String couchbaseUsername = (String)pctx.getProperty(COUCHBASE_USERNAME, new boolean[0]);
            String couchbasePassword = (String)pctx.getProperty(COUCHBASE_PASSWORD, new boolean[0]);
            logger.info("Data read from jndi");
            logger.info("noReplicas          : " + noReplicas);
            logger.info("ramQuota            : " + ramQuota);
            logger.info("useClusterID        : " + useClusterID);
            logger.info("couchbaseServerIP   : " + couchbaseServerIP);
            logger.info("couchbaseServerPort : " + couchbaseServerPort);
            logger.info("couchbaseUsername   : " + couchbaseUsername);
            logger.info("couchbasePassword   : " + couchbasePassword);
            String scope = ServiceContext.getContext().getScope().toString();
            logger.info("Setting index scope to " + scope);
            String clusterName = "couchbase-cluster-service-";
            if (!useClusterID) {
                clusterID = scope;
            }
            clusterName = clusterName + clusterID;
            clusterName = clusterName.replace("/", "_");
            String hostname = GHNContext.getContext().getHostname();
            logger.info("hostname :  " + hostname);
            this.ftn = new CouchBaseNode(hostname, couchbaseServerIP, couchbaseServerPort, couchbaseUsername, couchbasePassword, clusterName, noReplicas, ramQuota, scope);
            HashMap<String, Set<String>> endpoints = ForwardIndexNode.discover("ForwardIndexNode", "Index", Arrays.asList(scope), clusterID);
            logger.info("endpoints discovers : " + endpoints);
            HashMap<String, String> knownNodes = new HashMap<String, String>();
            for (String key : endpoints.keySet()) {
                knownNodes.put(ForwardNodeClient.getIPAddress(ForwardNodeClient.extractDomain(key)), String.valueOf(DEFAULT_PORT));
            }
            logger.info("knownNodes discovers : " + knownNodes);
            if (knownNodes.size() > 0) {
                this.ftn.joinCluster(knownNodes);
            } else {
                this.ftn.createCluster(isNew);
            }
        }
        catch (ResourceRegistryException e) {
            logger.error("Caught Exception", (Throwable)e);
            throw e;
        }
        catch (InterruptedException e) {
            logger.error("Caught Exception", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error("Caught Exception", (Throwable)e);
        }
    }

    public CouchBaseNode getForwardNode() {
        return this.ftn;
    }

    public String getScope() {
        return this.ftn.getScope();
    }

    public String getClusterName() {
        return this.ftn.getBucketName();
    }

    private static String extractDomain(String endpoint) {
        endpoint = endpoint.substring(endpoint.indexOf("://") + 3);
        endpoint = endpoint.substring(0, endpoint.indexOf(":"));
        return endpoint;
    }

    private static String getIPAddress(String hostname) throws UnknownHostException {
        String address = null;
        try {
            address = InetAddress.getByName(hostname).getHostAddress();
        }
        catch (Exception e) {
            address = hostname;
        }
        return address;
    }
}

