package org.gcube.index.forwardindexnode;

import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GCUBEStatefulPortTypeContext;

public class StatefulContext extends GCUBEStatefulPortTypeContext {

    /** Singleton instance. */
    private static GCUBEStatefulPortTypeContext cache = new StatefulContext();

    /**Creates an instance, privately. */
    private StatefulContext(){}

    /** Returns the singleton context.
    /* @return the context.*/
    public static GCUBEStatefulPortTypeContext getContext() {return cache;}

    /** {@inheritDoc} */
    public String getJNDIName() {return "gcube/index/ForwardIndexNode";}

    /** {@inheritDoc} */
    public String getNamespace() {return "http://gcube-system.org/namespaces/index/ForwardIndexNode/service";}
    
    /** {@inheritDoc} */
    public GCUBEServiceContext getServiceContext() {return ServiceContext.getContext();}

}