package org.gcube.forwardindexnode.client.library.plugins;

import static org.gcube.common.clients.stubs.jaxws.StubFactory.stubFor;

import javax.xml.ws.EndpointReference;

import org.gcube.common.clients.config.ProxyConfig;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.fw.plugin.Plugin;
import org.gcube.forwardindexnode.client.library.proxies.ForwardIndexNodeCLDefaultProxy;
import org.gcube.forwardindexnode.client.library.proxies.ForwardIndexNodeCLProxyI;
import org.gcube.forwardindexnode.client.library.stubs.ForwardIndexNodeStub;
import org.gcube.forwardindexnode.client.library.utils.ForwardIndexNodeCLConstants;

/**
 * FullTextIndexNode Client Library plugin exposes information that allows CL Framework
 * components to act on behalf of FullTextIndexNode CL. 
 * 
 * @author p.liakos - DI NKUA
 * 
 */
public class ForwardIndexNodeCLPlugin implements Plugin<ForwardIndexNodeStub, ForwardIndexNodeCLProxyI> {

	@Override
	public String name() {
		return ForwardIndexNodeCLConstants.NAME;
	}

	@Override
	public String namespace() {
		return ForwardIndexNodeCLConstants.NAMESPACE;
	}

	@Override
	public String serviceClass() {
		return ForwardIndexNodeCLConstants.gcubeClass;
	}

	@Override
	public String serviceName() {
		return ForwardIndexNodeCLConstants.gcubeName;
	}
	
	@Override
	public Exception convert(Exception fault, ProxyConfig<?, ?> config) {
		return fault;
	}

	@Override
	public ForwardIndexNodeStub resolve(EndpointReference reference,ProxyConfig<?, ?> proxyConfig) throws Exception {
		return stubFor(ForwardIndexNodeCLConstants.ftin).at(reference);
		
	}
	
	@Override
	public ForwardIndexNodeCLProxyI newProxy(ProxyDelegate<ForwardIndexNodeStub> delegate) {
		return new ForwardIndexNodeCLDefaultProxy(delegate);
	}

}
