package org.gcube.forwardindexnode.client.library.plugins;

import javax.xml.ws.EndpointReference;

import org.gcube.common.clients.config.ProxyConfig;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.fw.plugin.Plugin;
import org.gcube.common.clients.stubs.jaxws.StubFactory;
import org.gcube.forwardindexnode.client.library.proxies.ForwardIndexNodeFactoryCLDefaultProxy;
import org.gcube.forwardindexnode.client.library.proxies.ForwardIndexNodeFactoryCLProxyI;
import org.gcube.forwardindexnode.client.library.stubs.ForwardIndexNodeFactoryStub;
import org.gcube.forwardindexnode.client.library.utils.ForwardIndexNodeCLConstants;

/**
 * DTS Client Library plugin exposes information that allows CL Framework
 * components to act on behalf of DTS CL. 
 * 
 * @author john.gerbesiotis - DI NKUA
 * 
 */
public class ForwardIndexNodeFactoryCLPlugin implements Plugin<ForwardIndexNodeFactoryStub, ForwardIndexNodeFactoryCLProxyI> {

	@Override
	public String name() {
		return ForwardIndexNodeCLConstants.FACTORYNAME;
	}

	@Override
	public String namespace() {
		return ForwardIndexNodeCLConstants.NAMESPACE;
	}

	@Override
	public String serviceClass() {
		return ForwardIndexNodeCLConstants.gcubeClass;
	}

	@Override
	public String serviceName() {
		return ForwardIndexNodeCLConstants.gcubeName;
	}
	
	@Override
	public Exception convert(Exception fault, ProxyConfig<?, ?> config) {
		return fault;
	}

	@Override
	public ForwardIndexNodeFactoryStub resolve(EndpointReference reference, ProxyConfig<?, ?> proxyConfig) throws Exception {
		return StubFactory.stubFor(ForwardIndexNodeCLConstants.ftinf).at(reference);
	}

	@Override
	public ForwardIndexNodeFactoryCLProxyI newProxy(ProxyDelegate<ForwardIndexNodeFactoryStub> delegate) {
		return new ForwardIndexNodeFactoryCLDefaultProxy(delegate);
	}

}
