package IndexManagement;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import org.apache.axis.message.addressing.Address;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.RPDocument;
import org.gcube.common.core.informationsystem.client.queries.WSResourceQuery;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.security.GCUBESecurityManagerImpl;
import org.gcube.indexmanagement.forwardindexlookup.stubs.ForwardIndexLookupFactoryPortType;
import org.gcube.indexmanagement.forwardindexlookup.stubs.ForwardIndexLookupPortType;
import org.gcube.indexmanagement.forwardindexlookup.stubs.GetAll;
import org.gcube.indexmanagement.forwardindexlookup.stubs.GetEQ;
import org.gcube.indexmanagement.forwardindexlookup.stubs.GetGE;
import org.gcube.indexmanagement.forwardindexlookup.stubs.GetGEandLE;
import org.gcube.indexmanagement.forwardindexlookup.stubs.GetGEandLT;
import org.gcube.indexmanagement.forwardindexlookup.stubs.GetGT;
import org.gcube.indexmanagement.forwardindexlookup.stubs.GetGTandLE;
import org.gcube.indexmanagement.forwardindexlookup.stubs.GetGTandLT;
import org.gcube.indexmanagement.forwardindexlookup.stubs.GetLE;
import org.gcube.indexmanagement.forwardindexlookup.stubs.GetLT;
import org.gcube.indexmanagement.forwardindexlookup.stubs.ResultType;
import org.gcube.indexmanagement.forwardindexlookup.stubs.service.ForwardIndexLookupFactoryServiceAddressingLocator;
import org.gcube.indexmanagement.forwardindexlookup.stubs.service.ForwardIndexLookupServiceAddressingLocator;
import org.gcube.indexmanagement.forwardindexmanagement.stubs.ForwardIndexManagementFactoryPortType;
import org.gcube.indexmanagement.forwardindexmanagement.stubs.ForwardIndexManagementPortType;
import org.gcube.indexmanagement.forwardindexmanagement.stubs.KeyDescriptionArray;
import org.gcube.indexmanagement.forwardindexmanagement.stubs.service.ForwardIndexManagementFactoryServiceAddressingLocator;
import org.gcube.indexmanagement.forwardindexmanagement.stubs.service.ForwardIndexManagementServiceAddressingLocator;
import org.gcube.indexmanagement.forwardindexupdater.stubs.ForwardIndexUpdaterFactoryPortType;
import org.gcube.indexmanagement.forwardindexupdater.stubs.ForwardIndexUpdaterPortType;
import org.gcube.indexmanagement.forwardindexupdater.stubs.service.ForwardIndexUpdaterFactoryServiceAddressingLocator;
import org.gridforum.jgss.ExtendedGSSCredential;
import org.gridforum.jgss.ExtendedGSSManager;
import org.ietf.jgss.GSSCredential;
import org.oasis.wsrf.lifetime.Destroy;

import IndexManagement.VOInfoManager.CollectionInfo;
import IndexManagement.VOInfoManager.MetadataCollectionInfo;


/**
 * Client used to create, feed and look up forward indexes.
 * 
 * Syntax: 
 * 1) ForwardIndexClient [ -cred <credentialFile> ] <scope> -create "manager" | "lookup" | "all" <colName> <colSchema> <colLang> <indexedFieldNumber> (<keyName> <indexTypeID>)^<indexedFieldNumber>  [ indexID ]
 * 2) ForwardIndexClient [ -cred <credentialFile> ] <scope> -destroy "manager" | "lookup" | "all" <colName> <colSchema> <colLang> <indexedFieldNumber> (<keyName>)^<indexedFieldNumber>
 * 3) ForwardIndexClient [ -cred <credentialFile> ] <scope> -destroyIndexID "manager" | "lookup" | "all" <indexID>
 * 4) ForwardIndexClient [ -cred <credentialFile> ] <scope> -remove "manager" | "lookup" | "all" <colName> <colSchema> <colLang> <indexedFieldNumber> (<keyName>)^<indexedFieldNumber>
 * 5) ForwardIndexClient [ -cred <credentialFile> ] <scope> -feed <colName> <colSchema> <colLang> <rowset_RS_EPR_file> <indexedFieldNumber> (<keyName>)^<indexedFieldNumber> 
 * 6) ForwardIndexClient [ -cred <credentialFile> ] <scope> -lookup <colName> <colSchema> <colLang> <indexedFieldNumber> (<keyName>)^<indexedFieldNumber> "0"|"1"|"2"(stand for the resultType: 0~keys+data|1~onlyKeys|2~onlyData) <keyNameForLookup> [ <operator> <value1> [ <value2> ] ]
 * 7) ForwardIndexClient [ -cred <credentialFile> ] <scope> -multi <colName> <colSchema> <colLang> <indexedFieldNumber> (<keyName>)^<indexedFieldNumber> <query>
 * 8) ForwardIndexClient [ -cred <credentialFile> ] <scope> -list <colName> <colSchema> <colLang> <indexedFieldNumber> (<keyName>)^<indexedFieldNumber>
 * 
 * @author Spyros Boutsis, NKUA
 */

public class ForwardIndexClient {
	
	private enum operationMode { CREATE, FEED, LOOKUP, MULTI, DESTROY, DESTROYID, REMOVE, LIST };

	private static final String FWINDEXTYPE_INT = "fwd_int_string";
	private static final String FWINDEXTYPE_FLOAT = "fwd_float_string";
	private static final String FWINDEXTYPE_DATE = "fwd_date_string";
	private static final String FWINDEXTYPE_STRING = "fwd_string_string";
	
	String lookupFactoryURI; 
    String updaterFactoryURI; 
    String managementFactoryURI;
    
    private static final String keyElementName = "KeyDescription";
    
    private List<EndpointReferenceType> getWSResourceEPRsFromPropValues(List<String[]> properties, GCUBEScope scope) throws Exception {
		/*String filter = "$result/child::*[local-name()='"+properties.get(0)[0].trim()+"' and text()='"+properties.get(0)[1].trim()+"']/string() eq '"+properties.get(0)[1].trim()+"'";
		for (int i=1; i<properties.size(); i++)
			filter += " and $result/child::*[local-name()='"+properties.get(i)[0].trim()+"' and text()='"+properties.get(i)[1].trim()+"']/string() eq '"+properties.get(i)[1].trim()+"'";
		*/
    	
    	String filter = "($result//child::*[local-name()='"+properties.get(0)[0].trim()+"']/text() eq '"+properties.get(0)[1].trim()+"')";
		for (int i=1; i<properties.size(); i++)
			filter += " and ($result//child::*[local-name()='"+properties.get(i)[0].trim()+"']/text() eq '"+properties.get(i)[1].trim()+"')";
			
		
		ISClient client = GHNContext.getImplementation(ISClient.class);
		WSResourceQuery gquery = client.getQuery(WSResourceQuery.class);
		gquery.addGenericCondition(filter);

		List<EndpointReferenceType> ret = new LinkedList<EndpointReferenceType>();
		for(RPDocument d : client.execute(gquery, scope)){
			ret.add(d.getEndpoint());
		}
		return ret;
	}
    
    private List<EndpointReferenceType> getWSResourceEPRsFromKeyNames(List<String[]> properties, List<String[]> keyNames, GCUBEScope scope) throws Exception {
		/*String filter = "$result/child::*[local-name()='"+properties.get(0)[0].trim()+"' and text()='"+properties.get(0)[1].trim()+"']/string() eq '"+properties.get(0)[1].trim()+"'";
		for (int i=1; i<properties.size(); i++)
			filter += " and $result/child::*[local-name()='"+properties.get(i)[0].trim()+"' and text()='"+properties.get(i)[1].trim()+"']/string() eq '"+properties.get(i)[1].trim()+"'";
		*/
    	
    	String filter = "($result//child::*[local-name()='"+properties.get(0)[0].trim()+"']/text() eq '"+properties.get(0)[1].trim()+"')";
		for (int i=1; i<properties.size(); i++)
			filter += " and ($result//child::*[local-name()='"+properties.get(i)[0].trim()+"']/text() eq '"+properties.get(i)[1].trim()+"')";
		for (int i=0; i<keyNames.size(); i++)
    		filter += " and ($result/child::*[local-name()='"+ keyElementName +"']/child::*[local-name()='"+keyNames.get(i)[0].trim()+"' and string()='"+keyNames.get(i)[1].trim()+"'])";
		
		ISClient client = GHNContext.getImplementation(ISClient.class);
		WSResourceQuery gquery = client.getQuery(WSResourceQuery.class);
		gquery.addGenericCondition(filter);

		System.out.println(gquery.getExpression());
		
		List<EndpointReferenceType> ret = new LinkedList<EndpointReferenceType>();
		for(RPDocument d : client.execute(gquery, scope)){
			ret.add(d.getEndpoint());
			System.out.println("Found epr: " + d.getEndpoint());
		}
		return ret;
	}
    
    private List<String> getPropertyValueFromWSResourceEPR(EndpointReferenceType epr, String propName, GCUBEScope scope) throws Exception {    	
		ISClient client = GHNContext.getImplementation(ISClient.class);
		WSResourceQuery gquery = client.getQuery(WSResourceQuery.class);
		gquery.addAtomicConditions(
				new AtomicCondition("/../Source", epr.getAddress().toString()),
				new AtomicCondition("/../SourceKey", epr.getProperties().get_any()[0].getValue())
			);		
		for(RPDocument d : client.execute(gquery, scope)){
			return d.evaluate("//" + propName + "/text()");
		}
		return null;
	}
    
	private ForwardIndexManagementFactoryPortType createForwardIndexManagementFactory(GCUBEScope scope, GCUBESecurityManager secManager) {
        try {
            // Get factory portType
        	ForwardIndexManagementFactoryServiceAddressingLocator forwardIndexManagementFactoryLocator = new ForwardIndexManagementFactoryServiceAddressingLocator();
        	EndpointReferenceType forwardIndexManagementFactoryEPR = new EndpointReferenceType();
        	forwardIndexManagementFactoryEPR.setAddress(new Address(managementFactoryURI));
        	ForwardIndexManagementFactoryPortType forwardIndexManagementFactoryPortType = forwardIndexManagementFactoryLocator.getForwardIndexManagementFactoryPortTypePort(forwardIndexManagementFactoryEPR);
        	//ConfigureSecurity.setSecurity(((Stub)forwardIndexManagementFactoryPortType), false, cred, GSIConstants.GSI_MODE_FULL_DELEG);
        	forwardIndexManagementFactoryPortType = GCUBERemotePortTypeContext.getProxy(forwardIndexManagementFactoryPortType, scope, secManager);
            return forwardIndexManagementFactoryPortType;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(0);
        }
        return null;
    }
	
	private String createForwardIndexManagementResource(String collectionID, String[] indexedFields, String[] indexTypeIDs, ForwardIndexManagementFactoryPortType forwardIndexManagementFactoryPortType, String indexID) {
		try {
			// Create forwardIndex resource and get endpoint reference of WS-Resource.
			org.gcube.indexmanagement.forwardindexmanagement.stubs.CreateResource forwardIndexManagementCreateResource = new org.gcube.indexmanagement.forwardindexmanagement.stubs.CreateResource();
			forwardIndexManagementCreateResource.setCollectionID(collectionID);
			org.gcube.indexmanagement.forwardindexmanagement.stubs.KeyDescriptionType[] desc = new org.gcube.indexmanagement.forwardindexmanagement.stubs.KeyDescriptionType[indexedFields.length];
			for(int i=0; i<indexedFields.length; i++)
			{
				desc[i] = new org.gcube.indexmanagement.forwardindexmanagement.stubs.KeyDescriptionType();
				desc[i].setKeyName(indexedFields[i]);
				desc[i].setIndexTypeID(indexTypeIDs[i]);
			}
			KeyDescriptionArray keyArray = new KeyDescriptionArray(desc);
			forwardIndexManagementCreateResource.setKeyDescription(keyArray);
			forwardIndexManagementCreateResource.setIndexID(indexID);
			forwardIndexManagementCreateResource.setContentType("metadata");
			
			// indexTypeID; "index_type_int_string"
			//              "index_type_float_string");
			//              "index_type_date_string");
			//              "index_type_string_string");

			org.gcube.indexmanagement.forwardindexmanagement.stubs.CreateResourceResponse forwardIndexManagementCreateResourceResponse = 
				forwardIndexManagementFactoryPortType.createResource(forwardIndexManagementCreateResource);
			return forwardIndexManagementCreateResourceResponse.getIndexID();
		}
		catch (Exception ex) {
			ex.printStackTrace();
			System.exit(0);
		}
		return null;
	}

	private ForwardIndexLookupFactoryPortType createForwardIndexLookupFactory(GCUBEScope scope, GCUBESecurityManager secManager) {
        try {
            // Get factory portType
        	ForwardIndexLookupFactoryServiceAddressingLocator forwardIndexLookupFactoryLocator = new ForwardIndexLookupFactoryServiceAddressingLocator();
        	EndpointReferenceType forwardIndexLookupFactoryEPR = new EndpointReferenceType();
            forwardIndexLookupFactoryEPR.setAddress(new Address(lookupFactoryURI));
            ForwardIndexLookupFactoryPortType forwardIndexLookupFactoryPortType = forwardIndexLookupFactoryLocator.getForwardIndexLookupFactoryPortTypePort(forwardIndexLookupFactoryEPR);
            forwardIndexLookupFactoryPortType = GCUBERemotePortTypeContext.getProxy(forwardIndexLookupFactoryPortType, scope, secManager);
            return forwardIndexLookupFactoryPortType;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(0);
        }
        return null;
    }
	
	private void createForwardIndexLookupResource(String mainIndexID, ForwardIndexLookupFactoryPortType forwardIndexLookupFactoryPortType) throws RemoteException {
    	// Create forwardIndex resource and get endpoint reference of WS-Resource.
    	org.gcube.indexmanagement.forwardindexlookup.stubs.CreateResource forwardIndexLookupCreateResource =
    		new org.gcube.indexmanagement.forwardindexlookup.stubs.CreateResource();

    	forwardIndexLookupCreateResource.setMainIndexID(mainIndexID);
    	try{
    		forwardIndexLookupFactoryPortType.createResource(forwardIndexLookupCreateResource);
    	}catch(RemoteException e){
    		e.printStackTrace();
    		throw e;
    	}
    	
    }

	private ForwardIndexLookupPortType findForwardIndexLookupResource(String collectionID, String[] indexedFields, GCUBEScope scope, GCUBESecurityManager secManager) {
		List<EndpointReferenceType> eprs = null;
		try {
			List<String[]> props = new LinkedList<String[]>();
			props.add(new String[] { "ServiceClass", "Index" });
			props.add(new String[] { "ServiceName", "ForwardIndexLookup" });
			props.add(new String[] { "CollectionID", collectionID });
			List<String[]> keyNames = new LinkedList<String[]>();
			for(int i=0; i<indexedFields.length; i++)
				keyNames.add(new String[] { "KeyName", indexedFields[i] });
			eprs = getWSResourceEPRsFromKeyNames(props, keyNames, scope);
		} catch (Exception e) {
			e.printStackTrace();
			System.exit(-1);
		}
		
		
		if (eprs.size() == 0) {
			System.out.println("Error: Found " + eprs.size() + " lookup resources for the given collection ID and indexed field names.");
			System.exit(-1);
		}
		else if (eprs.size() > 1) {
			System.out.println("Warning: Found " + eprs.size() + " lookup resources for the given collection ID and indexed field names. Returning the first one.");
		}
		EndpointReferenceType epr = eprs.get(0);

		ForwardIndexLookupServiceAddressingLocator instanceLocator = new ForwardIndexLookupServiceAddressingLocator();
		ForwardIndexLookupPortType port = null;
		try {
			port = instanceLocator.getForwardIndexLookupPortTypePort(epr);
			port = GCUBERemotePortTypeContext.getProxy(port, scope, secManager);
			return port;
		} catch (Exception e) {
			e.printStackTrace();
			System.exit(0);
		}
		return null;
	}

	private ForwardIndexLookupPortType[] findAllForwardIndexLookupResources(String indexID, GCUBEScope scope, GCUBESecurityManager secManager) {
		List<EndpointReferenceType> eprs = null;
		try {
			List<String[]> props = new LinkedList<String[]>();
			props.add(new String[] { "ServiceClass", "Index" });
			props.add(new String[] { "ServiceName", "ForwardIndexLookup" });
			props.add(new String[] { "IndexID", indexID });
			eprs = getWSResourceEPRsFromPropValues(props, scope);
		} catch (Exception e) {
			e.printStackTrace();
			System.exit(-1);
		}

		ForwardIndexLookupPortType[] ret = new ForwardIndexLookupPortType[eprs.size()];
		for (int i=0; i<eprs.size(); i++) {
			EndpointReferenceType epr = eprs.get(i);
			ForwardIndexLookupServiceAddressingLocator instanceLocator = new ForwardIndexLookupServiceAddressingLocator();
			ForwardIndexLookupPortType port = null;
			try {
				port = instanceLocator.getForwardIndexLookupPortTypePort(epr);
				port = GCUBERemotePortTypeContext.getProxy(port, scope, secManager);
				ret[i] = port;
			} catch (Exception e) {
				e.printStackTrace();
				System.exit(0);
			}
		}
		return ret;
	}
	
	private Map<String, List<String>> findAllForwardIndexIDsByCol(String collectionID, String[] indexedFields, GCUBEScope scope, GCUBESecurityManager secManager) {
		List<EndpointReferenceType> eprs = null;
		Map<String, List<String>> result = new HashMap<String, List<String>>();
		
		//List<String> result = new LinkedList<String>();
		
		result.put("Manager", new LinkedList<String>());
		result.put("Lookup", new LinkedList<String>());
		try {
			List<String[]> props = new LinkedList<String[]>();
			props.add(new String[] { "ServiceClass", "Index" });
			props.add(new String[] { "ServiceName", "ForwardIndexManagement" });
			props.add(new String[] { "CollectionID", collectionID });
			List<String[]> keyNames = new LinkedList<String[]>();
			for(int i=0; i<indexedFields.length; i++)
				keyNames.add(new String[] { "KeyName", indexedFields[i] });
			eprs = getWSResourceEPRsFromKeyNames(props, keyNames, scope);
			List<String> l = result.get("Manager");
			for (EndpointReferenceType epr : eprs) {
				String indexDesc = "IndexID: " + getPropertyValueFromWSResourceEPR(epr, "IndexID", scope).get(0) +
									" DocCount: " + getPropertyValueFromWSResourceEPR(epr, "DocumentCount", scope).get(0);
				l.add(indexDesc);
			}
			
			List<String[]> props2 = new LinkedList<String[]>();
			props2.add(new String[] { "ServiceClass", "Index" });
			props2.add(new String[] { "ServiceName", "ForwardIndexLookup" });
			props2.add(new String[] { "CollectionID", collectionID });
			eprs = getWSResourceEPRsFromKeyNames(props2, keyNames, scope);
			l = result.get("Lookup");
			for (EndpointReferenceType epr : eprs) {
				String indexDesc = "IndexID: " + getPropertyValueFromWSResourceEPR(epr, "IndexID", scope).get(0) +
									" DocCount: " + getPropertyValueFromWSResourceEPR(epr, "DocumentCount", scope).get(0);
				l.add(indexDesc);
			}
		} catch (Exception e) {
			e.printStackTrace();
			System.exit(-1);
		}

		return result;
	}
	
	private ForwardIndexManagementPortType findForwardIndexManagementResource(String collectionID, String[] indexedFields, GCUBEScope scope, GCUBESecurityManager secManager) {		
		List<EndpointReferenceType> eprs = null;
		
		try {
			List<String[]> props = new LinkedList<String[]>();
			props.add(new String[] { "ServiceClass", "Index" });
			props.add(new String[] { "ServiceName", "ForwardIndexManagement" });
			props.add(new String[] { "CollectionID", collectionID });
			List<String[]> keyNames = new LinkedList<String[]>();
			for(int i=0; i<indexedFields.length; i++)
				keyNames.add(new String[] { "KeyName", indexedFields[i] });
			eprs = getWSResourceEPRsFromKeyNames(props, keyNames, scope);
		} catch (Exception e) {
			e.printStackTrace();
			System.exit(-1);
		}
		
		if (eprs.size() != 1) {
			System.out.println("Error: Found " + eprs.size() + " management resources for the given collection ID and indexed field name.");
			System.exit(0);
		}
		EndpointReferenceType epr = eprs.get(0);

		ForwardIndexManagementServiceAddressingLocator instanceLocator = new ForwardIndexManagementServiceAddressingLocator();
		ForwardIndexManagementPortType port = null;
		try {
			port = instanceLocator.getForwardIndexManagementPortTypePort(epr);
			port = GCUBERemotePortTypeContext.getProxy(port, scope, secManager);
			return port;
		} catch (Exception e) {
			e.printStackTrace();
			System.exit(0);
		}
		return null;
	}
	
	private ForwardIndexManagementPortType getForwardIndexManagementResource(String indexID, GCUBEScope scope, GCUBESecurityManager secManager) {
		List<EndpointReferenceType> eprs = null;
		
		try {
			List<String[]> props = new LinkedList<String[]>();
			props.add(new String[] { "ServiceClass", "Index" });
			props.add(new String[] { "ServiceName", "ForwardIndexManagement" });
			props.add(new String[] { "IndexID", indexID });
			eprs = getWSResourceEPRsFromPropValues(props, scope);
		} catch (Exception e) {
			e.printStackTrace();
			System.exit(-1);
		}
		
		if (eprs.size() != 1) {
			System.out.println("Error: Found " + eprs.size() + " management resources for the given indexID.");
			System.exit(0);
		}
		EndpointReferenceType epr = eprs.get(0);

		ForwardIndexManagementServiceAddressingLocator instanceLocator = new ForwardIndexManagementServiceAddressingLocator();
		ForwardIndexManagementPortType port = null;
		try {
			port = instanceLocator.getForwardIndexManagementPortTypePort(epr);
			port = GCUBERemotePortTypeContext.getProxy(port, scope, secManager);
			return port;
		} catch (Exception e) {
			e.printStackTrace();
			System.exit(0);
		}
		return null;
	}
	
	private String doLookup(ForwardIndexLookupPortType lookup, String operator, String value1, String value2, String keyName, ResultType resultType) throws Exception {
		String result = null;
		
		if (operator == null) {
			GetAll param = new GetAll();
			param.setKeyName(keyName);
			//to test descending retrieval too 
			param.setAscending(false);
			param.setResult(resultType);
			result = lookup.getAll(param);
		}
		else if (operator.equalsIgnoreCase("EQ")) {
			GetEQ param = new GetEQ();
			param.setKeyEQ(value1);
			param.setKeyName(keyName);
			param.setResult(resultType);
			result = lookup.getEQ(param);
		}
		else if (operator.equalsIgnoreCase("GT")) {
			GetGT param = new GetGT();
			param.setKeyGT(value1);
			param.setKeyName(keyName);
			param.setResult(resultType);
			result = lookup.getGT(param);
		}
		else if (operator.equalsIgnoreCase("GE")) {
			GetGE param = new GetGE();
			param.setKeyGE(value1);
			param.setKeyName(keyName);
			param.setResult(resultType);
			result = lookup.getGE(param);
		}
		else if (operator.equalsIgnoreCase("LT")) {
			GetLT param = new GetLT();
			param.setKeyLT(value1);
			param.setKeyName(keyName);
			param.setResult(resultType);
			result = lookup.getLT(param);
		}
		else if (operator.equalsIgnoreCase("LE")) {
			GetLE param = new GetLE();
			param.setKeyLE(value1);
			param.setKeyName(keyName);
			param.setResult(resultType);
			result = lookup.getLE(param);
		}
		else if (operator.equalsIgnoreCase("GEandLE")) {
			GetGEandLE param = new GetGEandLE();
			param.setKeyGE(value1);
			param.setKeyLE(value2);
			param.setKeyName(keyName);
			param.setResult(resultType);
			result = lookup.getGEandLE(param);
		}
		else if (operator.equalsIgnoreCase("GEandLT")) {
			GetGEandLT param = new GetGEandLT();
			param.setKeyGE(value1);
			param.setKeyLT(value2);
			param.setKeyName(keyName);
			param.setResult(resultType);
			result = lookup.getGEandLT(param);
		}
		else if (operator.equalsIgnoreCase("GTandLE")) {
			GetGTandLE param = new GetGTandLE();
			param.setKeyGT(value1);
			param.setKeyLE(value2);
			param.setKeyName(keyName);
			param.setResult(resultType);
			result = lookup.getGTandLE(param);
		}
		else if (operator.equalsIgnoreCase("GTandLT")) {
			GetGTandLT param = new GetGTandLT();
			param.setKeyGT(value1);
			param.setKeyLT(value2);
			param.setKeyName(keyName);
			param.setResult(resultType);
			result = lookup.getGTandLT(param);
		}
		
		return result;
	}

	private ForwardIndexUpdaterFactoryPortType createForwardIndexUpdaterFactory(GCUBEScope scope, GCUBESecurityManager secManager) {
        try {
            // Get factory portType
        	ForwardIndexUpdaterFactoryServiceAddressingLocator forwardIndexUpdaterFactoryLocator = new ForwardIndexUpdaterFactoryServiceAddressingLocator();
        	EndpointReferenceType forwardIndexUpdaterFactoryEPR = new EndpointReferenceType();
            forwardIndexUpdaterFactoryEPR.setAddress(new Address(updaterFactoryURI));
            ForwardIndexUpdaterFactoryPortType forwardIndexUpdaterFactoryPortType = forwardIndexUpdaterFactoryLocator.getForwardIndexUpdaterFactoryPortTypePort(forwardIndexUpdaterFactoryEPR);
            forwardIndexUpdaterFactoryPortType = GCUBERemotePortTypeContext.getProxy(forwardIndexUpdaterFactoryPortType, scope, secManager);
            return forwardIndexUpdaterFactoryPortType;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(0);
        }
        return null;
    }

	private String findForwardIndexID(String collectionID, String[] indexedFields, GCUBEScope scope, GCUBESecurityManager secManager) {
		List<EndpointReferenceType> eprs = null;
		try {
			List<String[]> props = new LinkedList<String[]>();
			props.add(new String[] { "ServiceClass", "Index" });
			props.add(new String[] { "ServiceName", "ForwardIndexManagement" });
			props.add(new String[] { "CollectionID", collectionID });
			List<String[]> keyNames = new LinkedList<String[]>();
			for(int i=0; i<indexedFields.length; i++)
				keyNames.add(new String[] { "KeyName", indexedFields[i] });
			eprs = getWSResourceEPRsFromKeyNames(props, keyNames, scope);
		} catch (Exception e) {
			e.printStackTrace();
			System.exit(-1);
		}
		
		if (eprs.size() != 1) {
			System.out.println("Error: Found " + eprs.size() + " management resources for the given collection ID and indexed field name.");
			System.exit(0);
		}
		EndpointReferenceType epr = eprs.get(0);

		try {
			return getPropertyValueFromWSResourceEPR(epr, "IndexID", scope).get(0);
		} catch (Exception e) {
			e.printStackTrace();
			System.exit(0);
		}
		return null;
	}

	private ForwardIndexUpdaterPortType createForwardIndexUpdaterResource(String mainIndexID, ForwardIndexUpdaterFactoryPortType forwardIndexUpdaterFactoryPortType, GCUBEScope scope, GCUBESecurityManager secManager) {
		try {
			// Create forwardIndex resource and get endpoint reference of WS-Resource.
            org.gcube.indexmanagement.forwardindexupdater.stubs.CreateResource forwardIndexUpdaterCreateResource =
                new org.gcube.indexmanagement.forwardindexupdater.stubs.CreateResource();       
            forwardIndexUpdaterCreateResource.setMainIndexID(mainIndexID);

            org.gcube.indexmanagement.forwardindexupdater.stubs.CreateResourceResponse forwardIndexUpdaterCreateResourceResponse = 
                forwardIndexUpdaterFactoryPortType.createResource(forwardIndexUpdaterCreateResource);
            EndpointReferenceType forwardIndexUpdaterInstanceEPR = forwardIndexUpdaterCreateResourceResponse.getEndpointReference();
            
            // Port type
            org.gcube.indexmanagement.forwardindexupdater.stubs.service.ForwardIndexUpdaterServiceAddressingLocator forwardIndexupdaterServiceAddressingLocator = 
                new org.gcube.indexmanagement.forwardindexupdater.stubs.service.ForwardIndexUpdaterServiceAddressingLocator();
            
            ForwardIndexUpdaterPortType forwardIndexUpdaterPortTypePort = forwardIndexupdaterServiceAddressingLocator.getForwardIndexUpdaterPortTypePort(forwardIndexUpdaterInstanceEPR);
            forwardIndexUpdaterPortTypePort = GCUBERemotePortTypeContext.getProxy(forwardIndexUpdaterPortTypePort, scope, secManager);
            return forwardIndexUpdaterPortTypePort;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(0);
        }
        return null;
    }
	
	private void updateIndexWithRowsetResultSet(ForwardIndexUpdaterPortType updater, String RS_EPR) {
		try {
			updater.processResultSet(RS_EPR); 
		} catch (Exception e) {
			e.printStackTrace();
			System.exit(0);
		}
	}
    
	/**
	 * Helper method to get a GSSCredential object from a given file
	 * @param filename file containing the (VOMS) credentials
	 * @return the corresponding GSSCredential object
	 * @throws Exception on error
	 */
	private static GSSCredential getCredFromFile(String filename) throws Exception {
		GSSCredential retcred = null;
 
		try {
			File inFile = new File(filename);
			byte [] data = new byte[(int)inFile.length()];
			FileInputStream inStream = new FileInputStream(inFile);
			inStream.read(data);
			inStream.close();
			ExtendedGSSManager manager = (ExtendedGSSManager)ExtendedGSSManager.getInstance();
			retcred = manager.createCredential(data,ExtendedGSSCredential.IMPEXP_OPAQUE,GSSCredential.DEFAULT_LIFETIME,null/*use default mechanism - GSI*/,GSSCredential.INITIATE_AND_ACCEPT);
		} catch (Exception e) {
			throw e;
		}
		return retcred;
	}
	
	/**
	 * Reads the contents of a text file.
	 * 
	 * @param filename The name of the file to read
	 * @return the contents of the file as a string
	 * @throws IOException
	 */
	private static String readTextFile(String filename) throws IOException {
		BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(filename), "UTF-8"));
		StringBuffer buf = new StringBuffer();
		String tmp;
		while ((tmp = br.readLine()) != null) {
			if (!tmp.startsWith("<?xml"))
				buf.append(tmp + "\n");
		}
		br.close();
		return buf.toString();
	}
	
	public void run(String[] args) {
		ExtendedGSSCredential cred = null;
		String collectionName = null;
		String collectionID = null;
		String collectionSchema = null;
		String collectionLang = null;
		String query = null;
		String[] indexTypeIDs = null;
		String[] indexedFields = null;
		String indexID_create = null;
		String RS_EPR_file = null;
		String operator = null;
		String value1 = null;
		String value2 = null;
		String indexIDToDelete = null;
		String keyName = null;
		ResultType resultType = null;
		int baseArg = -1;
		operationMode mode = operationMode.CREATE;
		GCUBESecurityManagerImpl secManager = null;
		boolean bHandleManager = false;
		boolean bHandleLookup = false;
		
		/* Check if we should act in a secure way and load the credential if yes */
		if (args[0].equals("-cred")) {
			try {
				cred = (ExtendedGSSCredential) getCredFromFile(args[1]);
			} catch (Exception e) {
				e.printStackTrace();
				System.exit(0);
			}
			baseArg = 1;
			
			try {
				secManager = new GCUBESecurityManagerImpl() {  public boolean isSecurityEnabled() {return true;}};
				secManager.useCredentials(cred);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		else {
			secManager = new GCUBESecurityManagerImpl() {  public boolean isSecurityEnabled() {return false;}};
		}
		
		/* Get the scope */
		GCUBEScope scope = GCUBEScope.getScope(args[baseArg+1]);
		baseArg++;
		
		/* Check syntax */
		if (args[baseArg+1].equalsIgnoreCase("-create")) {
			if (args[baseArg+2].equals("manager"))
				bHandleManager = true;
			else if (args[baseArg+2].equals("lookup"))
				bHandleLookup = true;
			else {
				bHandleManager = true;
				bHandleLookup = true;
			}
			collectionName = args[baseArg+3];
			collectionSchema = args[baseArg+4];
			collectionLang = args[baseArg+5];
			int indexedFieldsNumber = Integer.parseInt(args[baseArg+6]);
			indexedFields = new String[indexedFieldsNumber];
			indexTypeIDs = new String[indexedFieldsNumber];
			for(int i=0; i<indexedFieldsNumber; i++)
			{
				indexedFields[i] = args[baseArg + 7 + 2*i];
				indexTypeIDs[i] = args[baseArg + 7 + 2*i + 1];
			}
			if (args.length > (baseArg + 7 + 2*indexedFieldsNumber))
				indexID_create = args[baseArg + 7 + 2*indexedFieldsNumber];
			mode = operationMode.CREATE;
		}
		else if (args[baseArg+1].equalsIgnoreCase("-feed")) {
			collectionName = args[baseArg+2];
			collectionSchema = args[baseArg+3];
			collectionLang = args[baseArg+4];
			RS_EPR_file = args[baseArg+5];
			int indexedFieldsNumber = Integer.parseInt(args[baseArg+6]);
			indexedFields = new String[indexedFieldsNumber];
			for(int i=0; i<indexedFieldsNumber; i++)
			{
				indexedFields[i] = args[baseArg + 7 + i];
			}
			mode = operationMode.FEED;
		}
		else if (args[baseArg+1].equalsIgnoreCase("-lookup")) {
			collectionName = args[baseArg+2];
			collectionSchema = args[baseArg+3];
			collectionLang = args[baseArg+4];
			int indexedFieldsNumber = Integer.parseInt(args[baseArg+5]);
			indexedFields = new String[indexedFieldsNumber];
			for(int i=0; i<indexedFieldsNumber; i++)
			{
				indexedFields[i] = args[baseArg + 6 + i];
			}
			int resT = Integer.parseInt(args[baseArg + 6 + indexedFieldsNumber]);
			resultType = null;
			switch(resT){
			case 0: resultType = ResultType.keysData; break;
			case 1: resultType = ResultType.keysOnly; break;
			case 2: resultType = ResultType.dataOnly; break;
			}
			keyName = args[baseArg + 7 + indexedFieldsNumber];
			if (args.length > (baseArg + 8 + indexedFieldsNumber)) {
				operator = args[baseArg + 8 + indexedFieldsNumber];
				value1 = args[baseArg + 9 + indexedFieldsNumber];
				if (args.length > (baseArg + 10 + indexedFieldsNumber))
					value2 = args[baseArg + 10 + indexedFieldsNumber];
			}
			mode = operationMode.LOOKUP;
		}
		else if (args[baseArg+1].equalsIgnoreCase("-multi")) {
			collectionName = args[baseArg+2];
			collectionSchema = args[baseArg+3];
			collectionLang = args[baseArg+4];
			int indexedFieldsNumber = Integer.parseInt(args[baseArg+5]);
			indexedFields = new String[indexedFieldsNumber];
			for(int i=0; i<indexedFieldsNumber; i++)
			{
				indexedFields[i] = args[baseArg + 6 + i];
			}
			query = args[baseArg + 6 + indexedFieldsNumber];
			mode = operationMode.MULTI;
		}
		else if (args[baseArg+1].equalsIgnoreCase("-destroy")) {
			if (args[baseArg+2].equals("manager"))
				bHandleManager = true;
			else if (args[baseArg+2].equals("lookup"))
				bHandleLookup = true;
			else {
				bHandleManager = true;
				bHandleLookup = true;
			}
			collectionName = args[baseArg+3];
			collectionSchema = args[baseArg+4];
			collectionLang = args[baseArg+5];
			int indexedFieldsNumber = Integer.parseInt(args[baseArg+6]);
			indexedFields = new String[indexedFieldsNumber];
			for(int i=0; i<indexedFieldsNumber; i++)
			{
				indexedFields[i] = args[baseArg + 7 + i];
			}
			mode = operationMode.DESTROY;
		}
		else if (args[baseArg+1].equalsIgnoreCase("-destroyIndexID")) {
			if (args[baseArg+2].equals("manager"))
				bHandleManager = true;
			else if (args[baseArg+2].equals("lookup"))
				bHandleLookup = true;
			else {
				bHandleManager = true;
				bHandleLookup = true;
			}
			indexIDToDelete = args[baseArg+3];
			mode = operationMode.DESTROYID;
		}
		else if (args[baseArg+1].equalsIgnoreCase("-remove")) {
			if (args[baseArg+2].equals("manager"))
				bHandleManager = true;
			else if (args[baseArg+2].equals("lookup"))
				bHandleLookup = true;
			else {
				bHandleManager = true;
				bHandleLookup = true;
			}
			collectionName = args[baseArg+3];
			collectionSchema = args[baseArg+4];
			collectionLang = args[baseArg+5];
			int indexedFieldsNumber = Integer.parseInt(args[baseArg+6]);
			indexedFields = new String[indexedFieldsNumber];
			for(int i=0; i<indexedFieldsNumber; i++)
			{
				indexedFields[i] = args[baseArg + 7 + i];
			}
			mode = operationMode.REMOVE;
		}
		else if (args[baseArg+1].equalsIgnoreCase("-list")) {
			collectionName = args[baseArg+2];
			collectionSchema = args[baseArg+3];
			collectionLang = args[baseArg+4];
			int indexedFieldsNumber = Integer.parseInt(args[baseArg+5]);
			indexedFields = new String[indexedFieldsNumber];
			for(int i=0; i<indexedFieldsNumber; i++)
			{
				indexedFields[i] = args[baseArg + 6 + i];
			}
			mode = operationMode.LIST;
		}
		else {
			System.out.println("Invalid parameter: " + args[baseArg+1]);
			System.exit(0);
		}
		
		
		
		/* Get the content collection ID from the collection name */
		try {
			String VOFileName = args[baseArg].replace("/", "_") + ".properties";
			VOInfoManager VOManager = new VOInfoManager(VOFileName);
			CollectionInfo colInfo = VOManager.findCollectionByName(collectionName);
			if (colInfo == null) {
				System.out.println("Collection not found in VO properties, proceeding in 'fake collection' mode...");
				collectionID = collectionName;
			} else {
				MetadataCollectionInfo mcInfo = colInfo.findMetadataCollection(collectionSchema, collectionLang);
				if (mcInfo == null) {
					System.out.println("Metadata Collection not found in VO properties.");
					System.exit(-1);
				}
				collectionID = mcInfo.getID();
			}
			
			managementFactoryURI = VOManager.getForwardIndexManagementFactoryURI();
			lookupFactoryURI = VOManager.getForwardIndexLookupFactoryURI();
			updaterFactoryURI = VOManager.getForwardIndexUpdaterFactoryURI();
		} catch (Exception e) {
			System.out.println("Failed to parse VO properties file: " + e);
			System.exit(-1);
		}
		
		
		
		if (mode == operationMode.CREATE) {			
			/* Create the index management resource */
			if (bHandleManager) {
				ForwardIndexManagementFactoryPortType managementPortType = createForwardIndexManagementFactory(scope, secManager);
				indexID_create = createForwardIndexManagementResource(collectionID, indexedFields, indexTypeIDs, managementPortType, indexID_create);
			}
			try{
			Thread.sleep(6000);
			}catch(Exception e){
			}
			
			if (bHandleLookup) {
				if (indexID_create == null)
					indexID_create = findForwardIndexID(collectionID, indexedFields, scope, secManager); 
				
				System.out.println("Found index with ID: " + indexID_create);
						
				/* Get the forward index lookup factory service porttype */
				ForwardIndexLookupFactoryPortType lookupPortType = createForwardIndexLookupFactory(scope, secManager);
	
				/* Create the index lookup resource */
				boolean bRetry;
				do {
					bRetry = false;
					try {
						createForwardIndexLookupResource(indexID_create, lookupPortType);
					} catch (Exception e) {
						System.out.println("Failed to create the lookup resource, probably because the management resource has not been published to the IS yet. Retrying...");
						//e.printStackTrace();
						bRetry = true;
					}
					try{
					Thread.sleep(3000);
					}catch(Exception e){						
					}
				} while (bRetry);			
				System.out.println("Lookup resource created successfully");
			}
		}
		else if (mode == operationMode.DESTROY) {
			try {
				if (bHandleManager) {
					ForwardIndexManagementPortType mng = findForwardIndexManagementResource(collectionID, indexedFields, scope, secManager);
					mng.destroy(new Destroy());
				}
				
				if (bHandleLookup) {
					ForwardIndexLookupPortType look = findForwardIndexLookupResource(collectionID, indexedFields, scope, secManager);
					if (look != null)
						look.destroy(new Destroy());
				}
			} catch (Exception e) { }
		}
		else if (mode == operationMode.DESTROYID) {
			try {
				if (bHandleManager) {
					ForwardIndexManagementPortType mng = getForwardIndexManagementResource(indexIDToDelete, scope, secManager);
					mng.destroy(new Destroy());
				}
				
				if (bHandleLookup) {
					for (ForwardIndexLookupPortType look : findAllForwardIndexLookupResources(indexIDToDelete, scope, secManager)) {
						look.destroy(new Destroy());
					}
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		else if (mode == operationMode.REMOVE) {
			try {
				if (bHandleManager) {
					ForwardIndexManagementPortType mng = findForwardIndexManagementResource(collectionID, indexedFields, scope, secManager);
					mng.destroyPartially(new org.gcube.indexmanagement.forwardindexmanagement.stubs.DestroyPartially());
				}
				
				if (bHandleLookup) {
					ForwardIndexLookupPortType look = findForwardIndexLookupResource(collectionID, indexedFields, scope, secManager);
//					if (look != null)
//						look.destroyPartially(new org.gcube.indexmanagement.forwardindexlookup.stubs.DestroyPartially());
				}
			} catch (Exception e) { }
		}
		else if (mode == operationMode.FEED){
			/* Read the rowset resultset EPR from the file */
			try {
				String RS_EPR = readTextFile(RS_EPR_file);
				String indexID = findForwardIndexID(collectionID, indexedFields, scope, secManager);
				System.out.println("Connecting to index with indexID: " + indexID + " for updating");
				
				/* Create the index updater resource */
				ForwardIndexUpdaterFactoryPortType updaterPortType = createForwardIndexUpdaterFactory(scope, secManager);
				ForwardIndexUpdaterPortType updater = createForwardIndexUpdaterResource(indexID, updaterPortType, scope, secManager);
				updateIndexWithRowsetResultSet(updater, RS_EPR);
				System.out.println("Updating completed successfully.");
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		else if (mode == operationMode.LOOKUP) {
			try {
				/* Find the index lookup resource */
				ForwardIndexLookupPortType lookup = findForwardIndexLookupResource(collectionID, indexedFields, scope, secManager);
				
				/* Perform the lookup */
				String result = doLookup(lookup, operator, value1, value2, keyName, resultType);
				System.out.println(result);
				
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		else if (mode == operationMode.MULTI) {
			try {
				/* Find the index lookup resource */
				ForwardIndexLookupPortType lookup = findForwardIndexLookupResource(collectionID, indexedFields, scope, secManager);
				
				/* Perform the lookup */
				String result = lookup.query(query);
				System.out.println(result);
				
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		else if (mode == operationMode.LIST) {
			try {
				Map<String, List<String>> result = findAllForwardIndexIDsByCol(collectionID, indexedFields, scope, secManager);
				for (String indexResourceType : result.keySet()) {
					for (String indexData : result.get(indexResourceType))
					System.out.println("Found " + indexResourceType + ", " + indexData);
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
	}

	public static void main(String[] args) {
		new ForwardIndexClient().run(args);
	}

}
