/*
 * Decompiled with CFR 0.152.
 */
package elasticsearchindex.components;

import java.util.List;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGenericResourceQuery;
import org.gcube.common.core.resources.GCUBEGenericResource;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;

public class IndexType {
    private static final String INDEX_TYPE_GENERIC_RESOURCE_PREFIX = "IndexType_";
    public static final String DOCID_FIELD = "ObjectID";
    public static final String PAYLOAD_FIELD = "fullpayload";
    public static final String STATS_FIELD = "docStatistics";
    public static final String SCORE_FIELD = "rank";
    public static final String COLLECTION_FIELD = "gDocCollectionID";
    public static final String LANGUAGE_FIELD = "gDocCollectionLang";
    public static final String SEPERATOR_FIELD_INFO = ":";
    public static final String WILDCARD = "*";
    public static final String SNIPPET = "S";
    public static final String PRESENTABLE_TAG = "p";
    public static final String SEARCHABLE_TAG = "s";
    public static final String RESULTSNO_EVENT = "resultsNumber";
    public static final String RESULTSNOFINAL_EVENT = "resultsNumberFinal";
    public static final String GEOFIELD = "geo";
    public static final String RATIO = "ratio";
    public static final String APXCOUNT = "apxcount";
    public static final String DOCNR = "docNr";
    public static final String MBR = "mbr";
    public static final String[] GEODEFAULT = new String[]{"ratio", "apxcount", "docNr", "mbr", "gDocCollectionID", "gDocCollectionLang"};
    private static GCUBELog log = new GCUBELog(IndexType.class);
    protected String indexTypeID;
    protected String indexType;

    protected IndexType(String indexTypeName) {
        this.indexTypeID = indexTypeName;
    }

    public String getIndexTypeName() {
        return this.indexTypeID;
    }

    public String getIndexTypeAsString() {
        return this.indexType;
    }

    public String retrieveIndexTypeGenericResource(GCUBEScope scope) throws Exception {
        String resourceName = INDEX_TYPE_GENERIC_RESOURCE_PREFIX + this.indexTypeID;
        try {
            ISClient client = (ISClient)GHNContext.getImplementation(ISClient.class);
            GCUBEGenericResourceQuery query = (GCUBEGenericResourceQuery)client.getQuery(GCUBEGenericResourceQuery.class);
            query.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("/Profile/Name", resourceName)});
            List result = client.execute((ISQuery)query, scope);
            if (result == null || result.size() == 0) {
                throw new Exception("Generic resource not found.");
            }
            this.indexType = ((GCUBEGenericResource)result.get(0)).getBody();
            return this.indexType;
        }
        catch (Exception e) {
            log.error((Object)("Failed to retrieve the generic resource with name = " + resourceName), (Throwable)e);
            throw new Exception("Failed to retrieve the generic resource with name = " + resourceName);
        }
    }

    public static boolean sendIndication(long retrieved) {
        if (retrieved < 10L && retrieved == 5L) {
            return true;
        }
        if (retrieved < 100L && retrieved % 10L == 0L) {
            return true;
        }
        return retrieved % 100L == 0L;
    }
}

