/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.elasticsearch.helpers;

import com.google.common.collect.Iterables;
import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.proxy.IWriterProxy;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPWriterProxy;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.GenericRecordDefinition;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.FieldDefinition;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.grs.record.field.StringFieldDefinition;
import gr.uoa.di.madgik.grs.writer.GRS2WriterException;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHitField;
import org.gcube.elasticsearch.FTNodeCache;
import org.gcube.elasticsearch.helpers.SnippetsHelper;
import org.gcube.indexmanagement.common.FullTextIndexType;
import org.gcube.indexmanagement.common.IndexException;
import org.gcube.indexmanagement.resourceregistry.RRadaptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryParser {
    private static final Logger logger = LoggerFactory.getLogger(QueryParser.class);
    private static String regexCollID = "gDocCollectionID\\s*==\\s*\"(\\S+)\"";
    private static Pattern patternCollID = Pattern.compile(regexCollID);

    private static Set<String> getIndexTypesByCollectionID(Map<String, Set<String>> indexTypesByCollIDs, String collID, Client client, String indexName) {
        Set<String> indexTypes = null;
        if (indexTypesByCollIDs.containsKey(collID)) {
            indexTypes = indexTypesByCollIDs.get(collID);
            logger.info("indexTypes for collectionID found in cache");
        } else {
            logger.info("indexTypes for collectionID not found in cache");
            indexTypes = new HashSet<String>();
            SearchRequestBuilder srb = client.prepareSearch(new String[]{indexName}).setQuery((QueryBuilder)QueryBuilders.termQuery((String)"gDocCollectionID", (String)collID)).setNoFields();
            logger.trace("query request : " + srb.toString());
            SearchResponse response = (SearchResponse)srb.execute().actionGet();
            logger.trace("query response : " + response);
            for (SearchHit hit : response.getHits().getHits()) {
                indexTypes.add(hit.getType());
            }
        }
        logger.info("for collectionID : " + collID + " indexTypes found : " + indexTypes);
        return indexTypes;
    }

    public static Set<String> getIndexTypesByCollectionIDs(Map<String, Set<String>> indexTypesByCollIDs, Set<String> collIDs, Client client, String indexName) {
        HashSet<String> indexTypes = new HashSet<String>();
        for (String collID : collIDs) {
            indexTypes.addAll(QueryParser.getIndexTypesByCollectionID(indexTypesByCollIDs, collID, client, indexName));
        }
        return indexTypes;
    }

    public static List<String> createPresentableForIndexTypes(Map<String, List<String>> presentableFieldsPerIndexType, Set<String> indexTypes) {
        HashSet presentables = new HashSet();
        for (String idxType : indexTypes) {
            presentables.addAll(presentableFieldsPerIndexType.get(idxType));
        }
        logger.info("for indexTypes : " + indexTypes + " presentables found : " + presentables);
        return new ArrayList<String>(presentables);
    }

    public static List<String> createSearchablesForIndexTypes(Map<String, List<String>> searchablesFieldsPerIndexType, Set<String> indexTypes) {
        HashSet searchables = new HashSet();
        for (String idxType : indexTypes) {
            searchables.addAll(searchablesFieldsPerIndexType.get(idxType));
        }
        logger.info("for indexTypes : " + indexTypes + " searchables found : " + searchables);
        return new ArrayList<String>(searchables);
    }

    public static List<String> createHighlightablesForIndexTypes(Map<String, List<String>> highlightableFieldsPerIndexType, Set<String> indexTypes) {
        HashSet highlightables = new HashSet();
        for (String idxType : indexTypes) {
            highlightables.addAll(highlightableFieldsPerIndexType.get(idxType));
        }
        logger.info("for indexTypes : " + indexTypes + " highlightables found : " + highlightables);
        return new ArrayList<String>(highlightables);
    }

    public static List<String> getCollectionsIDFromQuery(String queryString) {
        ArrayList<String> matches = new ArrayList<String>();
        Matcher m = patternCollID.matcher(queryString);
        while (m.find()) {
            matches.add(m.group(1).trim());
        }
        return matches;
    }

    public static FieldDefinition[] createFieldDefinition(List<String> returnFields, RRadaptor adaptor) throws Exception {
        ArrayList<StringFieldDefinition> fieldDef = new ArrayList<StringFieldDefinition>();
        fieldDef.add(new StringFieldDefinition("rank"));
        fieldDef.add(new StringFieldDefinition("ObjectID"));
        logger.info("return fields : " + returnFields);
        if (returnFields != null) {
            for (String fieldName : returnFields) {
                String fieldID = null;
                fieldID = adaptor == null ? fieldName : adaptor.getFieldIDFromName(fieldName);
                fieldDef.add(new StringFieldDefinition(fieldID));
            }
        }
        return (FieldDefinition[])Iterables.toArray(fieldDef, FieldDefinition.class);
    }

    public static String createIndexTypekey(String indexType, String scope) {
        return indexType + "_" + scope;
    }

    public static FullTextIndexType retrieveIndexType(String indexTypeStr, String scope, FTNodeCache cache) {
        logger.info("scope : " + scope);
        FullTextIndexType indexType = null;
        logger.info("Retrieving index type for : " + indexTypeStr);
        if (cache.cachedIndexTypes.containsKey(QueryParser.createIndexTypekey(indexTypeStr, scope))) {
            logger.info("Index type : " + indexTypeStr + " found in cache");
            indexType = cache.cachedIndexTypes.get(QueryParser.createIndexTypekey(indexTypeStr, scope));
        } else {
            logger.info("Index type : " + indexTypeStr + " NOT found in cache");
            indexType = new FullTextIndexType(indexTypeStr, scope);
            logger.info("Retrieved from IS indextype : " + indexType);
            QueryParser.addFullTextIndexTypeIntoCache(indexTypeStr, scope, indexType, cache);
        }
        return indexType;
    }

    public static void addFullTextIndexTypeIntoCache(String indexTypeStr, String scope, FullTextIndexType indexType, FTNodeCache cache) {
        if (cache.cachedIndexTypes.containsKey(QueryParser.createIndexTypekey(indexTypeStr, scope))) {
            return;
        }
        logger.info("Index type : " + indexTypeStr + "adding into cache");
        cache.cachedIndexTypes.put(QueryParser.createIndexTypekey(indexTypeStr, scope), indexType);
        logger.info("Cache : " + cache.cachedIndexTypes);
    }

    private static String extractValueFromMap(Map<String, ? extends Object> docMap, String key, boolean isSource) {
        if (isSource) {
            Object val = docMap.get(key);
            return val == null ? null : val.toString();
        }
        return (String)((SearchHitField)docMap.get(key)).getValue();
    }

    private static String extractValueFromHit(Object obj, boolean isSource) {
        if (isSource) {
            return obj == null ? null : obj.toString();
        }
        return (String)((SearchHitField)obj).getValue();
    }

    public static boolean writeSearchHitFieldsInResultSet(SearchHit hit, RecordWriter<GenericRecord> rsWriter, List<String> returnFields, int maxFragmentCount, long rsTimeout) throws GRS2WriterException {
        if (rsWriter.getStatus() != IBuffer.Status.Open) {
            return false;
        }
        ArrayList<StringField> fields = new ArrayList<StringField>();
        Map docMap = null;
        docMap = hit.getFields();
        logger.trace("getting docMap from fields. fields : " + hit.getFields().size());
        logger.trace("Hit from index : ");
        logger.trace("-------------------------------------");
        if (logger.isTraceEnabled()) {
            for (Map.Entry f : docMap.entrySet()) {
                logger.trace((String)f.getKey() + ":" + ((SearchHitField)f.getValue()).getValue());
            }
        }
        logger.trace("-------------------------------------");
        logger.trace("Adding score field with value : " + hit.getScore());
        fields.add(new StringField(String.valueOf(hit.getScore())));
        String fieldContentDocID = docMap.containsKey("ObjectID") && docMap.get("ObjectID") != null && ((SearchHitField)docMap.get("ObjectID")).getValue() != null ? ((SearchHitField)docMap.get("ObjectID")).getValue().toString() : "NoMetaId";
        logger.trace("Adding ObjectID field with value : " + fieldContentDocID);
        fields.add(new StringField(fieldContentDocID));
        if (returnFields != null) {
            logger.trace("returnFields : " + returnFields);
            for (String fieldName : returnFields) {
                String fieldContent = null;
                fieldContent = fieldName.equalsIgnoreCase("S") ? SnippetsHelper.createSnippetString(hit, maxFragmentCount) : (docMap.containsKey(fieldName) && docMap.get(fieldName) != null && ((SearchHitField)docMap.get(fieldName)).getValue() != null ? ((SearchHitField)docMap.get(fieldName)).getValue().toString() : "");
                logger.trace("adding field : " + fieldName + " with value : " + fieldContent);
                fields.add(new StringField(fieldContent));
            }
        }
        if (rsWriter.getStatus() != IBuffer.Status.Open) {
            return false;
        }
        GenericRecord rec = new GenericRecord();
        rec.setFields((Field[])Iterables.toArray(fields, Field.class));
        while (!rsWriter.put((Record)rec, rsTimeout, TimeUnit.SECONDS) && rsWriter.getStatus() == IBuffer.Status.Open) {
        }
        return true;
    }

    public static boolean writeSearchHitInResultSet(SearchHit hit, RecordWriter<GenericRecord> rsWriter, List<String> returnFields, int maxFragmentCount, long rsTimeout) throws GRS2WriterException {
        if (rsWriter.getStatus() != IBuffer.Status.Open) {
            return false;
        }
        ArrayList<StringField> fields = new ArrayList<StringField>(returnFields.size());
        Map docMap = hit.getSource();
        boolean isSource = true;
        logger.trace("getting docMap from source. fields : " + hit.getSource().size());
        logger.trace("Hit from index : ");
        logger.trace("-------------------------------------");
        if (logger.isTraceEnabled()) {
            for (Map.Entry f : docMap.entrySet()) {
                logger.trace((String)f.getKey() + ":" + QueryParser.extractValueFromHit(f.getValue(), isSource));
            }
        }
        logger.trace("-------------------------------------");
        logger.trace("Adding score field with value : " + hit.getScore());
        fields.add(new StringField(String.valueOf(hit.getScore())));
        String fieldContentDocID = hit.getFields().containsKey("ObjectID") ? QueryParser.extractValueFromHit(hit.getFields().get("ObjectID"), false) : "NoMetaId";
        logger.trace("Adding ObjectID field with value : " + fieldContentDocID);
        fields.add(new StringField(fieldContentDocID));
        if (returnFields != null) {
            logger.trace("returnFields : " + returnFields);
            for (String fieldName : returnFields) {
                String fieldContent = null;
                fieldContent = fieldName.equalsIgnoreCase("S") ? SnippetsHelper.createSnippetString(hit, maxFragmentCount) : (docMap.containsKey(fieldName) ? QueryParser.extractValueFromMap(docMap, fieldName, isSource) : "");
                logger.trace("adding field : " + fieldName + " with value : " + fieldContent);
                fields.add(new StringField(fieldContent));
            }
        }
        if (rsWriter.getStatus() != IBuffer.Status.Open) {
            return false;
        }
        GenericRecord rec = new GenericRecord();
        rec.setFields((Field[])Iterables.toArray(fields, Field.class));
        while (!rsWriter.put((Record)rec, rsTimeout, TimeUnit.SECONDS) && rsWriter.getStatus() == IBuffer.Status.Open) {
        }
        return true;
    }

    public static RecordWriter<GenericRecord> initRSWriterForSearchHits(List<String> returnFields, RRadaptor adaptor) throws IndexException, GRS2WriterException {
        logger.info("Initializing gRS2 writer");
        logger.info("(1/3) getting field definitions");
        FieldDefinition[] fieldDef = null;
        try {
            fieldDef = QueryParser.createFieldDefinition(returnFields, adaptor);
        }
        catch (Exception e) {
            logger.error("Could not create field definition: ", (Throwable)e);
            throw new IndexException((Throwable)e);
        }
        logger.info("(2/3) creating record definitions");
        RecordDefinition[] definition = new RecordDefinition[]{new GenericRecordDefinition(fieldDef)};
        logger.info("(3/3) creating rsWriter");
        return new RecordWriter((IWriterProxy)new TCPWriterProxy(), definition, 200, 1, 0.5f);
    }
}

