/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.elasticsearch;

import gr.uoa.di.madgik.commons.server.ConnectionManagerConfig;
import gr.uoa.di.madgik.commons.server.ITCPConnectionManagerEntry;
import gr.uoa.di.madgik.commons.server.TCPConnectionManager;
import gr.uoa.di.madgik.grs.buffer.GRS2BufferException;
import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.events.BufferEvent;
import gr.uoa.di.madgik.grs.events.KeyValueEvent;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPConnectionHandler;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPStoreConnectionHandler;
import gr.uoa.di.madgik.grs.reader.ForwardReader;
import gr.uoa.di.madgik.grs.reader.GRS2ReaderException;
import gr.uoa.di.madgik.grs.record.GRS2RecordDefinitionException;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.writer.GRS2WriterException;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import gr.uoa.di.madgik.rr.ResourceRegistry;
import gr.uoa.di.madgik.rr.ResourceRegistryException;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.action.WriteConsistencyLevel;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.mapping.delete.DeleteMappingRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.indices.IndexMissingException;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;
import org.elasticsearch.search.SearchHit;
import org.gcube.elasticsearch.FTNodeCache;
import org.gcube.elasticsearch.helpers.ElasticSearchHelper;
import org.gcube.elasticsearch.helpers.QueryParser;
import org.gcube.elasticsearch.helpers.RowsetParser;
import org.gcube.indexmanagement.common.FullTextIndexType;
import org.gcube.indexmanagement.common.IndexException;
import org.gcube.indexmanagement.common.IndexField;
import org.gcube.indexmanagement.lucenewrapper.LuceneGcqlQueryContainer;
import org.gcube.indexmanagement.resourceregistry.RRadaptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullTextNode
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(FullTextNode.class);
    private static int DEFAULT_NUM_OF_REPLICAS = 0;
    private static int DEFAULT_NUM_OF_SHARDS = 1;
    private static int MAX_FRAGMENT_CNT = 5;
    private static int MAX_FRAGMENT_SIZE = 150;
    private static String DEFAULT_DATADIR = ".";
    private static final long RSTIMEOUT = 5L;
    private static String ALL_INDEXES = "allIndexes";
    public static String META_INDEX = "meta-index";
    public static String TEMP_PREFIX = "temp";
    public static String INDEX_PREFIX = "idx";
    public static String ACTIVE_INDEX = "active_index";
    public static String DEFAULT_INDEXNAME = "default_index";
    public static String DEFAULT_ANALYZER = "simple";
    public static String KEYWORD_ANALYZER = "keyword";
    private Client indexClient;
    private Node indexNode;
    private Set<String> indexTypes = new HashSet<String>();
    private FTNodeCache cache;
    private String clusterName;
    private String defaultIndexName;
    private Integer noOfReplicas;
    private Integer noOfShards;
    private Integer maxResults;
    private String scope;
    private int maxFragmentCnt;
    private int maxFragmentSize;
    private String dataDir = DEFAULT_DATADIR;
    private RRadaptor rradaptor;
    private String hostname;
    private HashMap<String, FullTextIndexType> colForField = new HashMap();
    private List<String> highlightedFields = new ArrayList<String>();

    public FullTextNode(String hostname) throws ResourceRegistryException, InterruptedException {
        this(hostname, true);
        logger.info("Initializing FullTextNode");
        this.cache = new FTNodeCache();
        this.initialize(true);
    }

    public FullTextNode(String hostname, Boolean useRRAdaptor) throws ResourceRegistryException, InterruptedException {
        logger.info("Initializing FullTextNode");
        this.cache = new FTNodeCache();
        this.hostname = hostname;
        this.initialize(useRRAdaptor);
    }

    public FullTextNode(String hostname, String clusterName, String indexName, Integer noOfReplicas, Integer noOfShards, String scope, int maxFragmentCnt, int maxFragmentSize, Boolean useRRAdaptor) throws ResourceRegistryException, InterruptedException {
        this(hostname, useRRAdaptor);
        this.clusterName = clusterName;
        this.defaultIndexName = indexName;
        this.noOfReplicas = noOfReplicas;
        this.noOfShards = noOfShards;
        this.scope = scope;
        this.maxFragmentCnt = maxFragmentCnt;
        this.maxFragmentSize = maxFragmentSize;
    }

    public FullTextNode(String hostname, String clusterName, String indexName, Integer noOfReplicas, Integer noOfShards, String scope, int maxFragmentCnt, int maxFragmentSize) throws ResourceRegistryException, InterruptedException {
        this(hostname);
        this.clusterName = clusterName;
        this.defaultIndexName = indexName;
        this.noOfReplicas = noOfReplicas;
        this.noOfShards = noOfShards;
        this.scope = scope;
        this.maxFragmentCnt = maxFragmentCnt;
        this.maxFragmentSize = maxFragmentSize;
    }

    public FullTextNode(String hostname, String clusterName, String indexName, String scope, Boolean useRRAdaptor) throws ResourceRegistryException, InterruptedException {
        this(hostname, useRRAdaptor);
        this.clusterName = clusterName;
        this.defaultIndexName = indexName;
        this.noOfReplicas = DEFAULT_NUM_OF_REPLICAS;
        this.noOfShards = DEFAULT_NUM_OF_SHARDS;
        this.scope = scope;
        this.maxFragmentCnt = MAX_FRAGMENT_CNT;
        this.maxFragmentSize = MAX_FRAGMENT_SIZE;
    }

    public FullTextNode(String hostname, String clusterName, String indexName, String scope) throws ResourceRegistryException, InterruptedException {
        this(hostname);
        this.clusterName = clusterName;
        this.defaultIndexName = indexName;
        this.noOfReplicas = DEFAULT_NUM_OF_REPLICAS;
        this.noOfShards = DEFAULT_NUM_OF_SHARDS;
        this.scope = scope;
        this.maxFragmentCnt = MAX_FRAGMENT_CNT;
        this.maxFragmentSize = MAX_FRAGMENT_SIZE;
    }

    public FullTextNode(String hostname, String dataDir, String clusterName, String indexName, Integer noOfReplicas, Integer noOfShards, String scope, int maxFragmentCnt, int maxFragmentSize, Boolean useRRAdaptor) throws ResourceRegistryException, InterruptedException {
        this(hostname, clusterName, indexName, noOfReplicas, noOfShards, scope, maxFragmentCnt, maxFragmentSize, useRRAdaptor);
        this.dataDir = dataDir;
    }

    public FullTextNode(String hostname, String dataDir, String clusterName, String indexName, Integer noOfReplicas, Integer noOfShards, String scope, int maxFragmentCnt, int maxFragmentSize) throws ResourceRegistryException, InterruptedException {
        this(hostname, clusterName, indexName, noOfReplicas, noOfShards, scope, maxFragmentCnt, maxFragmentSize);
        this.dataDir = dataDir;
    }

    public FullTextNode(String hostname, String dataDir, String clusterName, String indexName, String scope, Boolean useRRAdaptor) throws ResourceRegistryException, InterruptedException {
        this(hostname, clusterName, indexName, scope, useRRAdaptor);
        this.dataDir = dataDir;
    }

    public FullTextNode(String hostname, String dataDir, String clusterName, String indexName, String scope) throws ResourceRegistryException, InterruptedException {
        this(hostname, clusterName, indexName, scope);
        this.dataDir = dataDir;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public String getIndexName() {
        return this.defaultIndexName;
    }

    public Integer getNoOfReplicas() {
        return this.noOfReplicas;
    }

    public Integer getNoOfShards() {
        return this.noOfShards;
    }

    public String getScope() {
        return this.scope;
    }

    public int getMaxFragmentCnt() {
        return this.maxFragmentCnt;
    }

    public int getMaxFragmentSize() {
        return this.maxFragmentSize;
    }

    public Client getIndexClient() {
        return this.indexClient;
    }

    public List<String> getHighlightedFields() {
        return this.highlightedFields;
    }

    public void setHighlightedFields(List<String> highlightedFields) {
        this.highlightedFields = highlightedFields;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("FullTextNode [indexNode=").append(this.indexNode).append(", cache=").append(this.cache).append(", clusterName=").append(this.clusterName).append(", indexName=").append(this.defaultIndexName).append(", noOfReplicas=").append(this.noOfReplicas).append(", noOfShards=").append(this.noOfShards).append(", scope=").append(this.scope).append(", maxFragmentCnt=").append(this.maxFragmentCnt).append(", maxFragmentSize=").append(this.maxFragmentSize).append("]");
        return builder.toString();
    }

    public synchronized void addIndexType(String indexTypeStr, String indexName) throws Exception {
        FullTextIndexType indexType = QueryParser.retrieveIndexType(indexTypeStr, this.scope, this.cache);
        this.addIndexType(indexTypeStr, indexType, indexName);
    }

    public synchronized void addIndexType(String indexTypeStr, FullTextIndexType indexType, String indexName) throws Exception {
        logger.info("Calling addIndexType");
        if (indexType == null) {
            logger.warn("IndexType is null");
            throw new Exception("Trying to null as IndexType. Check how you got it");
        }
        indexType = QueryParser.addFullTextIndexTypeIntoCache(indexTypeStr, this.scope, indexType, this.cache);
        if (this.indexTypes.contains(indexName + "-" + indexTypeStr)) {
            logger.info("IndexType has already been added.");
            return;
        }
        IndicesAdminClient iac = this.indexClient.admin().indices();
        logger.info("Checking if index exists");
        if (((IndicesExistsResponse)iac.prepareExists(new String[]{indexName}).execute().actionGet()).isExists()) {
            logger.info("Index already exists");
        } else {
            CreateIndexResponse cir = (CreateIndexResponse)iac.prepareCreate(indexName).execute().actionGet();
            logger.info("Create Index Response : " + cir);
        }
        logger.trace("Index Type");
        logger.trace("-----------------------------------------------");
        logger.trace(indexType.toString());
        logger.trace("-----------------------------------------------");
        HashMap mapping = new HashMap();
        ArrayList<String> presentables = new ArrayList<String>();
        ArrayList<String> searchables = new ArrayList<String>();
        for (IndexField idxTypeField : indexType.getFields()) {
            String store;
            String string = store = idxTypeField.store ? "yes" : "no";
            String index = idxTypeField.index ? (idxTypeField.tokenize ? "analyzed" : "not_analyzed") : "no";
            if (idxTypeField.name.equalsIgnoreCase("gDocCollectionID") || idxTypeField.name.equalsIgnoreCase("ObjectID")) {
                index = "analyzed";
            }
            HashMap<String, Object> fieldMap = new HashMap<String, Object>();
            fieldMap.put("type", "string");
            fieldMap.put("store", store);
            fieldMap.put("index", index);
            fieldMap.put("boost", Float.valueOf(idxTypeField.boost));
            if (idxTypeField.name.equalsIgnoreCase("gDocCollectionID") || idxTypeField.name.equalsIgnoreCase("ObjectID")) {
                fieldMap.put("analyzer", KEYWORD_ANALYZER);
            } else {
                fieldMap.put("analyzer", DEFAULT_ANALYZER);
            }
            mapping.put(idxTypeField.name, fieldMap);
            if (idxTypeField.returned) {
                presentables.add(idxTypeField.name);
            }
            if (!idxTypeField.index) continue;
            searchables.add(idxTypeField.name);
        }
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        fieldMap.put("type", "string");
        fieldMap.put("store", "yes");
        fieldMap.put("index", "analyzed");
        fieldMap.put("analyzer", KEYWORD_ANALYZER);
        mapping.put("ObjectID", fieldMap);
        fieldMap = new HashMap();
        fieldMap.put("type", "string");
        fieldMap.put("store", "yes");
        fieldMap.put("index", "analyzed");
        fieldMap.put("analyzer", KEYWORD_ANALYZER);
        mapping.put("sid", fieldMap);
        this.cache.presentableFieldsPerIndexType.put(indexTypeStr, presentables);
        this.cache.searchableFieldsPerIndexType.put(indexTypeStr, searchables);
        logger.info("1. in addIndexType cache : " + this.cache.presentableFieldsPerIndexType);
        logger.info("1. in addIndexType cache : " + this.cache.searchableFieldsPerIndexType);
        HashMap propertyMap = new HashMap();
        propertyMap.put("properties", mapping);
        HashMap mappingMap = new HashMap();
        mappingMap.put(indexTypeStr, propertyMap);
        String json = ElasticSearchHelper.createJSONObject(mappingMap).string();
        logger.info("json : " + json);
        PutMappingResponse pmr = (PutMappingResponse)iac.preparePutMapping(new String[0]).setIndices(new String[]{indexName}).setType(indexTypeStr).setSource(json).execute().actionGet();
        logger.info("Update Settings Response : " + pmr.toString());
        this.indexTypes.add(indexTypeStr + "-" + indexName);
        logger.info("2. in addIndexType cache : " + this.cache.presentableFieldsPerIndexType);
        logger.info("2. in addIndexType cache : " + this.cache.searchableFieldsPerIndexType);
    }

    public void createOrJoinCluster() {
        logger.info("creating or joining cluster");
        logger.info("cluster.name : " + this.clusterName);
        logger.info("index.number_of_replicas : " + this.noOfReplicas);
        logger.info("index.number_of_shards : " + this.noOfShards);
        logger.info("path.data : " + this.dataDir);
        Settings settings = ImmutableSettings.settingsBuilder().put("cluster.name", this.clusterName).put("index.number_of_replicas", String.valueOf(this.noOfReplicas)).put("index.number_of_shards", String.valueOf(this.noOfShards)).put("index.refresh_interval", String.valueOf(-1)).put("path.data", this.dataDir).build();
        this.indexNode = NodeBuilder.nodeBuilder().settings(settings).node();
        this.indexClient = this.indexNode.client();
    }

    public void joinCluster(Map<String, Integer> knownNodes) throws IOException {
        logger.info("joining cluster of known node : " + knownNodes);
        logger.info("cluster.name : " + this.clusterName);
        logger.info("index.number_of_replicas : " + this.noOfReplicas);
        logger.info("index.number_of_shards : " + this.noOfShards);
        logger.info("path.data : " + this.dataDir);
        String hosts = ElasticSearchHelper.createKnownHostsString(knownNodes);
        logger.info("hosts string : " + hosts);
        Settings settings = ImmutableSettings.settingsBuilder().put("cluster.name", this.clusterName).put("index.number_of_replicas", String.valueOf(this.noOfReplicas)).put("index.number_of_shards", String.valueOf(this.noOfShards)).put("discovery.zen.ping.multicast.ping.enabled", false).put("path.data", this.dataDir).put("discovery.zen.ping.multicast.enabled", false).put("discovery.zen.ping.unicast.enabled", true).put("discovery.zen.ping.unicast.hosts", hosts).build();
        this.indexNode = NodeBuilder.nodeBuilder().settings(settings).node();
        this.indexClient = this.indexNode.client();
    }

    public String query(String queryString, Set<String> securityIdentifiers) throws IndexException, GRS2WriterException {
        return this.query(queryString, -1, 0, securityIdentifiers);
    }

    public String query(String queryString, int maxHits, int from, Set<String> securityIdentifiers) throws GRS2WriterException, IndexException {
        logger.info("queryString received : " + queryString);
        logger.info("maxHits              : " + maxHits);
        final long starttime = System.currentTimeMillis();
        long starttime_part = System.currentTimeMillis();
        List<String> collIDs = QueryParser.getCollectionsIDFromQuery(queryString);
        logger.info("collectionID of query : " + collIDs);
        Set<String> indexTypes = QueryParser.getIndexTypesByCollectionIDs(this.cache.indexTypesByCollIDs, collIDs, this.indexClient, ACTIVE_INDEX);
        logger.info("indexTypes for collectionIDs : " + indexTypes);
        logger.info("cache : " + this.cache);
        logger.info("cache indextypes by coll id    : " + this.cache.indexTypesByCollIDs);
        logger.info("cache presentables by idx type : " + this.cache.presentableFieldsPerIndexType);
        logger.info("cache searchables  by idx type : " + this.cache.searchableFieldsPerIndexType);
        final List<String> presentables = QueryParser.createPresentableForIndexTypes(this.cache.presentableFieldsPerIndexType, indexTypes);
        logger.info("presentables for index types : " + presentables);
        List<String> searchables = QueryParser.createSearchablesForIndexTypes(this.cache.searchableFieldsPerIndexType, indexTypes);
        logger.info("searchables for index types : " + searchables);
        logger.info("queryString before convert : " + queryString);
        LuceneGcqlQueryContainer queryContainer = QueryParser.convertToLuceneQuery(queryString, presentables, searchables, this.rradaptor);
        String queryPart = QueryParser.getLuceneQueryFromQueryString(queryContainer);
        logger.info("query part of queryString : " + queryPart);
        String query = QueryParser.rewriteQueryWithSids(queryPart, securityIdentifiers);
        logger.info("query after rewrite with sids : " + query);
        final List<String> projections = QueryParser.getProjectionsQueryFromQueryString(queryContainer);
        logger.info("projections of queryString : " + projections);
        logger.info("queryString after convert : " + query + " project " + projections);
        ArrayList<String> highlightFields = null;
        ArrayList<String> presentablesTmp = null;
        if (this.highlightedFields != null) {
            presentablesTmp = new ArrayList<String>(presentables);
            presentablesTmp.retainAll(this.highlightedFields);
        }
        if (this.highlightedFields == null || this.highlightedFields.size() == 0 || presentablesTmp != null && presentablesTmp.size() == 0) {
            logger.info("no highlighted fields were set. will use the presentables : " + presentables);
            highlightFields = new ArrayList<String>();
            highlightFields.add("*");
        } else {
            logger.info("highlighted fields were set. will use them : " + this.highlightedFields);
            highlightFields = presentablesTmp;
            logger.info("highlighted fields after filtering with presentables : " + highlightFields);
        }
        List<String> projectedFields = new ArrayList<String>(projections);
        if (projectedFields.contains("*")) {
            projectedFields = presentables;
        }
        if (projectedFields.contains("S")) {
            projectedFields.remove("S");
        }
        long endtime_part = System.currentTimeMillis();
        logger.info("parsing time : " + (double)(endtime_part - starttime_part) / 1000.0 + " secs");
        starttime_part = System.currentTimeMillis();
        if (maxHits < 0 && this.maxResults != null) {
            logger.trace("max results for query not given. will use global maxResults : " + this.maxResults);
            maxHits = this.maxResults;
        } else if (maxHits > 0 && this.maxResults != null) {
            logger.trace("max results for query given." + maxHits + " global maxResults : " + this.maxResults);
            if (maxHits > this.maxResults) {
                maxHits = this.maxResults;
            }
        }
        final SearchHit[] hits = projections.contains("S") ? ElasticSearchHelper.queryElasticSearch(this.indexClient, ACTIVE_INDEX, query, maxHits, highlightFields, projectedFields, this.maxFragmentSize, this.maxFragmentCnt, from) : ElasticSearchHelper.queryElasticSearch(this.indexClient, ACTIVE_INDEX, query, maxHits, from, projectedFields);
        endtime_part = System.currentTimeMillis();
        logger.info("elasticsearch query time : " + (double)(endtime_part - starttime_part) / 1000.0 + " secs");
        logger.info("Number of hits returned by index : " + hits.length);
        final RecordWriter<GenericRecord> rsWriter = QueryParser.initRSWriterForSearchHits(presentables, projections, this.rradaptor);
        logger.info("emitting key value event with key : resultsNumberFinal and value : " + hits.length);
        rsWriter.emit((BufferEvent)new KeyValueEvent("resultsNumberFinal", String.valueOf(hits.length)));
        final int maxFragmentCnt = this.maxFragmentCnt;
        Runnable writerRun = new Runnable(){

            @Override
            public void run() {
                try {
                    for (SearchHit hit : hits) {
                        if (!QueryParser.writeSearchHitFieldsInResultSet(hit, (RecordWriter<GenericRecord>)rsWriter, projections, presentables, maxFragmentCnt, 5L)) break;
                    }
                    if (rsWriter.getStatus() != IBuffer.Status.Dispose) {
                        rsWriter.close();
                    }
                }
                catch (Exception e) {
                    logger.error("Error during search.", (Throwable)e);
                    try {
                        if (rsWriter.getStatus() != IBuffer.Status.Dispose) {
                            rsWriter.close();
                        }
                    }
                    catch (Exception ex) {
                        logger.error("Error while closing RS writer.", (Throwable)ex);
                    }
                }
                logger.info("total query time : " + (double)(System.currentTimeMillis() - starttime) / 1000.0 + " secs");
            }
        };
        new Thread(writerRun).start();
        logger.info("results locator : " + rsWriter.getLocator());
        return rsWriter.getLocator().toString();
    }

    public String queryStream(String queryString) throws IndexException, GRS2WriterException {
        return this.queryStream(queryString, -1);
    }

    public String queryStream(String queryString, final int maxHits) throws IndexException, GRS2WriterException {
        logger.info("queryString received : " + queryString);
        List<String> collIDs = QueryParser.getCollectionsIDFromQuery(queryString);
        logger.info("collectionID of query : " + collIDs);
        Set<String> indexTypes = QueryParser.getIndexTypesByCollectionIDs(this.cache.indexTypesByCollIDs, collIDs, this.indexClient, ACTIVE_INDEX);
        logger.info("indexTypes for collectionIDs : " + indexTypes);
        final List<String> presentables = QueryParser.createPresentableForIndexTypes(this.cache.presentableFieldsPerIndexType, indexTypes);
        logger.info("presentables for index types : " + presentables);
        List<String> searchables = QueryParser.createSearchablesForIndexTypes(this.cache.searchableFieldsPerIndexType, indexTypes);
        logger.info("searchables for index types : " + searchables);
        logger.info("queryString before convert : " + queryString);
        LuceneGcqlQueryContainer queryContainer = QueryParser.convertToLuceneQuery(queryString, presentables, searchables, this.rradaptor);
        final String query = QueryParser.getLuceneQueryFromQueryString(queryContainer);
        logger.info("query part of queryString : " + query);
        final List<String> projections = QueryParser.getProjectionsQueryFromQueryString(queryContainer);
        logger.info("projections of queryString : " + projections);
        logger.info("queryString after convert : " + query + " project " + projections);
        long numberOfHits = ElasticSearchHelper.queryCountElasticSearch(this.indexClient, ACTIVE_INDEX, query);
        if (maxHits > 0 && numberOfHits > (long)maxHits) {
            numberOfHits = maxHits;
        }
        logger.info("Number of hits returned by index : " + numberOfHits);
        final RecordWriter<GenericRecord> rsWriter = QueryParser.initRSWriterForSearchHits(presentables, projections, this.rradaptor);
        logger.info("emitting key value event with key : resultsNumberFinal and value : " + numberOfHits);
        rsWriter.emit((BufferEvent)new KeyValueEvent("resultsNumberFinal", String.valueOf(numberOfHits)));
        final Client client = this.indexClient;
        final int maxFragmentSize = this.maxFragmentSize;
        final int maxFragmentCnt = this.maxFragmentCnt;
        List<String> highlightFields = null;
        if (this.highlightedFields == null || this.highlightedFields.size() == 0) {
            logger.info("no highlighted fields were set. will use the presentables : " + presentables);
            highlightFields = presentables;
        } else {
            logger.info("highlighted fields were set. will use them : " + this.highlightedFields);
            highlightFields = new ArrayList<String>();
            for (String field : this.highlightedFields) {
                if (!presentables.contains(field)) continue;
                highlightFields.add(field);
            }
            logger.info("highlighted fields after filtering with presentables : " + highlightFields);
        }
        List<String> projectedFields = new ArrayList<String>(projections);
        if (projectedFields.contains("*")) {
            projectedFields = presentables;
        }
        if (projectedFields.contains("S")) {
            projectedFields.remove("S");
        }
        final List<String> highlightFieldsList = highlightFields;
        final List<String> projectedFieldsList = projectedFields;
        Runnable writerRun = new Runnable(){

            @Override
            public void run() {
                try {
                    SearchResponse scrollResp = projections.contains("S") ? ElasticSearchHelper.queryElasticSearchScroll(client, ACTIVE_INDEX, query, maxHits, highlightFieldsList, projectedFieldsList, maxFragmentSize, maxFragmentCnt) : ElasticSearchHelper.queryElasticSearchScroll(client, ACTIVE_INDEX, query, maxHits, projectedFieldsList);
                    int hits = 0;
                    do {
                        SearchHit hit;
                        scrollResp = ElasticSearchHelper.getNextSearchResponse(client, scrollResp);
                        logger.info("hits from scroll : " + scrollResp.getHits().getHits().length);
                        Iterator i$ = scrollResp.getHits().iterator();
                        while (i$.hasNext() && QueryParser.writeSearchHitFieldsInResultSet(hit = (SearchHit)i$.next(), (RecordWriter<GenericRecord>)rsWriter, projections, presentables, maxFragmentCnt, 5L)) {
                        }
                        if (rsWriter.getStatus() == IBuffer.Status.Dispose) continue;
                        rsWriter.close();
                    } while (scrollResp.getHits().getHits().length != 0 && ++hits <= maxHits);
                }
                catch (Exception e) {
                    logger.error("Error during search.", (Throwable)e);
                    try {
                        if (rsWriter.getStatus() != IBuffer.Status.Dispose) {
                            rsWriter.close();
                        }
                    }
                    catch (Exception ex) {
                        logger.error("Error while closing RS writer.", (Throwable)ex);
                    }
                }
            }
        };
        new Thread(writerRun).start();
        logger.info("results locator : " + rsWriter.getLocator());
        return rsWriter.getLocator().toString();
    }

    public boolean activateIndex(String indexName) {
        String idxName = null;
        idxName = indexName != null ? indexName : this.defaultIndexName;
        IndicesAliasesResponse iar = (IndicesAliasesResponse)this.indexClient.admin().indices().prepareAliases().addAlias(idxName, ACTIVE_INDEX).execute().actionGet();
        logger.info("Alias for  : " + idxName + " does not exist. Creating now");
        if (!iar.isAcknowledged()) {
            logger.warn("Alias for  : " + idxName + " creation failed");
            return false;
        }
        logger.info("Alias for  : " + idxName + " created");
        return true;
    }

    public boolean deactivateIndex(String indexName) {
        IndicesAliasesResponse iar = (IndicesAliasesResponse)this.indexClient.admin().indices().prepareAliases().removeAlias(indexName, ACTIVE_INDEX).execute().actionGet();
        if (!iar.isAcknowledged()) {
            logger.warn("Couldn't remove : " + indexName + " from alias");
            return false;
        }
        logger.info(indexName + " removed from alias");
        return true;
    }

    public boolean delete() {
        boolean indexRet = ElasticSearchHelper.delete(this.indexClient, ACTIVE_INDEX);
        boolean metaRet = ElasticSearchHelper.delete(this.indexClient, META_INDEX);
        return indexRet && metaRet;
    }

    public Set<String> getCollectionsOfIndex(String indexName) {
        Set<String> collectionsOfIndex = ElasticSearchHelper.getAllCollectionsOfIndex(this.indexClient, indexName);
        logger.info("collectionsOfIndex : " + indexName + " count : " + collectionsOfIndex);
        return collectionsOfIndex;
    }

    public Long getCollectionDocuments(String collectionID) {
        Long count = ElasticSearchHelper.collectionDocumentsCountElasticSearch(this.indexClient, ACTIVE_INDEX, collectionID);
        logger.info("collection : " + collectionID + " count : " + count);
        return count;
    }

    public Set<String> getIndicesOfCollection(String collection) {
        Set<String> indicesOfCollection = ElasticSearchHelper.indicesOfCollection(this.indexClient, ACTIVE_INDEX, collection);
        logger.info("indicesOfCollection : " + collection + " count : " + indicesOfCollection);
        return indicesOfCollection;
    }

    public boolean deleteIndex(String indexName) {
        this.deactivateIndex(indexName);
        Set<String> collectionsOfIndex = ElasticSearchHelper.getAllCollectionsOfIndex(this.indexClient, indexName);
        boolean indexRet = ElasticSearchHelper.delete(this.indexClient, indexName);
        boolean doDelete = false;
        IndicesAdminClient iac = this.indexClient.admin().indices();
        logger.info("Checking if alias exists");
        if (!((IndicesExistsResponse)iac.prepareExists(new String[]{ACTIVE_INDEX}).execute().actionGet()).isExists()) {
            logger.info("alias does not exist");
        } else {
            logger.info("alias exists");
        }
        if (indexRet) {
            if (doDelete) {
                for (String collID : collectionsOfIndex) {
                    if (!ElasticSearchHelper.collectionExists(this.indexClient, ACTIVE_INDEX, collID).booleanValue()) {
                        logger.info("collection : " + collID + " does not exist in the rest indices");
                        this.updateManagerPropertiesRemoveCollID(collID);
                        continue;
                    }
                    logger.info("collection : " + collID + " exists in the rest indices");
                }
            }
            this.commitMeta();
        }
        return indexRet;
    }

    public void deleteDocuments(List<String> docIDs) {
        ElasticSearchHelper.deleteDocuments(this.indexClient, ACTIVE_INDEX, docIDs);
    }

    public Boolean deleteCollection(String collID) {
        Boolean result = ElasticSearchHelper.deleteCollection(this.indexClient, ACTIVE_INDEX, collID);
        if (result.booleanValue()) {
            this.updateManagerPropertiesRemoveCollID(collID);
            this.commitMeta();
        }
        return result;
    }

    public void commitMeta() {
        ElasticSearchHelper.commit(this.indexClient, META_INDEX);
    }

    public void commit() {
        ElasticSearchHelper.commit(this.indexClient, ACTIVE_INDEX);
    }

    public void commit(String indexName) {
        ElasticSearchHelper.commit(this.indexClient, indexName);
    }

    public void clearIndex(String indexTypeName) {
        ElasticSearchHelper.clearIndex(this.indexClient, ACTIVE_INDEX, indexTypeName);
    }

    public void close() {
        this.indexClient.close();
        this.indexNode.close();
    }

    private void initialize(Boolean useRRAdaptor) throws ResourceRegistryException, InterruptedException {
        this.initialize();
        if (useRRAdaptor.booleanValue()) {
            logger.info("Initializing ResourceRegistry");
            try {
                ResourceRegistry.startBridging();
                TimeUnit.SECONDS.sleep(1L);
                while (!ResourceRegistry.isInitialBridgingComplete()) {
                    TimeUnit.SECONDS.sleep(10L);
                }
            }
            catch (ResourceRegistryException e) {
                logger.error("Resource Registry could not be initialized", (Throwable)e);
                throw e;
            }
            catch (InterruptedException e) {
                logger.error("Resource Registry could not be initialized", (Throwable)e);
                throw e;
            }
            this.rradaptor = new RRadaptor();
            logger.info("Initializing ResourceRegistry is DONE");
        } else {
            logger.info("ResourceRegistry will NOT be initialized as configured");
        }
    }

    private void initialize() {
        TCPConnectionManager.Init((ConnectionManagerConfig)new ConnectionManagerConfig(this.hostname, new ArrayList(), true));
        TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new TCPConnectionHandler());
        TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new TCPStoreConnectionHandler());
    }

    public boolean feedRowset(String rowset, String indexName, Set<String> securityIdentifiers) {
        HashMap<String, FullTextIndexType> colForIdTypes;
        BulkRequestBuilder bulkRequest = this.indexClient.prepareBulk();
        boolean status = this.feedRowset(bulkRequest, rowset, colForIdTypes = new HashMap<String, FullTextIndexType>(), indexName, securityIdentifiers);
        if (status) {
            long before = System.currentTimeMillis();
            BulkResponse bulkResponse = (BulkResponse)bulkRequest.setConsistencyLevel(WriteConsistencyLevel.ONE).execute().actionGet();
            long after = System.currentTimeMillis();
            logger.info("Time for commiting the bulk requests : " + (double)(after - before) / 1000.0 + " secs");
            logger.info("bulkResponse : " + (double)bulkResponse.getTookInMillis() / 1000.0 + " secs");
            logger.info("bulkResponse : " + bulkResponse);
            if (bulkResponse.hasFailures()) {
                logger.info("failures have happened");
            }
            this.commit(indexName);
        } else {
            logger.info("feedRowset failed");
        }
        return status;
    }

    public boolean feedLocator(String resultSetLocation, String indexName, Set<String> securityIdentifiers) throws GRS2ReaderException, URISyntaxException, GRS2RecordDefinitionException, GRS2BufferException {
        return this.feedLocator(resultSetLocation, this.colForField, indexName, securityIdentifiers);
    }

    public boolean feedLocator(String resultSetLocation, Set<String> securityIdentifiers) throws GRS2ReaderException, URISyntaxException, GRS2RecordDefinitionException, GRS2BufferException {
        return this.feedLocator(resultSetLocation, this.colForField, this.defaultIndexName, securityIdentifiers);
    }

    public boolean feedLocator(String resultSetLocation, HashMap<String, FullTextIndexType> colForField, Set<String> securityIdentifiers) throws GRS2ReaderException, URISyntaxException, GRS2RecordDefinitionException, GRS2BufferException {
        return this.feedLocator(resultSetLocation, colForField, this.defaultIndexName, securityIdentifiers);
    }

    public boolean feedLocator(String resultSetLocation, HashMap<String, FullTextIndexType> colForField, String indexName, Set<String> securityIdentifiers) throws GRS2ReaderException, URISyntaxException, GRS2RecordDefinitionException, GRS2BufferException {
        long after;
        logger.info("Initializing reader at resultset : " + resultSetLocation);
        ForwardReader reader = new ForwardReader(new URI(resultSetLocation));
        reader.setIteratorTimeout(5L);
        reader.setIteratorTimeUnit(TimeUnit.MINUTES);
        int rowSetCount = 0;
        boolean success = true;
        long beforeFeed = System.currentTimeMillis();
        BulkRequestBuilder bulkRequest = this.indexClient.prepareBulk();
        try {
            logger.info("Initializing resultset reader iterator");
            Iterator it = reader.iterator();
            while (it.hasNext()) {
                logger.trace("Getting result : " + rowSetCount);
                long before = System.currentTimeMillis();
                Record result = (Record)it.next();
                after = System.currentTimeMillis();
                logger.trace("Time for getting record from Result Set : " + (double)(after - before) / 1000.0 + " secs");
                before = System.currentTimeMillis();
                String rowset = RowsetParser.getRowsetFromResult(result);
                after = System.currentTimeMillis();
                logger.trace("Time for getting rowset from record : " + (double)(after - before) / 1000.0 + " secs");
                success = this.feedRowset(bulkRequest, rowset, colForField, indexName, securityIdentifiers);
                if (!success) {
                    logger.warn("feed rowset failed");
                    break;
                }
                logger.info("Result " + rowSetCount + " inserted");
                ++rowSetCount;
            }
        }
        catch (Exception e) {
            logger.info("Exception will feeding", (Throwable)e);
        }
        reader.close();
        if (success) {
            long before = System.currentTimeMillis();
            BulkResponse bulkResponse = (BulkResponse)bulkRequest.setConsistencyLevel(WriteConsistencyLevel.ONE).execute().actionGet();
            after = System.currentTimeMillis();
            logger.info("Time for commiting the bulk requests : " + (double)(after - before) / 1000.0 + " secs");
            logger.info("bulkResponse : " + (double)bulkResponse.getTookInMillis() / 1000.0 + " secs");
            logger.info("bulkResponse : " + bulkResponse);
            if (bulkResponse.hasFailures()) {
                logger.warn("failures have happened. Message : " + bulkResponse.buildFailureMessage());
                logger.warn("Details ");
                for (BulkItemResponse brItem : bulkResponse.getItems()) {
                    logger.warn("id : " + brItem.getId() + " " + brItem.getIndex() + " " + brItem.getType() + ", Failure Message : " + brItem.getFailureMessage());
                }
                logger.warn("failures have happened. Message : " + bulkResponse.buildFailureMessage());
                logger.warn("Error. Feeding failed");
                return false;
            }
            this.commit(indexName);
            this.updateManagerProperties(colForField);
            this.commitMeta();
            logger.info("Total number of records feeded : " + rowSetCount);
            long afterFeed = System.currentTimeMillis();
            logger.info("Total insert time : " + (double)(afterFeed - beforeFeed) / 1000.0);
        } else {
            logger.warn("Error. Feeding failed");
        }
        return success;
    }

    private boolean feedRowset(BulkRequestBuilder bulkRequest, String rowset, HashMap<String, FullTextIndexType> colForIdTypes, String indexName, Set<String> securityIdentifiers) {
        long before = System.currentTimeMillis();
        String rsIdxTypeID = RowsetParser.getIdxTypeNameRowset(rowset);
        long after = System.currentTimeMillis();
        logger.trace("Time for getting rsIdxTypeID from rowset : " + (double)(after - before) / 1000.0 + " secs");
        logger.trace("Result IndexTypeID : " + rsIdxTypeID);
        before = System.currentTimeMillis();
        String lang = RowsetParser.getLangRowset(rowset);
        after = System.currentTimeMillis();
        logger.trace("Time for getting lang from rowset : " + (double)(after - before) / 1000.0 + " secs");
        logger.trace("Result lang : " + lang);
        if (lang == null || lang.equals("")) {
            lang = "unknown";
        }
        before = System.currentTimeMillis();
        String colID = RowsetParser.getColIDRowset(rowset);
        after = System.currentTimeMillis();
        logger.trace("Time for colID lang from rowset : " + (double)(after - before) / 1000.0 + " secs");
        logger.trace("Result colID : " + colID);
        if (colID == null || colID.equals("")) {
            logger.trace("No collection ID given in ROWSET: " + rowset);
            return false;
        }
        indexName = FullTextNode.createIndexName(indexName, colID, false);
        try {
            this.addIndexType(rsIdxTypeID, indexName);
        }
        catch (Exception e) {
            logger.error("Add index type exception", (Throwable)e);
            return false;
        }
        if (rsIdxTypeID == null || !this.indexTypes.contains(rsIdxTypeID + "-" + indexName)) {
            logger.error("IndexType : " + rsIdxTypeID + "-" + indexName + " not in indexTypes : " + this.indexTypes);
            return false;
        }
        before = System.currentTimeMillis();
        String alteredRowset = RowsetParser.preprocessRowset(rowset, lang, colID, indexName, rsIdxTypeID, this.scope, this.cache);
        after = System.currentTimeMillis();
        logger.trace("Time for preprocessRowset : " + (double)(after - before) / 1000.0 + " secs");
        if (alteredRowset == null) {
            logger.error("could not preprocess rowset: " + rowset);
            return false;
        }
        before = System.currentTimeMillis();
        FullTextIndexType idxType = this.cache.cachedIndexTypes.get(QueryParser.createIndexTypekey(rsIdxTypeID, this.scope));
        logger.trace("index type for name : " + idxType.getIndexTypeName());
        logger.trace("all indexTypes in cache : " + this.cache.cachedIndexTypes.keySet());
        ElasticSearchHelper.insertRowSet(bulkRequest, this.indexClient, indexName, idxType, this.indexTypes, alteredRowset, securityIdentifiers);
        after = System.currentTimeMillis();
        logger.trace("Time for insertRowSet : " + (double)(after - before) / 1000.0 + " secs");
        colForIdTypes.put(colID + ":" + lang, idxType);
        return true;
    }

    private static String createIndexName(String indexName, String collectionID, Boolean useCollectionID) {
        if (useCollectionID.booleanValue()) {
            return collectionID + "_" + indexName;
        }
        return indexName;
    }

    private synchronized void bindIndexType(String indexTypeStr, String indexName) {
        FullTextIndexType indexType = QueryParser.retrieveIndexType(indexTypeStr, this.scope, this.cache);
        logger.info("Index Type");
        logger.info("-----------------------------------------------");
        logger.info(indexType.toString());
        logger.info("-----------------------------------------------");
        ArrayList<String> presentables = new ArrayList<String>();
        ArrayList<String> searchables = new ArrayList<String>();
        for (IndexField idxTypeField : indexType.getFields()) {
            if (idxTypeField.returned) {
                presentables.add(idxTypeField.name);
            }
            if (!idxTypeField.index) continue;
            searchables.add(idxTypeField.name);
        }
        this.indexTypes.add(indexTypeStr + "-" + indexName);
        this.cache.presentableFieldsPerIndexType.put(indexTypeStr, presentables);
        this.cache.searchableFieldsPerIndexType.put(indexTypeStr, searchables);
    }

    public void refreshIndexTypesOfIndex() {
        ClusterStateResponse clusterResponse = (ClusterStateResponse)this.indexClient.admin().cluster().prepareState().execute().actionGet();
        logger.info("clusterResponse : " + clusterResponse);
        Map aliases = clusterResponse.getState().getMetaData().aliases();
        Map alias = (Map)aliases.get(ACTIVE_INDEX);
        if (alias != null && alias.size() > 0) {
            for (String indexName : alias.keySet()) {
                IndexMetaData indexMetaData = clusterResponse.getState().getMetaData().index(indexName);
                Map mappings = indexMetaData.mappings();
                logger.info("index types found in index : " + mappings.keySet());
                for (String indexType : mappings.keySet()) {
                    logger.info("adding index type : " + indexType);
                    try {
                        this.bindIndexType(indexType, indexName);
                        logger.info("adding index type : " + indexType + " succeded");
                    }
                    catch (Exception e) {
                        logger.info("adding index type : " + indexType + " failed");
                    }
                }
            }
        }
    }

    public boolean updateManagerProperties(HashMap<String, FullTextIndexType> colForIdTypes) {
        ArrayList fieldsToBeAdded;
        ArrayList collectionIdsToBeAdded;
        Map result = null;
        String id = null;
        long version = 0L;
        try {
            SearchResponse response = (SearchResponse)this.indexClient.prepareSearch(new String[]{META_INDEX}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).execute().actionGet();
            for (SearchHit hit : response.getHits().getHits()) {
                result = hit.getSource();
                id = hit.getId();
                version = hit.getVersion();
            }
        }
        catch (Exception e) {
            logger.warn("No meta-index yet", (Throwable)e);
        }
        if (result != null) {
            collectionIdsToBeAdded = (ArrayList)result.get("collectionIDs");
            fieldsToBeAdded = (ArrayList)result.get("fields");
        } else {
            collectionIdsToBeAdded = new ArrayList();
            fieldsToBeAdded = new ArrayList();
        }
        Set<String> keys = colForIdTypes.keySet();
        for (String colIDandLang : keys) {
            IndexField[] fields;
            FullTextIndexType index = colForIdTypes.get(colIDandLang);
            for (IndexField field : fields = index.getFields()) {
                if (RowsetParser.addToFieldInfo(fieldsToBeAdded, field.name, colIDandLang, index)) continue;
                return false;
            }
            fieldsToBeAdded.add(colIDandLang + ":" + "s" + ":" + ALL_INDEXES);
            collectionIdsToBeAdded.add(colIDandLang.split(":")[0]);
        }
        HashSet hs1 = new HashSet();
        HashSet hs2 = new HashSet();
        hs1.addAll(collectionIdsToBeAdded);
        hs2.addAll(fieldsToBeAdded);
        collectionIdsToBeAdded.clear();
        fieldsToBeAdded.clear();
        collectionIdsToBeAdded.addAll(hs1);
        fieldsToBeAdded.addAll(hs2);
        try {
            HashMap<String, String[]> document = new HashMap<String, String[]>();
            document.put("collectionIDs", collectionIdsToBeAdded.toArray(new String[collectionIdsToBeAdded.size()]));
            document.put("fields", fieldsToBeAdded.toArray(new String[fieldsToBeAdded.size()]));
            if (result != null) {
                ++version;
            }
            IndexResponse response = (IndexResponse)this.indexClient.prepareIndex(META_INDEX, META_INDEX, id).setSource(ElasticSearchHelper.createJSONObject(document).string()).setConsistencyLevel(WriteConsistencyLevel.ONE).setVersion(version).execute().actionGet();
            logger.info("Add records to meta-index response id : " + response.getId());
            logger.info("Inserted colIDs and fields to " + META_INDEX);
            logger.info("committing meta-index");
            this.commitMeta();
            logger.info("Added records to meta-index");
        }
        catch (ElasticSearchException e) {
            logger.error("Caught an exception: ", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("Caught an exception: ", (Throwable)e);
        }
        return true;
    }

    public boolean updateManagerPropertiesRemoveCollID(String collectionID) {
        ArrayList fieldsToBeAdded;
        ArrayList collectionIdsToBeAdded;
        Map result = null;
        String id = null;
        long version = 0L;
        try {
            SearchResponse response = (SearchResponse)this.indexClient.prepareSearch(new String[]{META_INDEX}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).execute().actionGet();
            for (SearchHit hit : response.getHits().getHits()) {
                result = hit.getSource();
                id = hit.getId();
                version = hit.getVersion();
            }
        }
        catch (Exception e) {
            logger.warn("No meta-index yet", (Throwable)e);
        }
        if (result != null) {
            collectionIdsToBeAdded = (ArrayList)result.get("collectionIDs");
            fieldsToBeAdded = (ArrayList)result.get("fields");
        } else {
            collectionIdsToBeAdded = new ArrayList();
            fieldsToBeAdded = new ArrayList();
        }
        if (collectionIdsToBeAdded.contains(collectionID)) {
            collectionIdsToBeAdded.remove(collectionID);
        }
        ArrayList<String> fieldsTobeRemoved = new ArrayList<String>();
        for (String field : fieldsToBeAdded) {
            if (!field.startsWith(collectionID + ":")) continue;
            fieldsTobeRemoved.add(field);
        }
        fieldsToBeAdded.removeAll(fieldsTobeRemoved);
        HashSet hs1 = new HashSet();
        HashSet hs2 = new HashSet();
        hs1.addAll(collectionIdsToBeAdded);
        hs2.addAll(fieldsToBeAdded);
        collectionIdsToBeAdded.clear();
        fieldsToBeAdded.clear();
        collectionIdsToBeAdded.addAll(hs1);
        fieldsToBeAdded.addAll(hs2);
        try {
            HashMap<String, String[]> document = new HashMap<String, String[]>();
            document.put("collectionIDs", collectionIdsToBeAdded.toArray(new String[collectionIdsToBeAdded.size()]));
            document.put("fields", fieldsToBeAdded.toArray(new String[fieldsToBeAdded.size()]));
            if (result != null) {
                ++version;
            }
            IndexResponse response = (IndexResponse)this.indexClient.prepareIndex(META_INDEX, META_INDEX, id).setSource(ElasticSearchHelper.createJSONObject(document).string()).setConsistencyLevel(WriteConsistencyLevel.ONE).setVersion(version).execute().actionGet();
            logger.info("Add records to meta-index response id : " + response.getId());
            logger.info("Inserted colIDs and fields to " + META_INDEX);
            logger.info("committing meta-index");
            this.commitMeta();
            logger.info("Added records to meta-index");
        }
        catch (ElasticSearchException e) {
            logger.error("Caught an exception: ", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("Caught an exception: ", (Throwable)e);
        }
        return true;
    }

    public boolean addMetaIndex() {
        int counter = 0;
        Map result = null;
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            logger.error("Failed to sleep", (Throwable)e);
        }
        while (true) {
            try {
                SearchResponse response = (SearchResponse)this.indexClient.prepareSearch(new String[]{META_INDEX}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).execute().actionGet();
                for (SearchHit hit : response.getHits().getHits()) {
                    result = hit.getSource();
                }
            }
            catch (IndexMissingException e) {
                logger.warn("Index missing, proceeding to creation");
            }
            catch (Exception e) {
                logger.warn("Not initialized yet, retrying");
                ++counter;
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e1) {
                    logger.error("Failed to sleep", (Throwable)e);
                }
                if (counter != 10) continue;
                return false;
            }
            break;
        }
        if (result == null) {
            try {
                HashMap<String, String[]> document = new HashMap<String, String[]>();
                document.put("collectionIDs", new String[0]);
                document.put("fields", new String[0]);
                IndicesAdminClient iac = this.indexClient.admin().indices();
                logger.info("creating meta-index response");
                CreateIndexResponse cir = (CreateIndexResponse)iac.prepareCreate(META_INDEX).execute().actionGet();
                logger.info("created meta-index response : " + cir.toString());
                IndexResponse response = (IndexResponse)this.indexClient.prepareIndex(META_INDEX, META_INDEX).setSource(ElasticSearchHelper.createJSONObject(document).string()).setConsistencyLevel(WriteConsistencyLevel.ONE).execute().actionGet();
                logger.info("Add empty records to meta-index response id : " + response.getId());
                logger.info("committing meta-index");
                this.commitMeta();
                logger.info("Added empty meta-index");
            }
            catch (IOException e) {
                logger.error("Failed to add meta index", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public void invalidateCache() {
        this.cache.invalidate();
    }

    public boolean rebuildMetaIndex(List<String> collectionIds, List<String> fields) {
        DeleteMappingRequest deleteMapping = new DeleteMappingRequest(new String[]{META_INDEX}).type(META_INDEX);
        this.indexClient.admin().indices().deleteMapping(deleteMapping).actionGet();
        try {
            HashMap<String, List<String>> document = new HashMap<String, List<String>>();
            document.put("collectionIDs", collectionIds);
            document.put("fields", fields);
            IndexRequestBuilder indexRequest = this.indexClient.prepareIndex(META_INDEX, META_INDEX).setSource(ElasticSearchHelper.createJSONObject(document).string());
            indexRequest.setConsistencyLevel(WriteConsistencyLevel.ONE);
            indexRequest.execute();
            logger.info("Rebuilt meta-index");
        }
        catch (IOException e) {
            logger.error("Failed to rebuild meta index", (Throwable)e);
            return false;
        }
        return true;
    }
}

