/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.couchbase.helpers;

import com.couchbase.client.CouchbaseClient;
import com.couchbase.client.protocol.views.AbstractView;
import com.couchbase.client.protocol.views.ComplexKey;
import com.couchbase.client.protocol.views.Query;
import com.couchbase.client.protocol.views.Stale;
import com.couchbase.client.protocol.views.View;
import com.couchbase.client.protocol.views.ViewResponse;
import com.couchbase.client.protocol.views.ViewResponseReduced;
import com.couchbase.client.protocol.views.ViewRow;
import com.google.common.collect.Ordering;
import com.google.gson.Gson;
import com.google.gson.internal.StringMap;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.gcube.couchbase.entities.Operator;
import org.gcube.couchbase.helpers.CouchBaseDataTypesHelper;
import org.gcube.couchbase.helpers.DateHelper;
import org.gcube.couchbase.helpers.Relation;
import org.gcube.couchbase.helpers.ViewHelper;
import org.gcube.indexmanagement.bdbwrapper.BDBGcqlQueryContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryHelper {
    private static final Logger logger = LoggerFactory.getLogger(QueryHelper.class);
    private static Gson gson = new Gson();
    private static final String WILDCARD = "*";
    private static final String CONJUCTION = " AND ";
    private static final String ORDERBY_KEYWORD = "sortby";
    private static final String ASC_KEYWORD = "ASC";
    private static final String DESC_KEYWORD = "DESC";
    private static int MAX_RESULTS = 1000;

    public static String pruneQuery(List<BDBGcqlQueryContainer.SingleTerm> terms) {
        ArrayList<String> validTerms = new ArrayList<String>();
        List<String> excludedFields = QueryHelper.getExcludedFields(terms);
        logger.info("All terms : ");
        for (BDBGcqlQueryContainer.SingleTerm t : terms) {
            logger.info("\t" + t.getField());
        }
        logger.info("Excluded fields : " + excludedFields);
        for (BDBGcqlQueryContainer.SingleTerm term : terms) {
            if (excludedFields.contains(term.getField())) continue;
            validTerms.add(term.getField() + " " + term.getRelation() + " " + term.getValue());
        }
        return StringUtils.join(validTerms, (String)CONJUCTION);
    }

    public static List<String> getExcludedFields(List<BDBGcqlQueryContainer.SingleTerm> terms) {
        ArrayList<String> excludedTerms = new ArrayList<String>();
        for (BDBGcqlQueryContainer.SingleTerm term : terms) {
            if (!term.getValue().equals(WILDCARD)) continue;
            excludedTerms.add(term.getField());
        }
        excludedTerms.add("gDocCollectionLang");
        return excludedTerms;
    }

    public static void addExcludedFields(List<ArrayList<BDBGcqlQueryContainer.SingleTerm>> queries, List<String> projections) {
        logger.debug("adding excluded fields in projections");
        logger.debug("projections : " + projections);
        for (ArrayList<BDBGcqlQueryContainer.SingleTerm> query : queries) {
            logger.debug("\tquery : " + query);
            List<String> excludedFields = QueryHelper.getExcludedFields(query);
            logger.debug("\texcludedFields : " + excludedFields);
            for (String field : excludedFields) {
                if (projections.contains(field)) continue;
                logger.debug("\t\tfield : " + field + " not in projections");
                projections.add(field);
            }
        }
    }

    public static String getOrderByField(String query) {
        logger.debug("adding excluded fields in projections");
        if (query.indexOf(ORDERBY_KEYWORD) > -1) {
            String orderField = query.substring(query.indexOf(ORDERBY_KEYWORD) + ORDERBY_KEYWORD.length()).trim();
            if (orderField.split("\\s+").length > 1) {
                for (String field : orderField.split("\\s+")) {
                    if (field.trim().equalsIgnoreCase(ASC_KEYWORD) || field.trim().equalsIgnoreCase(DESC_KEYWORD)) continue;
                    orderField = field;
                }
            }
            return orderField;
        }
        return null;
    }

    public static OrderBy getOrderBy(String query) {
        if (query.toUpperCase().trim().endsWith(ASC_KEYWORD)) {
            return OrderBy.ASC;
        }
        if (query.toUpperCase().trim().endsWith(DESC_KEYWORD)) {
            return OrderBy.DESC;
        }
        return OrderBy.ASC;
    }

    public static String deleteOrderBy(String query, String orderByField, OrderBy orderBy) {
        query = query.replaceAll(ORDERBY_KEYWORD, " ");
        if (orderByField != null) {
            if (orderBy.equals((Object)OrderBy.ASC)) {
                query = query.replace(ASC_KEYWORD, "");
            } else if (orderBy.equals((Object)OrderBy.DESC)) {
                query = query.replace(DESC_KEYWORD, "");
            }
        }
        return query.trim();
    }

    public static void dummyQuery(CouchbaseClient client, String designDocumentName, String viewName) {
        logger.info("Forcing update on index : " + viewName);
        View view = client.getView(designDocumentName, viewName);
        Query query = new Query();
        query.setStale(Stale.FALSE);
        client.query((AbstractView)view, query);
    }

    public static Collection<Map<String, String>> applyProjection(Map<String, Object> docs, List<String> projections, boolean distinct) {
        AbstractCollection projectedDocs = null;
        projectedDocs = distinct ? new HashSet() : new ArrayList();
        for (Map.Entry<String, Object> doc : docs.entrySet()) {
            String docValue = doc.getValue().toString();
            Map docMap = (Map)gson.fromJson(docValue, Map.class);
            StringMap fieldsMap = (StringMap)docMap.get("fields");
            logger.trace("docID : " + doc.getKey());
            logger.trace("\tfieldsJson : " + fieldsMap);
            HashMap<String, String> projectedDoc = new HashMap<String, String>();
            for (String projection : projections) {
                Object fieldContent = fieldsMap.get((Object)projection);
                String fieldValue = null;
                fieldValue = fieldContent != null ? (fieldContent instanceof Object[] ? StringUtils.join((Object[])((Object[])fieldContent)) : (fieldContent instanceof ArrayList ? StringUtils.join((Collection)((ArrayList)fieldContent), (String)" ") : fieldContent.toString())) : "";
                projectedDoc.put(projection, fieldValue);
            }
            projectedDocs.add(projectedDoc);
        }
        return projectedDocs;
    }

    public static List<String> queryCouchBase(CouchbaseClient client, String designDocumentName, String viewName, Operator op, Object startKey, Object endKey) {
        View view = client.getView(designDocumentName, viewName);
        Query query = QueryHelper.createTwoOperantQuery(op, startKey, endKey);
        ViewResponse vr = client.query((AbstractView)view, query);
        return QueryHelper.getViewResponse(vr);
    }

    public static List<String> queryCouchBase(CouchbaseClient client, String designDocumentName, String viewName, Operator op1, Object key1, Operator op2, Object key2) {
        View view = client.getView(designDocumentName, viewName);
        Query query = QueryHelper.createTwoOperantQuery(op1, key1, op2, key2);
        ViewResponse vr = client.query((AbstractView)view, query);
        return QueryHelper.getViewResponse(vr);
    }

    public static List<String> queryCouchBase(CouchbaseClient client, String designDocumentName, String viewName, Operator op, Object key) {
        View view = client.getView(designDocumentName, viewName);
        Query query = QueryHelper.createOneOperantQuery(op, key);
        ViewResponse vr = client.query((AbstractView)view, query);
        return QueryHelper.getViewResponse(vr);
    }

    public static List<String> getViewResponse(ViewResponse vr) {
        LinkedList<String> ret = new LinkedList<String>();
        for (ViewRow viewRow : vr) {
            logger.trace("Found : " + viewRow.getId() + ", key : " + viewRow.getKey());
            ret.add(viewRow.getId());
        }
        return ret;
    }

    public static Object singleGetCouchBase(CouchbaseClient client, String id) {
        return client.get(id);
    }

    public static Map<String, Object> multiGetCouchBase(CouchbaseClient client, Collection<String> ids, boolean distinct) {
        return QueryHelper.multiGetCouchBase(client, ids, distinct, MAX_RESULTS);
    }

    public static Map<String, Object> multiGetCouchBase(CouchbaseClient client, Collection<String> ids, boolean distinct, int numOfResults) {
        List newIds = null;
        newIds = distinct ? Ordering.natural().greatestOf(new HashSet<String>(ids), numOfResults) : Ordering.natural().greatestOf(ids, numOfResults);
        return client.getBulk((Collection)newIds);
    }

    public static Map<String, List<Relation>> getKeys(String queryString) throws Exception {
        String[] subStrings;
        HashMap<String, List<Relation>> keys = new HashMap<String, List<Relation>>();
        for (String subString : subStrings = queryString.split("[aA][nN][dD]")) {
            subString = subString.trim();
            logger.info("subString : " + subString);
            String[] terms = subString.split("\\s");
            logger.info("terms size : " + terms.length);
            for (String t : terms) {
                logger.info("\t" + t);
            }
            if (terms.length == 3) {
                String field = terms[0];
                String operator = terms[1];
                String value = terms[2];
                Relation r = new Relation(operator, value);
                ArrayList<Relation> rels = (ArrayList<Relation>)keys.get(field);
                if (rels == null) {
                    rels = new ArrayList<Relation>();
                    keys.put(field, rels);
                }
                rels.add(r);
                continue;
            }
            if (terms.length == 5) {
                String valueLeft = terms[0];
                String operatorLeft = terms[1];
                String field = terms[2];
                String operatorRight = terms[3];
                String valueRight = terms[4];
                Relation relLeft = new Relation(Operator.flipOperator(operatorLeft), valueLeft);
                Relation relRight = new Relation(operatorRight, valueRight);
                ArrayList<Relation> rels = (ArrayList<Relation>)keys.get(field);
                if (rels == null) {
                    rels = new ArrayList<Relation>();
                    keys.put(field, rels);
                }
                rels.add(relLeft);
                rels.add(relRight);
                continue;
            }
            throw new Exception("relation : " + subString + " cannot be parsed. Usually a relation has 3 or 5 terms. This one has : " + terms.length);
        }
        return keys;
    }

    public static Map<String, List<Relation>> validateAndSimplifyKeys(Map<String, List<Relation>> keys) throws Exception {
        HashMap<String, List<Relation>> newKeys = new HashMap<String, List<Relation>>();
        for (Map.Entry<String, List<Relation>> e : keys.entrySet()) {
            String field = e.getKey();
            List<Relation> rels = e.getValue();
            if (rels.size() == 1) {
                newKeys.put(field, rels);
                continue;
            }
            if (rels.size() == 2) {
                Relation left = null;
                Relation right = null;
                for (Relation rel : rels) {
                    if (rel.operator.equals((Object)Operator.LESS_EQUAL) || rel.operator.equals((Object)Operator.LESS_THAN)) {
                        left = rel;
                        continue;
                    }
                    if (!rel.operator.equals((Object)Operator.GREATER_EQUAL) && !rel.operator.equals((Object)Operator.GREATER_THAN)) continue;
                    right = rel;
                }
                if (left == null || right == null) {
                    throw new Exception("Error simplifying relations : " + rels);
                }
                newKeys.put(field, Arrays.asList(left, right));
                continue;
            }
            throw new Exception("Sympifying is not implementing yet. The following relation contains more than 2 relations : " + rels);
        }
        return newKeys;
    }

    public static List<String> queryString(CouchbaseClient client, String bucketName, String designDocumentName, Map<String, CouchBaseDataTypesHelper.DataType> keys, String queryString) throws Exception {
        Map<String, List<Relation>> relations = QueryHelper.getKeys(queryString);
        return QueryHelper.queryRelations(client, bucketName, designDocumentName, relations, keys);
    }

    public static List<String> queryRelations(CouchbaseClient client, String bucketName, String designDocumentName, Map<String, List<Relation>> relations, Map<String, CouchBaseDataTypesHelper.DataType> keys) throws Exception {
        LinkedList<String> docIDs = new LinkedList<String>();
        boolean first = true;
        for (Map.Entry<String, List<Relation>> relation : relations.entrySet()) {
            String field = relation.getKey();
            logger.info("querying on field : " + field + " started");
            String viewName = ViewHelper.constructViewName(bucketName, field, keys);
            List<String> queryResult = null;
            List<Relation> rels = relation.getValue();
            if (rels.size() == 1) {
                Operator op = rels.get((int)0).operator;
                Object value = CouchBaseDataTypesHelper.convertToObject(rels.get((int)0).value, keys.get(field));
                queryResult = QueryHelper.queryCouchBase(client, designDocumentName, viewName, op, value);
            } else if (rels.size() == 2) {
                Operator opLeft = rels.get((int)0).operator;
                Object valueLeft = CouchBaseDataTypesHelper.convertToObject(rels.get((int)0).value, keys.get(field));
                Operator opRight = rels.get((int)1).operator;
                Object valueRight = CouchBaseDataTypesHelper.convertToObject(rels.get((int)1).value, keys.get(field));
                queryResult = QueryHelper.queryCouchBase(client, designDocumentName, viewName, opLeft, valueLeft, opRight, valueRight);
            } else {
                throw new Exception("Error in relations : " + rels);
            }
            logger.info("querying on field : " + field + " ended");
            if (first) {
                docIDs.addAll(queryResult);
                first = false;
                continue;
            }
            docIDs.retainAll(queryResult);
        }
        return docIDs;
    }

    public static Long keyCount(CouchbaseClient client, String bucketName, String designDocumentName, Set<String> fields, Map<String, CouchBaseDataTypesHelper.DataType> keys) throws Exception {
        Long count = 0L;
        for (String field : fields) {
            count = count + QueryHelper.queryCountCouchBase(client, bucketName, designDocumentName, field, keys);
        }
        return count;
    }

    public static Long queryCountCouchBase(CouchbaseClient client, String bucketName, String designDocumentName, String fieldName, Map<String, CouchBaseDataTypesHelper.DataType> keys) throws Exception {
        String viewName = ViewHelper.constructViewName(bucketName, fieldName, keys);
        return QueryHelper.queryCountCouchBase(client, designDocumentName, viewName);
    }

    public static Long queryCountCouchBase(CouchbaseClient client, String designDocumentName, String viewName) throws Exception {
        View view = client.getView(designDocumentName, viewName);
        Query query = new Query();
        ViewResponseReduced vrr = (ViewResponseReduced)client.query((AbstractView)view, query);
        Long count = null;
        int rows = 0;
        for (ViewRow viewRow : vrr) {
            count = Long.valueOf(viewRow.getValue());
            if (++rows <= 1) continue;
            throw new Exception("reduce returned more than 1 results");
        }
        return count;
    }

    public static Query createTwoOperantQuery(Operator op1, Object value1, Operator op2, Object value2) {
        Query query = new Query();
        query = QueryHelper.createOneOperantQuery(query, op1, value1);
        query = QueryHelper.createOneOperantQuery(query, op2, value2);
        return query;
    }

    public static Query createTwoOperantQuery(Operator op, Object value1, Object value2) {
        Query query = new Query();
        query.setReduce(Boolean.valueOf(false));
        ComplexKey key1 = ComplexKey.of((Object[])new Object[]{value1});
        ComplexKey key2 = ComplexKey.of((Object[])new Object[]{value2});
        switch (op) {
            case GREATER_THAN_AND_LESS_THAN: {
                query.setRange(key1, key2);
                query.setInclusiveEnd(false);
                break;
            }
            case GREATER_EQUAL_AND_LESS_EQUAL: {
                query.setRange(key1, key2);
                break;
            }
        }
        return query;
    }

    public static Query createOneOperantQuery(Operator op, Object value) {
        Query query = new Query();
        return QueryHelper.createOneOperantQuery(query, op, value);
    }

    public static Query createOneOperantQuery(Query query, Operator op, Object value) {
        query.setReduce(Boolean.valueOf(false));
        ComplexKey key = ComplexKey.of((Object[])new Object[]{value});
        switch (op) {
            case EQUAL: {
                query.setKey(key);
                break;
            }
            case GREATER_THAN: {
                query.setRangeStart(key);
                break;
            }
            case GREATER_EQUAL: {
                query.setRangeStart(key);
                break;
            }
            case LESS_THAN: {
                query.setRangeEnd(key);
                query.setInclusiveEnd(false);
                break;
            }
            case LESS_EQUAL: {
                query.setRangeEnd(key);
                query.setInclusiveEnd(true);
                break;
            }
        }
        return query;
    }

    private static void printQuery(ViewResponse vr) {
        int i = 1;
        for (ViewRow viewRow : vr) {
            ++i;
        }
    }

    public static void printQueryDate(ViewResponse vr) {
        int i = 1;
        for (ViewRow viewRow : vr) {
            if (viewRow.getKey() == null || viewRow.getKey().equalsIgnoreCase("null")) continue;
            logger.info(i + " #. " + DateHelper.toCalendarDateString(Long.parseLong(viewRow.getKey())) + " : " + viewRow.getValue());
            ++i;
        }
    }

    public static Map<String, String> getViewResponseKeyValues(ViewResponse vr) {
        HashMap<String, String> ret = new HashMap<String, String>();
        for (ViewRow viewRow : vr) {
            logger.info("Found : " + viewRow.getId() + ", key : " + viewRow.getKey());
            ret.put(viewRow.getId(), viewRow.getKey());
        }
        return ret;
    }

    public static void main(String[] args) throws Exception {
        String queryString = "((82a37f5a-9b57-4ce7-b34c-17ff9fca9fa6 == \"*\") and (gDocCollectionID == 7374617475733D756E707562)) project 82a37f5a-9b57-4ce7-b34c-17ff9fca9fa6 sortby   \t 82a37f5a-9b57-4ce7-b34c-17ff9fca9fa6 ";
        String orderByField = QueryHelper.getOrderByField(queryString);
        System.out.println("orderByField : " + orderByField);
        OrderBy orderby = QueryHelper.getOrderBy(queryString);
        System.out.println("orderby : " + (Object)((Object)orderby));
        queryString = QueryHelper.deleteOrderBy(queryString, orderByField, orderby);
        System.out.println("query string after orderby removal : " + queryString);
    }

    public static enum OrderBy {
        ASC,
        DESC;

    }
}

