/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.couchbase.helpers;

import com.couchbase.client.CouchbaseClient;
import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.events.BufferEvent;
import gr.uoa.di.madgik.grs.events.KeyValueEvent;
import gr.uoa.di.madgik.grs.proxy.IWriterProxy;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPWriterProxy;
import gr.uoa.di.madgik.grs.reader.ForwardReader;
import gr.uoa.di.madgik.grs.reader.GRS2ReaderException;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.GenericRecordDefinition;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.FieldDefinition;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.grs.record.field.StringFieldDefinition;
import gr.uoa.di.madgik.grs.writer.GRS2WriterException;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.gcube.couchbase.entities.ForwardIndexDocument;
import org.gcube.couchbase.entities.MetaIndex;
import org.gcube.couchbase.helpers.CouchBaseDataTypesHelper;
import org.gcube.couchbase.helpers.QueryHelper;
import org.gcube.couchbase.helpers.RowsetParser;
import org.gcube.couchbase.helpers.ViewHelper;
import org.gcube.indexmanagement.bdbwrapper.BDBGcqlProcessor;
import org.gcube.indexmanagement.bdbwrapper.BDBGcqlQueryContainer;
import org.gcube.indexmanagement.common.IndexException;
import org.gcube.indexmanagement.common.XMLProfileParser;
import org.gcube.indexmanagement.resourceregistry.RRadaptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CouchBaseHelper {
    private static final long RSTIMEOUT = 5L;
    private static final Logger logger = LoggerFactory.getLogger(CouchBaseHelper.class);

    public static void createIndexes(CouchbaseClient client, String bucketName, String designDocumentName, Map<String, CouchBaseDataTypesHelper.DataType> keys) {
        logger.info("Creating indexes...");
        ViewHelper.createAllIndexes(client, bucketName, designDocumentName, keys);
        logger.info("Creating indexes...OK");
    }

    public static void insertSimple(CouchbaseClient client, String key, String value, CouchBaseDataTypesHelper.DataType dataType) {
        String val = CouchBaseDataTypesHelper.getDoc(value, dataType);
        logger.info("Adding doc " + key + " : " + value);
        client.set(key, 0, (Object)val);
    }

    public static void insertSimple(CouchbaseClient client, ForwardIndexDocument doc) {
        String id = doc.getID();
        String value = doc.toJSON();
        logger.info("Adding record with " + id);
        client.set(id, 0, (Object)value);
    }

    public static void delete(String key, CouchBaseDataTypesHelper.DataType dataType, CouchbaseClient client) {
        client.delete(key);
    }

    public static void deleteDocsCouchBase(CouchbaseClient client, List<String> keys) {
        for (String key : keys) {
            client.delete(key);
        }
    }

    public static void commit(CouchbaseClient client, String bucketName, String designDocumentName, Map<String, CouchBaseDataTypesHelper.DataType> keys) {
        if (keys == null || keys.size() == 0) {
            logger.warn("Keys not set. Commit will be skipped");
            return;
        }
        for (String field : keys.keySet()) {
            logger.info("Performing a dummy query on field : " + field);
            String viewName = ViewHelper.constructViewName(bucketName, field, keys);
            int tries = 5;
            boolean success = false;
            Exception ex = null;
            while (tries > 0) {
                try {
                    QueryHelper.dummyQuery(client, designDocumentName, viewName);
                    logger.warn("Dummy query perform succeded.");
                    success = true;
                    break;
                }
                catch (Exception e) {
                    ex = e;
                    logger.warn("Dummy query perform failed. Probably timeout");
                    logger.warn("Retrying in 2 secs.. Tries left : " + --tries);
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (Exception e2) {}
                }
            }
            if (success) continue;
            logger.warn("Commit failed. Index for field " + field + "  may not be ready. Although this is not a problem. Latest exception : ", (Throwable)ex);
        }
    }

    public static String query(final CouchbaseClient client, MetaIndex meta, final String bucketName, final String designDocName, final Map<String, CouchBaseDataTypesHelper.DataType> keys, RRadaptor rradaptor, String queryString) {
        try {
            final ArrayList<String> presentables = new ArrayList<String>(meta.getPresentables());
            ArrayList<String> searchables = new ArrayList<String>(meta.getSearchables());
            logger.info("Executing query : " + queryString);
            logger.info("presentables : " + presentables);
            logger.info("searchables  : " + searchables);
            logger.info("keys : " + keys);
            BDBGcqlProcessor processor = new BDBGcqlProcessor();
            BDBGcqlQueryContainer queryCont = (BDBGcqlQueryContainer)processor.processQuery(presentables, searchables, queryString, rradaptor);
            final ArrayList queries = queryCont.getBdbQueries();
            final ArrayList<String> projections = new ArrayList<String>(queryCont.getProjectedFields().values());
            QueryHelper.addExcludedFields(queries, projections);
            final boolean distinct = queryCont.getDistinct();
            final RecordWriter<GenericRecord> rsWriter = CouchBaseHelper.initRSWriterForSearchHits(presentables, projections, distinct, rradaptor);
            if (!projections.contains("ObjectID")) {
                projections.add("ObjectID");
            }
            Runnable writerRun = new Runnable(){

                @Override
                public void run() {
                    try {
                        ArrayList<Map<String, String>> resultDocs = new ArrayList<Map<String, String>>();
                        for (ArrayList arrayList : queries) {
                            logger.debug(" >>> process Query");
                            logger.debug("Query received: " + arrayList);
                            String subQueryString = QueryHelper.pruneQuery(arrayList);
                            List<String> docIDs = null;
                            try {
                                logger.info("executing query : " + subQueryString);
                                docIDs = QueryHelper.queryString(client, bucketName, designDocName, keys, subQueryString);
                                logger.info("query returned : " + docIDs);
                                Map<String, Object> docs = QueryHelper.multiGetCouchBase(client, docIDs, distinct);
                                List<Map<String, String>> projectedDocuments = QueryHelper.applyProjection(docs, projections);
                                resultDocs.addAll(projectedDocuments);
                            }
                            catch (Exception e) {
                                logger.error("Error while searching the index", (Throwable)e);
                            }
                        }
                        rsWriter.emit((BufferEvent)new KeyValueEvent("resultsNumberFinal", "" + resultDocs.size()));
                        for (Map map : resultDocs) {
                            if (CouchBaseHelper.writeSearchHitInResultSet(map, (RecordWriter<GenericRecord>)rsWriter, projections, presentables, 5L)) continue;
                            logger.error("ERROR writing doc " + map + " in RS");
                            break;
                        }
                        if (rsWriter.getStatus() != IBuffer.Status.Dispose) {
                            rsWriter.close();
                        }
                    }
                    catch (Exception e) {
                        logger.error("Error during search.", (Throwable)e);
                        try {
                            if (rsWriter.getStatus() != IBuffer.Status.Dispose) {
                                rsWriter.close();
                            }
                        }
                        catch (Exception ex) {
                            logger.error("Error while closing RS writer.", (Throwable)ex);
                        }
                    }
                }
            };
            new Thread(writerRun).start();
            logger.info("results locator : " + rsWriter.getLocator());
            return rsWriter.getLocator().toString();
        }
        catch (Exception e) {
            logger.error("Error in query : ", (Throwable)e);
            return null;
        }
    }

    private static void feedRowset(CouchbaseClient client, String rowset, MetaIndex meta) throws Exception {
        ForwardIndexDocument doc = new ForwardIndexDocument(rowset);
        CouchBaseHelper.insertSimple(client, doc);
        meta.updateFromDoc(doc);
    }

    public static boolean feedLocator(CouchbaseClient client, String resultSetLocation, MetaIndex meta) throws GRS2ReaderException, URISyntaxException {
        logger.info("Initializing reader at resultset : " + resultSetLocation);
        ForwardReader reader = new ForwardReader(new URI(resultSetLocation));
        reader.setIteratorTimeout(5L);
        reader.setIteratorTimeUnit(TimeUnit.MINUTES);
        int rowSetCount = 1;
        boolean success = true;
        long beforeFeed = System.currentTimeMillis();
        try {
            logger.info("Initializing resultset reader iterator");
            Iterator it = reader.iterator();
            while (it.hasNext()) {
                logger.info("Getting result : " + rowSetCount);
                long before = System.currentTimeMillis();
                Record result = (Record)it.next();
                long after = System.currentTimeMillis();
                logger.info("Time for getting record from Result Set : " + (double)(after - before) / 1000.0 + " secs");
                before = System.currentTimeMillis();
                String rowset = RowsetParser.getRowsetFromResult(result);
                CouchBaseHelper.feedRowset(client, rowset, meta);
                after = System.currentTimeMillis();
                logger.info("Time for getting rowset from record : " + (double)(after - before) / 1000.0 + " secs");
                if (!success) {
                    logger.info("feed rowset failed");
                    break;
                }
                logger.info("Result " + rowSetCount + " inserted");
                ++rowSetCount;
            }
        }
        catch (Exception e) {
            logger.info("Exception while feeding", (Throwable)e);
        }
        reader.close();
        long afterFeed = System.currentTimeMillis();
        logger.info("Total feed time : " + (double)(afterFeed - beforeFeed) / 1000.0 + " secs");
        System.out.println("Total feed time : " + (double)(afterFeed - beforeFeed) / 1000.0 + " secs");
        if (success) {
            logger.info("Feeding succeded!!!");
            meta.saveToDatabase(client);
        } else {
            logger.error("Feeding failed!!!");
        }
        return success;
    }

    private static boolean writeSearchHitInResultSet(Map<String, String> docMap, RecordWriter<GenericRecord> rsWriter, List<String> projections, List<String> presentables, long rsTimeout) throws GRS2WriterException {
        if (rsWriter.getStatus() != IBuffer.Status.Open) {
            return false;
        }
        GenericRecord rec = new GenericRecord();
        ArrayList<StringField> fields = new ArrayList<StringField>();
        String fieldContentDocID = docMap.containsKey("ObjectID") ? docMap.get("ObjectID") : "NoMetaId";
        logger.info("Adding " + "ObjectID".toLowerCase() + " field with value : " + fieldContentDocID);
        fields.add(new StringField(fieldContentDocID));
        if (projections != null && projections.size() > 0) {
            List<String> returnFields = null;
            returnFields = projections.contains("*") ? presentables : projections;
            logger.info("returnFields : " + returnFields);
            for (String fieldName : returnFields) {
                if (fieldName.equalsIgnoreCase("ObjectID") || fieldName.equalsIgnoreCase("fullpayload")) continue;
                String fieldContent = docMap.containsKey(fieldName) ? docMap.get(fieldName).toString() : "";
                fieldContent = XMLProfileParser.escapeForXML((String)fieldContent);
                logger.info("fieldContent : " + fieldContent);
                fields.add(new StringField(fieldContent));
            }
        }
        if (rsWriter.getStatus() != IBuffer.Status.Open) {
            return false;
        }
        rec.setFields(fields.toArray(new Field[fields.size()]));
        while (!rsWriter.put((Record)rec, rsTimeout, TimeUnit.SECONDS) && rsWriter.getStatus() == IBuffer.Status.Open) {
        }
        return true;
    }

    public static RecordWriter<GenericRecord> initRSWriterForSearchHits(List<String> presentables, List<String> projections, boolean distinct, RRadaptor adaptor) throws IndexException, GRS2WriterException {
        logger.info("Initializing gRS2 writer");
        logger.info("(1/3) getting field definitions");
        FieldDefinition[] fieldDef = null;
        try {
            fieldDef = CouchBaseHelper.createFieldDefinition(presentables, projections, distinct, adaptor);
        }
        catch (Exception e) {
            logger.error("Could not create field definition: ", (Throwable)e);
            throw new IndexException((Throwable)e);
        }
        logger.info("(2/3) creating record definitions");
        RecordDefinition[] definition = new RecordDefinition[]{new GenericRecordDefinition(fieldDef)};
        logger.info("(3/3) creating rsWriter");
        return new RecordWriter((IWriterProxy)new TCPWriterProxy(), definition);
    }

    private static FieldDefinition[] createFieldDefinition(List<String> presentable, List<String> projections, boolean distinct, RRadaptor adaptor) throws Exception {
        ArrayList<StringFieldDefinition> fieldDef = new ArrayList<StringFieldDefinition>();
        FieldDefinition[] fd = null;
        fieldDef.add(new StringFieldDefinition("ObjectID"));
        if (projections == null || projections.size() == 0) {
            fd = fieldDef.toArray(new FieldDefinition[fieldDef.size()]);
            logger.info("No projections found");
        } else if (projections.contains("*")) {
            for (String fieldName : presentable) {
                String fieldID = adaptor.getFieldIDFromName(fieldName);
                if (fieldName.equalsIgnoreCase("ObjectID") || fieldName.equalsIgnoreCase("fullpayload")) continue;
                fieldDef.add(new StringFieldDefinition(fieldID));
            }
        } else {
            for (String fieldName : projections) {
                String fieldID = adaptor.getFieldIDFromName(fieldName);
                if (fieldName.equalsIgnoreCase("ObjectID") || fieldName.equalsIgnoreCase("fullpayload")) continue;
                fieldDef.add(new StringFieldDefinition(fieldID));
            }
        }
        fd = fieldDef.toArray(new FieldDefinition[fieldDef.size()]);
        return fd;
    }
}

