package org.gcube.couchbase.helpers;

import gr.uoa.di.madgik.grs.buffer.GRS2BufferException;
import gr.uoa.di.madgik.grs.record.GRS2RecordDefinitionException;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.field.StringField;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 
 * @author Alex Antoniadis
 * 
 */
public class RowsetParser {

	private static final Logger logger = LoggerFactory.getLogger(RowsetParser.class);
	private static final String ROWSETFIELD = "Rowset";

	/*
	private static String regexCollID = IndexType.COLLECTION_FIELD + "\\s*==\\s*\"(\\S+)\"";
	private static String regexCollID = ForwardIndexDocument.COLLECTION_FIELD + "\\s*==\\s*\"(\\S+)\"";
	private static Pattern patternCollID = Pattern.compile(regexCollID);

	public static String getCollectionIDFromQuery(String queryString) {
		Matcher m = patternCollID.matcher(queryString);
		if (m.find())
			return m.group(1).trim();
		else
			return null;
	}
	*/
	
	public static String getRowsetFromResult(Record record) throws GRS2RecordDefinitionException, GRS2BufferException {
		String payload = ((StringField) record.getField(ROWSETFIELD)).getPayload();
		//logger.info("parsed payload : " + payload);
		logger.info("parsed payload");
		return payload;
	}
}
