/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.service.idm.rest.examples;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.List;
import org.gcube.service.idm.IdMManager;
import org.gcube.service.idm.serializers.IdmObjectSerializator;
import org.gcube.smartgears.annotations.ManagedBy;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.KeycloakBuilder;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ClientsResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.RoleResource;
import org.keycloak.admin.client.resource.RolesResource;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@ManagedBy(value=IdMManager.class)
@Path(value="")
public class KeycloakTestService {
    private final String CLIENT_SECRET = "NOT_COMMITTED";
    private static final Logger logger = LoggerFactory.getLogger(KeycloakTestService.class);

    public static String encodeClientIdContext(String context) {
        return context.replace("/", "%2F");
    }

    @GET
    @Path(value="keycloak")
    @Produces(value={"application/json;charset=UTF-8", "application/vnd.api+json"})
    public Response testKeycloak(@QueryParam(value="serverUrl") @DefaultValue(value="https://accounts.dev.d4science.org/auth") String serverUrl, @QueryParam(value="realm") @DefaultValue(value="d4science") String realm, @QueryParam(value="role-name") @DefaultValue(value="Member") String roleName, @QueryParam(value="client_id") @DefaultValue(value="id.d4science.org") String clientId, @QueryParam(value="client_secret") @DefaultValue(value="NOT_COMMITTED") String client_secret) {
        String client_contenxt = "/gcube";
        ArrayList<String> usernames = new ArrayList<String>();
        try {
            Keycloak kclient = KeycloakBuilder.builder().serverUrl(serverUrl).realm(realm).grantType("client_credentials").clientId(clientId).clientSecret(client_secret).build();
            List users = KeycloakTestService.searchByRole((Keycloak)kclient, (String)realm, (String)client_contenxt, (String)roleName);
            if (users != null) {
                for (UserRepresentation user : users) {
                    usernames.add(user.getUsername());
                }
            }
            ObjectMapper objectMapper = IdmObjectSerializator.getSerializer();
            String jsonData = objectMapper.writeValueAsString(usernames);
            return Response.ok((Object)jsonData).build();
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return Response.serverError().build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.serverError().build();
        }
    }

    private static List<UserRepresentation> searchByRole(Keycloak kclient, String krealm, String clientIdContext, String roleName) {
        clientIdContext = KeycloakTestService.encodeClientIdContext((String)clientIdContext);
        logger.info("Searching by role: {}", (Object)roleName);
        RealmResource realm_resource = kclient.realm(krealm);
        logger.info("{} realm_resource: {}", (Object)krealm, (Object)realm_resource);
        ClientsResource clients_resource = realm_resource.clients();
        logger.info("clients_resource {}", (Object)clients_resource);
        for (ClientRepresentation c : clients_resource.findAll()) {
            logger.info("listing all clients, found {} - {}", (Object)c.getClientId(), (Object)c.getId());
        }
        List clients_repr = clients_resource.findByClientId(clientIdContext);
        logger.info("{} clients_repr: {}", (Object)clientIdContext, (Object)clients_repr);
        String client_id = "";
        for (ClientRepresentation c_repr : clients_repr) {
            logger.info("searching {}, found client {} - {}", new Object[]{clientIdContext, c_repr.getClientId(), c_repr.getId()});
            client_id = c_repr.getId();
        }
        ClientResource client_resource = clients_resource.get(client_id);
        logger.info("client_resource {}", (Object)client_resource);
        RolesResource roles_resource = client_resource.roles();
        for (RoleRepresentation r : roles_resource.list()) {
            logger.info("found role {}", (Object)r);
        }
        logger.info("roles_resource {}", (Object)roles_resource);
        RoleResource role_resource = roles_resource.get(roleName);
        logger.info("{} role_resource: {}", (Object)roleName, (Object)roles_resource);
        List users_repr = role_resource.getUserMembers(Integer.valueOf(0), Integer.valueOf(100000));
        for (UserRepresentation u : users_repr) {
            logger.info("found user {}", (Object)u);
        }
        return users_repr;
    }
}

