/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.service.idm.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.webcohesion.enunciate.metadata.rs.RequestHeader;
import com.webcohesion.enunciate.metadata.rs.RequestHeaders;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Set;
import org.gcube.idm.common.models.IdmUser;
import org.gcube.service.idm.IdMManager;
import org.gcube.service.idm.beans.ResponseBean;
import org.gcube.service.idm.beans.ResponseBeanMap;
import org.gcube.service.idm.beans.ResponseBeanPaginated;
import org.gcube.service.idm.controller.KCRolesController;
import org.gcube.service.idm.controller.KCUserController;
import org.gcube.service.idm.keycloack.KkClientFactory;
import org.gcube.service.idm.serializers.IdmObjectSerializator;
import org.gcube.smartgears.annotations.ManagedBy;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.RoleResource;
import org.keycloak.admin.client.resource.RolesResource;
import org.keycloak.representations.idm.RoleRepresentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedBy(value=IdMManager.class)
@RequestHeaders(value={@RequestHeader(name="Authorization", description="Bearer token, see https://dev.d4science.org/how-to-access-resources"), @RequestHeader(name="Content-Type", description="application/json")})
@Path(value="roles")
public class RolesAPI {
    private static final Logger logger = LoggerFactory.getLogger(RolesAPI.class);

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    public Response search(@QueryParam(value="search") @DefaultValue(value="") String search, @QueryParam(value="first") @DefaultValue(value="0") int firstResult, @QueryParam(value="max") @DefaultValue(value="100") int maxResults, @QueryParam(value="format") @DefaultValue(value="name") KCRolesController.ROLES_REPR format) {
        ResponseBeanPaginated responseBean = new ResponseBeanPaginated(Integer.valueOf(firstResult), Integer.valueOf(maxResults));
        Boolean briefRepresentation = !KCRolesController.ROLES_REPR.full.equals((Object)format);
        try {
            ClientResource client = KkClientFactory.getSingleton().getKKClient();
            List roles = client.roles().list(search, Integer.valueOf(firstResult), Integer.valueOf(maxResults), briefRepresentation.booleanValue());
            responseBean.setResult((Object)KCRolesController.formatList((List)roles, (KCRolesController.ROLES_REPR)format));
            responseBean.setSuccess(true);
            ObjectMapper objectMapper = IdmObjectSerializator.getSerializer();
            String jsonData = objectMapper.writeValueAsString((Object)responseBean);
            return Response.ok((Object)jsonData).build();
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    @GET
    @Path(value="/{role_name}")
    @Produces(value={"application/json;charset=UTF-8", "application/vnd.api+json"})
    public Response role(@PathParam(value="role_name") String role_name) {
        ResponseBean responseBean = new ResponseBean();
        try {
            RoleRepresentation role = KCRolesController.getRoleByNameCurrent((String)role_name);
            responseBean.setResult((Object)role);
            responseBean.setSuccess(true);
            ObjectMapper objectMapper = IdmObjectSerializator.getSerializer();
            String jsonData = objectMapper.writeValueAsString((Object)responseBean);
            return Response.ok((Object)jsonData).build();
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    @GET
    @Path(value="/{role_name}/members")
    @Produces(value={"application/json;charset=UTF-8", "application/vnd.api+json"})
    public Response membersForRole(@PathParam(value="role_name") String role_name, @QueryParam(value="first") @DefaultValue(value="0") int firstResult, @QueryParam(value="max") @DefaultValue(value="100") int maxResults, @QueryParam(value="format") @DefaultValue(value="username") IdmUser.USERS_REPR format) {
        ResponseBeanPaginated responseBean = new ResponseBeanPaginated(Integer.valueOf(firstResult), Integer.valueOf(maxResults));
        try {
            ClientResource client = KkClientFactory.getSingleton().getKKClient();
            RolesResource roles_resource = client.roles();
            RoleResource r = roles_resource.get(role_name);
            List users = r.getUserMembers(Integer.valueOf(firstResult), Integer.valueOf(maxResults));
            responseBean.setResult(KCUserController.formatList((List)users, (IdmUser.USERS_REPR)format));
            responseBean.setSuccess(true);
            ObjectMapper objectMapper = IdmObjectSerializator.getSerializer();
            String jsonData = objectMapper.writeValueAsString((Object)responseBean);
            return Response.ok((Object)jsonData).build();
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    @GET
    @Path(value="/{role_name}/users")
    @Produces(value={"application/json;charset=UTF-8", "application/vnd.api+json"})
    public Response usersForRole(@PathParam(value="role_name") String role_name, @QueryParam(value="first") @DefaultValue(value="0") int firstResult, @QueryParam(value="max") @DefaultValue(value="100") int maxResults, @QueryParam(value="format") @DefaultValue(value="username") IdmUser.USERS_REPR format) {
        ResponseBeanMap responseBean = new ResponseBeanMap();
        try {
            ClientResource client = KkClientFactory.getSingleton().getKKClient();
            RolesResource roles_resource = client.roles();
            RoleResource r = roles_resource.get(role_name);
            Set groups = r.getRoleGroupMembers(Integer.valueOf(firstResult), Integer.valueOf(maxResults));
            responseBean.putResult("roleGroupMembers", (Object)groups);
            List users = r.getUserMembers();
            responseBean.putResult("users", (Object)users);
            ObjectMapper objectMapper = IdmObjectSerializator.getSerializer();
            String jsonData = objectMapper.writeValueAsString((Object)responseBean);
            return Response.ok((Object)jsonData).build();
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    @GET
    @Path(value="/{role_name}/service_accounts")
    @Produces(value={"application/json;charset=UTF-8", "application/vnd.api+json"})
    public Response servicesAccountsForRole(@PathParam(value="role_name") String role_name, @QueryParam(value="first") @DefaultValue(value="0") int firstResult, @QueryParam(value="max") @DefaultValue(value="100") int maxResults, @QueryParam(value="format") @DefaultValue(value="username") IdmUser.USERS_REPR format) {
        throw new InternalServerErrorException("not implemented");
    }
}

