package org.gcube.service.idm.liferay;

import org.gcube.idm.common.is.IsServerConfig;
import org.gcube.service.idm.AbstractClientFactory;
import org.gcube.vomanagement.usermanagement.impl.ws.LiferayWSUserManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import jakarta.ws.rs.InternalServerErrorException;

public class LiferayClientFactory extends AbstractClientFactory {
	private static final Logger logger = LoggerFactory.getLogger(LoggerFactory.class);

	LiferayWSUserManager client = null;

	// Service endpoint properties
	protected final String RUNTIME_RESOURCE_NAME = "D4Science Infrastructure Gateway";
	protected final String CATEGORY = "Portal";
	protected final String END_POINT_NAME = "JSONWSUser";
	protected final boolean IS_ROOT_SERVICE = true;

	public String getRuntimeResourceName() {
		return RUNTIME_RESOURCE_NAME;
	}

	public String getCategory() {
		return CATEGORY;
	}

	public String getEndPointName() {
		return END_POINT_NAME;
	}

	public boolean isRootService() {
		return IS_ROOT_SERVICE;
	}

	private static LiferayClientFactory singleton = new LiferayClientFactory();

	public static LiferayClientFactory getSingleton() {
		if (singleton == null)
			singleton = new LiferayClientFactory();
		return singleton;
	}

	public void setConfig(IsServerConfig config) {
		super.setConfig(config);
		this.client = null;
	}

	public LiferayWSUserManager createtLiferayClientInstance() {
		if (this.config == null) {
			this.config = fetchIsConfig();
		}
		return createtLiferayClientInstance(this.config);
	}

	public static LiferayWSUserManager createtLiferayClientInstance(IsServerConfig config) {
		String host = config.getServerUrl();
		String schema = config.getProperty("schema");
		String user = config.getProperty("username");
		String password = config.getProperty("password");
		Integer port = Integer.valueOf(config.getProperty("port"));

		LiferayWSUserManager client = null;
		try {
			client = new LiferayWSUserManager(user, password, host, schema, port);
		} catch (Exception e) {
			e.printStackTrace();
			throw new InternalServerErrorException("cannot create Liferay client");
		}

		logger.info("Liferay object built {} - {}", config.getServerUrl(), config.getName());
		return client;
	}

	public LiferayWSUserManager getClient() {
		if (this.client == null) {
			this.client = createtLiferayClientInstance();
		}
		return this.client;
	}

}
