package org.gcube.service.idm.keycloack;

import java.rmi.ServerException;
import java.util.List;

import org.gcube.common.security.providers.SecretManagerProvider;
import org.gcube.idm.common.is.IsServerConfig;
import org.gcube.service.idm.AbstractClientFactory;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.KeycloakBuilder;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.representations.idm.ClientRepresentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import jakarta.ws.rs.NotFoundException;

public class KkClientFactory extends AbstractClientFactory{
	private static final Logger logger = LoggerFactory.getLogger(KkClientFactory.class);

	protected static String RUNTIME_RESOURCE_NAME = "IAM";
	protected static String CATEGORY = "Service";
	protected static String END_POINT_NAME = "d4science";
	protected static boolean IS_ROOT_SERVICE = true;


	public String getRuntimeResourceName() {
		return RUNTIME_RESOURCE_NAME;
	}

	public String getCategory() {
		return CATEGORY;
	}

	public String getEndPointName() {
		return END_POINT_NAME;
	}


	public boolean isRootService() {
		return IS_ROOT_SERVICE;
	}


	private static KkClientFactory singleton = new KkClientFactory();

	public static KkClientFactory getSingleton() {
		if (singleton == null)
			singleton = new KkClientFactory();
		return singleton;
	}

	public KeycloackApiClient createtKeycloakInstance(String context) {
		if (this.secret == null) {
			this.secret = getSecretForInfrastructure();
		}
		if (this.config == null) {
			this.config = fetchIsConfig(this.secret);
		}

		return createtKeycloakInstance(this.config, context);
	}

	public static KeycloackApiClient createtKeycloakInstance(IsServerConfig config, String context) {
		Keycloak kclient = KeycloakBuilder.builder()
				.serverUrl(config.getServerUrl())
				.realm(config.getName())
				.grantType(config.getGrantType())
				.clientId(config.getClientId()) //
				.clientSecret(config.getClientSecret()).build();

		return new KeycloackApiClient(kclient, config.getName(), context);
	}

	public RealmResource getKKRealm() {
		String ctx = SecretManagerProvider.get().getContext();
		return getKKRealm(ctx);
	}

	public RealmResource getKKRealm(String ctx) {
		logger.info("Searching client for contex");

		KeycloackApiClient keycloackApiClient = createtKeycloakInstance(ctx);
		RealmResource realm = keycloackApiClient.kclient.realm(keycloackApiClient.realmName);
		return realm;
	}

	public ClientResource getKKClient() {
		String ctx = SecretManagerProvider.get().getContext();
		return getKKClient(ctx);
	}

	public ClientResource getKKClient(String ctx) {
		logger.info("Searching client for contex");

		RealmResource realm = getKKRealm(ctx);

		List<ClientRepresentation> clients = realm.clients().findByClientId(encodeClientIdContext(ctx));

		if (clients.size() == 0) {
			return null;
		}
		String id = clients.get(0).getId();
		return realm.clients().get(id);
	}

	/**
	 * select the ClientResource by name, or current client if clientId parameter is
	 * null;
	 * 
	 * @param clientId
	 * @return
	 * @throws ServerException
	 * @throws NotFoundException
	 */
	public ClientResource getKKClientById(String clientId) {

		if (clientId == null)
			return KkClientFactory.getSingleton().getKKClient();

		RealmResource realmResource = getKKRealm();

		List<ClientRepresentation> clients = realmResource.clients().findByClientId(clientId);

		if (clients.size() == 0) {
			throw new NotFoundException();
		}
		String id = clients.get(0).getId();

		return realmResource.clients().get(id);
	}

	public static String encodeClientIdContext(String context) {
		return context.replace("/", "%2F");
	}
}
