/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.service.idm.controller;

import jakarta.ws.rs.WebApplicationException;
import java.rmi.ServerException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.gcube.service.idm.keycloack.KkClientFactory;
import org.keycloak.admin.client.CreatedResponseUtil;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.ClientsResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.admin.client.resource.UsersResource;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.ProtocolMapperRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class AdminKeycloakController {
    private static final Logger logger = LoggerFactory.getLogger(AdminKeycloakController.class);

    public static UserRepresentation createUser(String username, String email, String password, String firstName, String lastName, Map<String, List<String>> attributes, List<String> roles) throws WebApplicationException, ServerException {
        UserRepresentation newUser = new UserRepresentation();
        newUser.setEnabled(Boolean.valueOf(true));
        newUser.setUsername(username);
        newUser.setFirstName(firstName);
        newUser.setLastName(lastName);
        newUser.setEmail(email);
        if (attributes != null) {
            newUser.setAttributes(attributes);
        }
        RealmResource realmResource = KkClientFactory.getSingleton().getKKRealm();
        UsersResource usersRessource = realmResource.users();
        String newUserId = null;
        try {
            newUserId = CreatedResponseUtil.getCreatedId((Response)usersRessource.create(newUser));
        }
        catch (WebApplicationException e) {
            logger.error("error creating user {} - {}", (Object)newUser, (Object)e.getMessage());
            e.printStackTrace();
            throw new WebApplicationException(e.getMessage());
        }
        logger.info("created user {}", (Object)newUser);
        CredentialRepresentation passwordCred = new CredentialRepresentation();
        passwordCred.setTemporary(Boolean.valueOf(false));
        passwordCred.setType("password");
        passwordCred.setValue(password);
        UserResource userResource = usersRessource.get(newUserId);
        userResource.resetPassword(passwordCred);
        RoleRepresentation testerRealmRole = realmResource.roles().get("tester").toRepresentation();
        userResource.roles().realmLevel().add(Arrays.asList(testerRealmRole));
        ClientResource client = KkClientFactory.getSingleton().getKKClient();
        if (roles != null) {
            ArrayList listRolesRepr = new ArrayList();
            roles.forEach(role -> {
                boolean bl = listRolesRepr.add(client.roles().get(role).toRepresentation());
            });
        }
        return userResource.toRepresentation();
    }

    public static ClientRepresentation createClient(String id, String clientId, String name, String description, String rootUrl, String adminUrl, String baseUrl, Boolean surrogateAuthRequired, Boolean enabled, Boolean alwaysDisplayInConsole, String clientAuthenticatorType, String secret, String registrationAccessToken, List<String> redirectUris, List<String> webOrigins, Integer notBefore, Boolean bearerOnly, Boolean consentRequired, Boolean standardFlowEnabled, Boolean implicitFlowEnabled, Boolean directAccessGrantsEnabled, Boolean serviceAccountsEnabled, Boolean authorizationServicesEnabled, Boolean publicClient, Boolean frontchannelLogout, String protocol, Map<String, String> attributes, Map<String, String> authenticationFlowBindingOverrides, Boolean fullScopeAllowed, Integer nodeReRegistrationTimeout, Map<String, Integer> registeredNodes, List<ProtocolMapperRepresentation> protocolMappers, List<String> defaultClientScopes, List<String> optionalClientScopes, String origin) {
        ClientRepresentation newClient = new ClientRepresentation();
        newClient.setId(id);
        newClient.setClientId(clientId);
        newClient.setName(name);
        newClient.setDescription(description);
        newClient.setRootUrl(rootUrl);
        newClient.setAdminUrl(adminUrl);
        newClient.setBaseUrl(baseUrl);
        newClient.setSurrogateAuthRequired(surrogateAuthRequired);
        newClient.setEnabled(enabled);
        newClient.setAlwaysDisplayInConsole(alwaysDisplayInConsole);
        newClient.setClientAuthenticatorType(clientAuthenticatorType);
        newClient.setSecret(secret);
        newClient.setRegistrationAccessToken(registrationAccessToken);
        newClient.setRedirectUris(redirectUris);
        newClient.setWebOrigins(webOrigins);
        newClient.setNotBefore(notBefore);
        newClient.setConsentRequired(consentRequired);
        newClient.setStandardFlowEnabled(standardFlowEnabled);
        newClient.setImplicitFlowEnabled(implicitFlowEnabled);
        newClient.setDirectAccessGrantsEnabled(directAccessGrantsEnabled);
        newClient.setServiceAccountsEnabled(serviceAccountsEnabled);
        newClient.setAuthorizationServicesEnabled(authorizationServicesEnabled);
        newClient.setPublicClient(publicClient);
        newClient.setFrontchannelLogout(frontchannelLogout);
        newClient.setProtocol(protocol);
        newClient.setAttributes(attributes);
        newClient.setAuthenticationFlowBindingOverrides(authenticationFlowBindingOverrides);
        newClient.setFullScopeAllowed(fullScopeAllowed);
        newClient.setNodeReRegistrationTimeout(nodeReRegistrationTimeout);
        newClient.setRegisteredNodes(registeredNodes);
        newClient.setProtocolMappers(protocolMappers);
        newClient.setDefaultClientScopes(defaultClientScopes);
        newClient.setOptionalClientScopes(optionalClientScopes);
        newClient.setOrigin(origin);
        return AdminKeycloakController.createClient((ClientRepresentation)newClient);
    }

    public static ClientRepresentation createClient(ClientRepresentation newClient) {
        RealmResource realmResource = KkClientFactory.getSingleton().getKKRealm();
        ClientsResource clientsResource = realmResource.clients();
        String newClientId = null;
        try {
            newClientId = CreatedResponseUtil.getCreatedId((Response)clientsResource.create(newClient));
        }
        catch (WebApplicationException e) {
            logger.error("error creating client {} - {}", (Object)newClient, (Object)e.getMessage());
            e.printStackTrace();
            throw new WebApplicationException(e.getMessage());
        }
        logger.info("created user {}", (Object)newClient);
        ClientResource client = clientsResource.get(newClientId);
        return client.toRepresentation();
    }
}

