/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.idm.common.is;

import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.NotFoundException;
import java.rmi.ServerException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.security.AuthorizedTasks;
import org.gcube.common.security.secrets.Secret;
import org.gcube.idm.common.is.IsServerConfig;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.api.SimpleQuery;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.gcube.smartgears.ContextProvider;
import org.gcube.smartgears.configuration.container.ContainerConfiguration;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.context.container.ContainerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfrastrctureServiceClient {
    private static final Logger logger = LoggerFactory.getLogger(InfrastrctureServiceClient.class);

    public static Secret getSecretForInfrastructure() {
        ApplicationContext ctx = ContextProvider.get();
        ContainerContext container = ctx.container();
        ContainerConfiguration configuration = container.configuration();
        String infra_context = configuration.infrastructure();
        Secret secret = ctx.container().authorizationProvider().getSecretForContext(infra_context);
        return secret;
    }

    public static List<ServiceEndpoint> getEndopintsFromIS(String resource_name, String category, boolean root_service, Secret secret) {
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        if (resource_name != null) {
            query.addCondition("$resource/Profile/Name/text() eq '" + resource_name + "'");
        }
        if (category != null) {
            query.addCondition("$resource/Profile/Category/text() eq '" + category + "'");
        }
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        List endpoints = null;
        try {
            endpoints = root_service ? (List)AuthorizedTasks.executeSafely(() -> InfrastrctureServiceClient.lambda$0(client, (SimpleQuery)query), (Secret)secret) : client.submit((Query)query);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new InternalServerErrorException(e);
        }
        return endpoints;
    }

    public static List<ServiceEndpoint.AccessPoint> getAccessPointsFromIS(String resource_name, String category, String endPointName, boolean is_root_service, Secret secret) {
        List<ServiceEndpoint> resources = InfrastrctureServiceClient.getEndopintsFromIS(resource_name, category, is_root_service, secret);
        if (resources.size() == 0) {
            logger.error("There is no Runtime Resource having name " + resource_name + " and Category " + category + " in this scope.");
            return null;
        }
        ArrayList<ServiceEndpoint.AccessPoint> response = new ArrayList<ServiceEndpoint.AccessPoint>();
        resources.forEach(res -> {
            Stream<ServiceEndpoint.AccessPoint> access_points_res = res.profile().accessPoints().stream();
            if (endPointName == null) {
                access_points_res = access_points_res.filter(ap -> ap.name().equals(endPointName));
            }
            access_points_res.forEach(a -> {
                boolean bl = response.add((ServiceEndpoint.AccessPoint)a);
            });
        });
        return response;
    }

    public static ServiceEndpoint.AccessPoint getFirstAccessPointFromIS(String resource_name, String category, String entryPointName, boolean root_service, Secret secret) {
        List<ServiceEndpoint.AccessPoint> access_points = InfrastrctureServiceClient.getAccessPointsFromIS(resource_name, category, entryPointName, root_service, secret);
        if (access_points == null || access_points.size() == 0) {
            logger.error("Unable to retrieve service endpoint " + entryPointName);
            return null;
        }
        return access_points.get(0);
    }

    public static IsServerConfig serviceConfigFromIS(String resourceName, String category, String endPointName, boolean is_root_service, Secret secret) throws NotFoundException, ServerException {
        logger.info("Starting creating service credentials");
        ServiceEndpoint.AccessPoint accessPoint = InfrastrctureServiceClient.getFirstAccessPointFromIS(resourceName, category, endPointName, is_root_service, secret);
        if (accessPoint == null) {
            String error_log = "Unable to retrieve service endpoint " + endPointName;
            logger.error(error_log);
            throw new NotFoundException(error_log);
        }
        try {
            IsServerConfig config = new IsServerConfig(accessPoint);
            return config;
        }
        catch (Exception e) {
            logger.error("cannot create server config from {}", (Object)accessPoint);
            e.printStackTrace();
            throw new ServerException(e.getMessage());
        }
    }

    private static /* synthetic */ List lambda$0(DiscoveryClient discoveryClient, SimpleQuery simpleQuery) throws Exception {
        List toReturn = discoveryClient.submit((Query)simpleQuery);
        return toReturn;
    }
}

