/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.idm.client;

import jakarta.ws.rs.InternalServerErrorException;
import java.rmi.ServerException;
import org.gcube.common.security.secrets.Secret;
import org.gcube.idm.client.DefaultMeClient;
import org.gcube.idm.client.DefaultUsersClient;
import org.gcube.idm.client.IdmMeClient;
import org.gcube.idm.client.IdmUsersClient;
import org.gcube.idm.common.is.InfrastrctureServiceClient;
import org.gcube.idm.common.is.IsServerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdmClientFactory {
    private static final String RUNTIME_RESOURCE_NAME = "identity-manager";
    private static final String CATEGORY = "org.gcube.auth";
    private static final String END_POINT_NAME = "d4science";
    private static final boolean IS_ROOT_SERVICE = true;
    protected static final Logger logger = LoggerFactory.getLogger(IdmClientFactory.class);
    private IsServerConfig config;
    private Secret secret;
    private static IdmClientFactory singleton = new IdmClientFactory();

    public static IdmClientFactory getSingleton() {
        if (singleton == null) {
            singleton = new IdmClientFactory();
        }
        return singleton;
    }

    public Secret getSecret() {
        return this.secret;
    }

    public void setSecret(Secret secret) {
        this.secret = secret;
        this.setConfig(null);
    }

    public void setConfig(IsServerConfig config) {
        this.config = config;
    }

    public IsServerConfig fetchIsConfig() throws InternalServerErrorException {
        if (this.secret == null) {
            String error_message = "secret is null. invoke setSecret(secret) before fetching the configuration. ";
            throw new InternalServerErrorException(error_message);
        }
        if (this.config == null) {
            this.config = this.fetchIsConfig(this.secret);
        }
        return this.fetchIsConfig(this.secret);
    }

    public IsServerConfig fetchIsConfig(Secret secret) throws InternalServerErrorException {
        try {
            IsServerConfig cfg = InfrastrctureServiceClient.serviceConfigFromIS((String)RUNTIME_RESOURCE_NAME, (String)CATEGORY, (String)END_POINT_NAME, (boolean)true, (Secret)secret);
            return cfg;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    public IdmMeClient meClient(String auth_token) throws ServerException {
        logger.debug("Instantiating a new IdmClient instance");
        logger.info("Building KeycloakAPICredentials object");
        try {
            if (this.config == null) {
                this.config = this.fetchIsConfig();
            }
            logger.info("KeycloakAPICredentials object built {} - {}", (Object)this.config.getServerUrl(), (Object)this.config.getName());
        }
        catch (Exception e) {
            logger.error("error obtaining IAM configuration from IS {} ", (Throwable)e);
            throw new ServerException(e.getMessage(), e);
        }
        String url = null;
        try {
            url = this.config.getServerUrl();
            return new DefaultMeClient(url, auth_token);
        }
        catch (Exception e) {
            logger.error("cannot create idm client with url ", (Object)url);
            e.printStackTrace();
            throw new ServerException(e.getMessage(), e);
        }
    }

    public IdmUsersClient userClient(String auth_token) throws ServerException {
        logger.debug("Instantiating a new IdmClient instance");
        logger.info("Building KeycloakAPICredentials object");
        try {
            if (this.config == null) {
                this.config = this.fetchIsConfig();
            }
            logger.info("KeycloakAPICredentials object built {} - {}", (Object)this.config.getServerUrl(), (Object)this.config.getName());
        }
        catch (Exception e) {
            logger.error("error obtaining IAM configuration from IS {} ", (Throwable)e);
            throw new ServerException(e.getMessage(), e);
        }
        String url = null;
        try {
            url = this.config.getServerUrl();
            return new DefaultUsersClient(url, auth_token);
        }
        catch (Exception e) {
            logger.error("cannot create idm client with url ", (Object)url);
            e.printStackTrace();
            throw new ServerException(e.getMessage(), e);
        }
    }
}

