/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.keycloak.oidc.avatar.importer.libravatar;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.gcube.keycloak.oidc.avatar.importer.libravatar.DNSUtil;
import org.gcube.keycloak.oidc.avatar.importer.libravatar.LibravatarException;
import org.gcube.keycloak.oidc.avatar.importer.libravatar.LibravatarOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Libravatar {
    protected static final Logger logger = LoggerFactory.getLogger(Libravatar.class);
    private String email;
    private LibravatarOptions options = new LibravatarOptions().withoutHttps();

    private Libravatar(String email) {
        ((String)Preconditions.checkNotNull((Object)email)).toLowerCase();
        this.email = email;
    }

    public static Libravatar from(String email) {
        return new Libravatar(email);
    }

    public Libravatar withOptions(LibravatarOptions options) {
        this.options = options;
        return this;
    }

    public byte[] downloadArray() throws LibravatarException {
        byte[] byArray;
        block8: {
            InputStream is = this.download();
            try {
                byArray = IOUtils.toByteArray((InputStream)is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new LibravatarException("Cannot download image byte's array for email: " + this.email, e);
                }
            }
            is.close();
        }
        return byArray;
    }

    public InputStream download() throws LibravatarException {
        try {
            return this.getURL().openStream();
        }
        catch (IOException e) {
            throw new LibravatarException("Cannot open image stream for email: " + this.email, e);
        }
    }

    private URL getURL() throws MalformedURLException {
        String baseTarget;
        logger.debug("Constructing download URL for email: {}", (Object)this.email);
        logger.debug("Getting the DNS queries domain first");
        String string = baseTarget = this.options.isUseHttps() ? DNSUtil.resolveSecureSRVRecordFromEmail(this.email) : DNSUtil.resolveSRVRecordFromEmail(this.email);
        if (baseTarget != null) {
            logger.debug("Building URL with the DNS queried domain");
            return this.buildURL(baseTarget);
        }
        logger.debug("Defaulting to the liravatar URL");
        return this.buildURL(this.options.isUseHttps() ? LibravatarOptions.getSecureBaseUri() : LibravatarOptions.getBaseUri());
    }

    private URL buildURL(String baseURL) throws MalformedURLException {
        StringBuilder sb = new StringBuilder(baseURL);
        String hash = this.options.isUseSHA256() ? DigestUtils.sha256Hex((byte[])this.email.getBytes()) : DigestUtils.md5Hex((byte[])this.email.getBytes());
        logger.trace("Computed hash is: {}", (Object)hash);
        sb.append(hash);
        Map<String, String> parametersMap = this.options.toParametersMap();
        String queryString = parametersMap.entrySet().stream().map(p -> (String)p.getKey() + "=" + (String)p.getValue()).reduce((p1, p2) -> p1 + "&" + p2).orElse("");
        if (queryString != null && !"".equals(queryString)) {
            sb.append("?");
            sb.append(queryString);
        }
        String url = sb.toString();
        logger.trace("Resulting URL string is: {}", (Object)url);
        return new URL(url);
    }
}

