/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.workflow.adaptor.utils.jdl;

import gr.uoa.di.madgik.environment.is.elements.matching.MatchParser;
import gr.uoa.di.madgik.execution.plan.PlanConfig;
import gr.uoa.di.madgik.execution.utils.EnvironmentKeyValue;
import gr.uoa.di.madgik.workflow.adaptor.utils.IParsedInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ParsedJDLInfo
implements IParsedInfo {
    public static long DefaultRetryInterval = 10000L;
    public static int DefaultConcurrentRunningJobs = 10;
    public JobDescriptionType jobDescriptionType = JobDescriptionType.Job;
    public JobType jobType = JobType.Normal;
    public String Executable = null;
    public String Arguments = null;
    public String Input = null;
    public String Output = null;
    public String Error = null;
    public List<String> InSandbox = new ArrayList<String>();
    public List<String> OutSandbox = new ArrayList<String>();
    public List<EnvironmentKeyValue> Environment = new ArrayList<EnvironmentKeyValue>();
    public int RetryCount = 0;
    public long RetryInterval = 0L;
    public String Rank = null;
    public String Requirements = null;
    public boolean NodesCollocation = false;
    public Map<String, ParsedJDLInfo> Nodes = new HashMap<String, ParsedJDLInfo>();
    public Map<String, List<String>> Dependencies = new HashMap<String, List<String>>();
    public int MaxRunningNodes = 0;
    public ParsingModeType ModeOfParsing = ParsingModeType.Bag;
    public PlanConfig.ConnectionMode ModeOfConnection = PlanConfig.ConnectionMode.Callback;
    private String CommonRequirements = null;
    private Map<String, String> ExtraRequirements = new HashMap<String, String>();

    public void SetConnectionMode(String mode) {
        if (mode == null) {
            return;
        }
        this.ModeOfConnection = PlanConfig.ConnectionMode.valueOf((String)mode);
    }

    public void SetParsingMode(String mode) {
        if (mode == null) {
            return;
        }
        this.ModeOfParsing = ParsingModeType.valueOf(mode);
    }

    public void SetMaxRunningNodes(String number) {
        int c;
        if (number == null) {
            return;
        }
        this.MaxRunningNodes = c = Integer.parseInt(number);
    }

    public void SetRetryCount(String counter) {
        if (counter == null) {
            return;
        }
        int c = Integer.parseInt(counter);
        if (c > this.RetryCount) {
            this.RetryCount = c;
        }
    }

    public void SetRetryInterval(String interval) {
        if (interval == null) {
            return;
        }
        long c = Long.parseLong(interval);
        if (c > this.RetryInterval) {
            this.RetryInterval = c;
        }
    }

    public void SetNodesCollocation(String collocation) {
        if (collocation == null) {
            return;
        }
        this.NodesCollocation = Boolean.parseBoolean(collocation);
    }

    public String GetCommonRequirements() {
        if (this.CommonRequirements != null) {
            return this.CommonRequirements;
        }
        HashSet commonRequirements = new HashSet();
        boolean initial = true;
        if (this.Nodes.isEmpty()) {
            return this.Requirements;
        }
        HashMap reqs = new HashMap();
        for (Map.Entry<String, ParsedJDLInfo> nodeRequirements : this.Nodes.entrySet()) {
            HashSet<String> nodeReqs = new HashSet<String>();
            MatchParser parser = new MatchParser(this.Nodes.get((Object)nodeRequirements.getKey()).Requirements);
            for (Map.Entry parsedReq : parser.requirments.entrySet()) {
                nodeReqs.add(MatchParser.toRequirement((String)((String)parsedReq.getKey()), (String)((String)parsedReq.getValue())));
            }
            if (initial) {
                commonRequirements.addAll(nodeReqs);
                initial = false;
                continue;
            }
            commonRequirements.retainAll(nodeReqs);
        }
        this.CommonRequirements = MatchParser.toRequirements(commonRequirements);
        return this.CommonRequirements;
    }

    public String GetExtraRequirements(String nodeName) {
        if (this.ExtraRequirements.containsKey(nodeName)) {
            return this.ExtraRequirements.get(nodeName);
        }
        String cr = this.GetCommonRequirements();
        MatchParser parser = new MatchParser(cr);
        ParsedJDLInfo nodeInfo = this.Nodes.get(nodeName);
        MatchParser nodeParser = new MatchParser(nodeInfo.Requirements);
        HashSet<String> commonRequirements = new HashSet<String>();
        HashSet<String> nodeRequirements = new HashSet<String>();
        for (Map.Entry commonReq : parser.requirments.entrySet()) {
            commonRequirements.add(MatchParser.toRequirement((String)((String)commonReq.getKey()), (String)((String)commonReq.getValue())));
        }
        for (Map.Entry nodeReq : nodeParser.requirments.entrySet()) {
            nodeRequirements.add(MatchParser.toRequirement((String)((String)nodeReq.getKey()), (String)((String)nodeReq.getValue())));
        }
        nodeRequirements.removeAll(commonRequirements);
        this.ExtraRequirements.put(nodeName, MatchParser.toRequirements(nodeRequirements));
        return this.ExtraRequirements.get(nodeName);
    }

    public String ToXML() {
        StringBuilder buf = new StringBuilder();
        buf.append("<Type value=\"" + (Object)((Object)this.jobDescriptionType) + "\"/>");
        buf.append("<JobType value=\"" + (Object)((Object)this.jobType) + "\"/>");
        if (this.Executable != null) {
            buf.append("<Executable value=\"" + this.Executable + "\"/>");
        }
        if (this.Arguments != null) {
            buf.append("<Arguments value=\"" + this.Arguments + "\"/>");
        }
        if (this.Input != null) {
            buf.append("<Input value=\"" + this.Input + "\"/>");
        }
        if (this.Output != null) {
            buf.append("<Output value=\"" + this.Output + "\"/>");
        }
        if (this.Error != null) {
            buf.append("<Error value=\"" + this.Error + "\"/>");
        }
        if (this.InSandbox.size() > 0) {
            buf.append("<InSandbox>");
            for (String string : this.InSandbox) {
                buf.append("<entry>" + string + "</entry>");
            }
            buf.append("</InSandbox>");
        }
        if (this.OutSandbox.size() > 0) {
            buf.append("<OutSandbox>");
            for (String string : this.OutSandbox) {
                buf.append("<entry>" + string + "</entry>");
            }
            buf.append("</OutSandbox>");
        }
        if (this.Environment.size() > 0) {
            buf.append("<Environment>");
            for (EnvironmentKeyValue environmentKeyValue : this.Environment) {
                buf.append("<entry><key>" + environmentKeyValue.Key + "</key><value>" + environmentKeyValue.Value + "</value></entry>");
            }
            buf.append("</Environment>");
        }
        if (this.Rank != null) {
            buf.append("<Rank>" + this.Rank + "</Rank>");
        }
        if (this.Requirements != null) {
            buf.append("<Requirements>" + this.Requirements + "</Requirements>");
        }
        if (this.RetryCount > 0) {
            buf.append("<RetryCount value=\"" + this.RetryCount + "\"/>");
        }
        if (this.NodesCollocation) {
            buf.append("<NodesCollocation value=\"" + this.NodesCollocation + "\"/>");
        }
        if (this.jobDescriptionType == JobDescriptionType.DAG) {
            buf.append("<ParsingMode value=\"" + this.ModeOfParsing.toString() + "\"/>");
            buf.append("<MaxRunningJobs value=\"" + this.MaxRunningNodes + "\"/>");
            buf.append("<Nodes>");
            for (Map.Entry entry : this.Nodes.entrySet()) {
                buf.append("<node name=\"" + (String)entry.getKey() + "\">" + ((ParsedJDLInfo)entry.getValue()).ToXML() + "</node>");
            }
            buf.append("</Nodes>");
            buf.append("<Dependencies>");
            for (Map.Entry entry : this.Dependencies.entrySet()) {
                buf.append("<dep node=\"" + (String)entry.getKey() + "\">");
                for (String waitFor : (List)entry.getValue()) {
                    buf.append("<waitFor node=\"" + waitFor + "\"/>");
                }
                buf.append("</dep>");
            }
            buf.append("</Dependencies>");
        }
        return buf.toString();
    }

    public static enum JobType {
        Normal,
        Interactive,
        MPICH,
        Checkpointable,
        Partitionable,
        WS;

    }

    public static enum JobDescriptionType {
        Job,
        DAG;

    }

    public static enum ParsingModeType {
        Bag,
        Plan;

    }

    public static enum KnownKeys {
        Type,
        JobType,
        Executable,
        Arguments,
        StdInput,
        StdOutput,
        StdError,
        InputSandbox,
        OutputSandbox,
        Environment,
        RetryCount,
        RetryInterval,
        ShallowRetryCount,
        NodesCollocation,
        Rank,
        Requirements,
        Nodes,
        Dependencies,
        Description,
        Max_Running_Nodes,
        ParsingMode,
        ConnectionMode;

    }
}

