/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.workflow.plot.ws;

import gr.uoa.di.madgik.commons.channel.proxy.local.LocalNozzleConfig;
import gr.uoa.di.madgik.commons.channel.proxy.tcp.TCPServerNozzleConfig;
import gr.uoa.di.madgik.environment.is.elements.InvocablePlotInfo;
import gr.uoa.di.madgik.environment.is.elements.InvocableProfileInfo;
import gr.uoa.di.madgik.environment.is.elements.invocable.WSInvocableProfileInfo;
import gr.uoa.di.madgik.environment.is.elements.invocable.WSMethod;
import gr.uoa.di.madgik.environment.is.elements.plot.PlotMethod;
import gr.uoa.di.madgik.environment.is.elements.plot.WSPlotInfo;
import gr.uoa.di.madgik.execution.plan.element.IPlanElement;
import gr.uoa.di.madgik.execution.plan.element.WSSOAPPlanElement;
import gr.uoa.di.madgik.execution.plan.element.filter.ParameterFilterBase;
import gr.uoa.di.madgik.execution.plan.element.filter.ParameterSerializationFilter;
import gr.uoa.di.madgik.execution.plan.element.invocable.CallBase;
import gr.uoa.di.madgik.execution.plan.element.invocable.ExecutionContextConfigBase;
import gr.uoa.di.madgik.execution.plan.element.invocable.ws.WSExecutionContextConfig;
import gr.uoa.di.madgik.execution.plan.element.invocable.ws.WSSOAPArgument;
import gr.uoa.di.madgik.execution.plan.element.invocable.ws.WSSOAPCall;
import gr.uoa.di.madgik.execution.plan.element.variable.IOutputParameter;
import gr.uoa.di.madgik.workflow.exception.WorkflowEnvironmentException;
import gr.uoa.di.madgik.workflow.exception.WorkflowProcessException;
import gr.uoa.di.madgik.workflow.exception.WorkflowValidationException;
import gr.uoa.di.madgik.workflow.plot.PlotInstanceBase;
import gr.uoa.di.madgik.workflow.plot.commons.IPlotResourceInCollection;
import gr.uoa.di.madgik.workflow.plot.commons.IPlotResourceOutCollection;
import gr.uoa.di.madgik.workflow.plot.ws.WSPlotResourceMethodOutput;
import gr.uoa.di.madgik.workflow.plot.ws.WSPlotResourceParameterInCollection;
import gr.uoa.di.madgik.workflow.plot.ws.WSPlotResourceParameterOutCollection;
import java.util.ArrayList;
import java.util.List;

public class WSPlotInstance
extends PlotInstanceBase {
    private WSInvocableProfileInfo InvocableInfo = null;
    private WSPlotInfo PlotInfo = null;
    private WSPlotResourceParameterInCollection PlotInputParameters = null;
    private WSPlotResourceParameterOutCollection PlotOutputParameters = null;
    private WSSOAPPlanElement Element = null;

    @Override
    public IPlanElement GetElement() {
        return this.Element;
    }

    @Override
    public InvocableProfileInfo GetInvocableProfile() {
        return this.InvocableInfo;
    }

    @Override
    public void SetInvocableProfile(InvocableProfileInfo invocable) throws WorkflowValidationException {
        if (!(invocable instanceof WSInvocableProfileInfo)) {
            throw new WorkflowValidationException("Incompatible type provided");
        }
        this.InvocableInfo = (WSInvocableProfileInfo)invocable;
        this.SetName(this.InvocableInfo.ClassName);
    }

    @Override
    public InvocablePlotInfo GetPlotProfile() {
        return this.PlotInfo;
    }

    @Override
    public void SetPlotProfile(InvocablePlotInfo plot) throws WorkflowValidationException {
        if (!(plot instanceof WSPlotInfo)) {
            throw new WorkflowValidationException("Incompatible type provided");
        }
        this.PlotInfo = (WSPlotInfo)plot;
    }

    @Override
    public IPlotResourceInCollection GetInputParameterCollection() {
        return this.PlotInputParameters;
    }

    @Override
    public void SetInputParameterCollection(IPlotResourceInCollection parameters) throws WorkflowValidationException {
        if (!(parameters instanceof WSPlotResourceParameterInCollection)) {
            throw new WorkflowValidationException("Incompatible type provided");
        }
        this.PlotInputParameters = (WSPlotResourceParameterInCollection)parameters;
    }

    @Override
    public IPlotResourceOutCollection GetOutputParameterCollection() {
        return this.PlotOutputParameters;
    }

    @Override
    public void SetOutputParameterCollection(IPlotResourceOutCollection parameters) throws WorkflowValidationException {
        if (!(parameters instanceof WSPlotResourceParameterOutCollection)) {
            throw new WorkflowValidationException("Incompatible type provided");
        }
        this.PlotOutputParameters = (WSPlotResourceParameterOutCollection)parameters;
    }

    @Override
    public void Validate() throws WorkflowValidationException {
        if (this.InvocableInfo == null || this.PlotInfo == null) {
            throw new WorkflowValidationException("Plot and/or invocable profile not provided");
        }
        if (this.PlotInputParameters == null) {
            throw new WorkflowValidationException("Plot input parameters not provided");
        }
        if (this.PlotOutputParameters == null) {
            throw new WorkflowValidationException("Plot output parameters not provided");
        }
        if (this.GetLocalEnvironmentFilesParameterCollection() == null) {
            throw new WorkflowValidationException("Plot output parameters not provided");
        }
        this.PlotInputParameters.SetInvocableInfo((InvocableProfileInfo)this.InvocableInfo);
        this.PlotInputParameters.SetPlotInfo((InvocablePlotInfo)this.PlotInfo);
        this.PlotInputParameters.Validate();
        this.PlotOutputParameters.SetInvocableInfo((InvocableProfileInfo)this.InvocableInfo);
        this.PlotOutputParameters.SetPlotInfo((InvocablePlotInfo)this.PlotInfo);
        this.PlotOutputParameters.Validate();
        this.GetLocalEnvironmentFilesParameterCollection().SetInvocableInfo((InvocableProfileInfo)this.InvocableInfo);
        this.GetLocalEnvironmentFilesParameterCollection().SetPlotInfo((InvocablePlotInfo)this.PlotInfo);
        this.GetLocalEnvironmentFilesParameterCollection().Validate();
    }

    @Override
    public void Process() throws WorkflowProcessException, WorkflowEnvironmentException {
        this.Element = new WSSOAPPlanElement();
        this.Element.SetName(this.GetName());
        this.Element.ServiceEndPoint = this.PlotInputParameters.GetEndPoint().ServiceEndpoint;
        this.Element.ExecutionContextConfig = this.GetExecutionContext();
        this.Element.SupportsExecutionContext = this.Element.ExecutionContextConfig != null;
        this.Element.Triggers = this.GetContingencyTriggers((InvocablePlotInfo)this.PlotInfo);
        this.Element.Calls = this.GetCalls(this.Element.SupportsExecutionContext);
        this.PopulatePrePostElements((InvocablePlotInfo)this.PlotInfo);
    }

    private List<CallBase> GetCalls(boolean SupportsContext) throws WorkflowProcessException {
        ArrayList<CallBase> calls = new ArrayList<CallBase>();
        for (PlotMethod m : this.PlotInfo.Methods) {
            WSSOAPCall c = new WSSOAPCall();
            calls.add((CallBase)c);
            c.Order = m.Order;
            c.MethodName = this.InvocableInfo.Get((String)m.Signature).Name;
            c.ActionURN = this.InvocableInfo.Get((String)m.Signature).MethodURN;
            c.ArgumentList.add(this.GetArgument(m));
            c.OutputParameter = this.GetOutputParameter(m);
            if (!SupportsContext) continue;
            c.ExecutionContextToken = this.InvocableInfo.Get((String)m.Signature).ExecutioContextToken;
            if (c.ExecutionContextToken == null || c.ExecutionContextToken.trim().length() == 0) {
                throw new WorkflowProcessException("Decllared needed execution context but no token provided");
            }
            c.PostCreationFilters.add(new ParameterSerializationFilter());
            ((ParameterFilterBase)c.PostCreationFilters.get((int)0)).Order = 0;
        }
        return calls;
    }

    private WSSOAPArgument GetArgument(PlotMethod mplot) throws WorkflowProcessException {
        WSSOAPArgument arg = new WSSOAPArgument();
        arg.ArgumentName = "full envelope";
        arg.Order = 0;
        arg.Parameter = this.PlotInputParameters.GetMethodInput((int)mplot.Order).Input;
        return arg;
    }

    private IOutputParameter GetOutputParameter(PlotMethod mplot) throws WorkflowProcessException {
        if (mplot.IsConstructor) {
            return null;
        }
        if (!mplot.UseReturnValue) {
            return null;
        }
        WSMethod mprof = this.InvocableInfo.Get(mplot.Signature);
        if (mprof.ReturnValue == null) {
            throw new WorkflowProcessException("Did not find needed output parameter for method that is marked as returning plot needed value");
        }
        WSPlotResourceMethodOutput param = this.PlotOutputParameters.Get(mplot.Order);
        if (param == null) {
            throw new WorkflowProcessException("Did not find needed output parameter for method that is marked as returning plot needed value");
        }
        return param.Output;
    }

    private WSExecutionContextConfig GetExecutionContext() throws WorkflowEnvironmentException {
        if (!this.InvocableInfo.ExecutionContext.Supported) {
            return null;
        }
        WSExecutionContextConfig cc = new WSExecutionContextConfig();
        cc.KeepContextAlive = this.InvocableInfo.ExecutionContext.KeepAlive;
        if (this.InvocableInfo.ExecutionContext.ProxygRS.SupplyProxy) {
            cc.ProxyType = this.GetContextProxyType();
            if (cc.ProxyType.equals((Object)ExecutionContextConfigBase.ContextProxyType.None)) {
                throw new WorkflowEnvironmentException("Retrieved unrecognized proxy type");
            }
        }
        if (this.InvocableInfo.ExecutionContext.ReportsProgress) {
            switch (this.InvocableInfo.ExecutionContext.ProgressProvider) {
                case Local: {
                    cc.NozzleConfig = new LocalNozzleConfig(false, 0);
                    break;
                }
                case TCP: {
                    cc.NozzleConfig = new TCPServerNozzleConfig(false, 0);
                    break;
                }
                default: {
                    throw new WorkflowEnvironmentException("Retrieved unrecognized progress provider type");
                }
            }
        }
        return cc;
    }
}

