/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.workflow.directory;

import gr.uoa.di.madgik.workflow.directory.ExecutionObserver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExecutionDirectory
extends Thread {
    private static Logger logger = Logger.getLogger(ExecutionDirectory.class.getName());
    private static ExecutionDirectory CleanUpInstance = null;
    private static final Object lockMe = new Object();
    private static final long DefaultCleanupPeriod = 21600000L;
    private static long CleanUpPeriod = 21600000L;
    private static final Map<String, ExecutionObserver> Directory;

    public static void SetCleanupPeriod(long Period) {
        CleanUpPeriod = Period <= 0L ? 21600000L : Period;
    }

    public static String ReserveKey() {
        return UUID.randomUUID().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean Register(ExecutionObserver observer) {
        if (observer.GetExecutionID() == null || observer.GetExecutionID().trim().length() == 0) {
            return false;
        }
        Object object = lockMe;
        synchronized (object) {
            Directory.put(observer.GetExecutionID(), observer);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExecutionObserver Retrieve(String ExecutionID) {
        Object object = lockMe;
        synchronized (object) {
            return Directory.get(ExecutionID);
        }
    }

    public ExecutionDirectory() {
        this.setName(ExecutionDirectory.class.getName());
        this.setDaemon(true);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block7: while (true) {
            try {
                while (true) {
                    ArrayList<String> ids = new ArrayList<String>();
                    Object object = lockMe;
                    synchronized (object) {
                        for (Map.Entry<String, ExecutionObserver> entry : Directory.entrySet()) {
                            if (!entry.getValue().IsCompleted()) continue;
                            ids.add(entry.getKey());
                        }
                    }
                    ArrayList<String> cleanup = new ArrayList<String>();
                    for (String k : ids) {
                        ExecutionObserver obs = ExecutionDirectory.Retrieve(k);
                        if (obs == null) continue;
                        if (obs.ShouldCleanup()) {
                            cleanup.add(k);
                        }
                        if (obs.HasPerformedStorageSystermCleanup()) continue;
                        obs.PerformedStorageSystermCleanup();
                    }
                    for (String k : cleanup) {
                        ExecutionDirectory.Cleanup(k);
                    }
                    ids.clear();
                    cleanup.clear();
                    try {
                        Thread.sleep(CleanUpPeriod);
                        continue block7;
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception ex) {
                if (!logger.isLoggable(Level.WARNING)) continue;
                logger.log(Level.WARNING, "Could not complete Execution directory cleanup check iteration", ex);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void Cleanup(String ExecutionID) {
        if (Directory.containsKey(ExecutionID)) {
            block6: {
                try {
                    ExecutionDirectory.Retrieve(ExecutionID).Cleanup();
                }
                catch (Exception ex) {
                    if (!logger.isLoggable(Level.WARNING)) break block6;
                    logger.log(Level.WARNING, "Could not cleanup Execution observer. Proceeding to remove", ex);
                }
            }
            Object object = lockMe;
            synchronized (object) {
                Directory.remove(ExecutionID);
            }
        }
    }

    static {
        if (CleanUpInstance == null) {
            CleanUpInstance = new ExecutionDirectory();
        }
        Directory = new HashMap<String, ExecutionObserver>();
    }

    public static enum DirectoryEntryType {
        JDL,
        Grid,
        Condor,
        Hadoop,
        Generic;

    }
}

