/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.urlresolutionlibrary.streamable;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import gr.uoa.di.madgik.urlresolutionlibrary.exceptions.ParseException;
import gr.uoa.di.madgik.urlresolutionlibrary.streamable.Streamable;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SFTPLocator
implements Streamable {
    private static Logger logger = Logger.getLogger(SFTPLocator.class.getName());
    public static final String SFTP_PROTOCOL = "sftp";
    private static final String ANONYMOUS_USERNAME = "anonymous";
    private static final String ANONYMOUS_PASSWORD = "";
    private static final int DEFAULT_SFTP_PORT = 22;
    private static final String KNOWN_HOSTS_FILE_VAR = "KNOWN_HOSTS_FILE_VAR";
    private int port = 22;
    private String username = "anonymous";
    private String password = "";
    private String host;
    private String path;
    private String knownHostsFile = this.getKnownHostsFileName();
    private JSch jsch = null;
    private Session session = null;
    private ChannelSftp sftpChannel = null;

    public SFTPLocator(String url) throws ParseException {
        this.parseURI(url);
    }

    private String getKnownHostsFileName() throws ParseException {
        String knownHostsFile = System.getenv(KNOWN_HOSTS_FILE_VAR);
        if (knownHostsFile == null) {
            throw new ParseException("Known hosts file variable not found. Please specify : KNOWN_HOSTS_FILE_VAR enviroment variable");
        }
        return knownHostsFile;
    }

    private void parseURI(String url) throws ParseException {
        String[] parts;
        String tmpUrl = url.trim();
        if (!tmpUrl.startsWith("sftp://")) {
            throw new ParseException("uri is not in ftp(s) format");
        }
        if ((tmpUrl = tmpUrl.substring("sftp://".length())).contains("@")) {
            int atIdx = tmpUrl.lastIndexOf(64);
            if (atIdx >= tmpUrl.length()) {
                throw new ParseException("uri has not username and password");
            }
            String credentials = tmpUrl.substring(0, atIdx);
            String hostpath = tmpUrl.substring(atIdx + 1, tmpUrl.length());
            String[] parts2 = credentials.split(":");
            if (parts2 == null || parts2.length != 2) {
                throw new ParseException("uri has not username and password");
            }
            this.username = parts2[0];
            this.password = parts2[1];
            tmpUrl = hostpath;
        }
        if ((parts = tmpUrl.split("/", 2))[0].contains(":")) {
            String[] parts1 = parts[0].split(":");
            this.host = parts1[0];
            this.port = Integer.parseInt(parts1[1]);
        } else {
            this.host = parts[0];
        }
        if (parts.length == 2) {
            this.path = parts[1];
        }
        logger.log(Level.INFO, "Parsing results for : " + url);
        logger.log(Level.INFO, "Host \t : " + this.host);
        logger.log(Level.INFO, "Port \t : " + this.port);
        logger.log(Level.INFO, "Username : " + this.username);
        logger.log(Level.INFO, "Password : " + this.password);
        logger.log(Level.INFO, "Path \t : " + this.path);
    }

    @Override
    public InputStream getInputStream() throws Exception {
        this.jsch = new JSch();
        this.jsch.setKnownHosts(this.knownHostsFile);
        this.session = this.jsch.getSession(this.username, this.host, this.port);
        this.session.setPassword(this.password);
        this.session.connect();
        Channel channel = this.session.openChannel(SFTP_PROTOCOL);
        channel.connect();
        this.sftpChannel = (ChannelSftp)channel;
        InputStream is = this.sftpChannel.get(this.path);
        return is;
    }

    @Override
    public void close() {
        try {
            this.sftpChannel.exit();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "SFTP Locator inputstream close failed", e);
        }
        this.session.disconnect();
    }
}

