/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.urlresolutionlibrary.nonstreamable;

import gr.uoa.di.madgik.urlresolutionlibrary.ResolveFactory;
import gr.uoa.di.madgik.urlresolutionlibrary.exceptions.ParseException;
import gr.uoa.di.madgik.urlresolutionlibrary.nonstreamable.NonStreamable;
import gr.uoa.di.madgik.urlresolutionlibrary.streamable.Streamable;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bitlet.wetorrent.Metafile;
import org.bitlet.wetorrent.Torrent;
import org.bitlet.wetorrent.disk.PlainFileSystemTorrentDisk;
import org.bitlet.wetorrent.disk.TorrentDisk;
import org.bitlet.wetorrent.peer.IncomingPeerListener;

public class BittorrentLocator
implements NonStreamable {
    private static Logger logger = Logger.getLogger(BittorrentLocator.class.getName());
    public static final String BITTORRENT_PROTOCOL = "bittorrent";
    private static final int DEFAULT_BITTORENT_PORT = 6881;
    private int port = 6881;
    private String torrentUrl;
    private Torrent torrent;
    private IncomingPeerListener peerListener;
    private String filename;
    private String tempDir;

    public BittorrentLocator(String url) throws ParseException {
        this.parseURI(url);
    }

    private void parseURI(String url) throws ParseException {
        String tmpUri = url.trim();
        if (!tmpUri.startsWith("bittorrent://")) {
            throw new ParseException("url is not in bittorrent format");
        }
        int listIdx = (tmpUri = tmpUri.substring("bittorrent://".length())).lastIndexOf(91);
        if (listIdx > 0) {
            this.torrentUrl = tmpUri.substring(0, listIdx);
            this.filename = tmpUri.substring(listIdx + 1, tmpUri.length() - 1);
        } else {
            this.torrentUrl = tmpUri;
        }
        logger.log(Level.INFO, "TorrentUrl : " + this.torrentUrl);
        logger.log(Level.INFO, "File : " + this.filename);
    }

    public void init() throws Exception {
        Streamable locator = ResolveFactory.getStreamableLocator(this.torrentUrl);
        Metafile metafile = new Metafile((InputStream)new BufferedInputStream(locator.getInputStream()));
        locator.close();
        File tempDir = File.createTempFile("torrent-", "-downloads");
        if (!tempDir.delete()) {
            throw new IOException("Could not delete temp file: " + tempDir.getAbsolutePath());
        }
        if (!tempDir.mkdir()) {
            throw new IOException("Could not create temp directory: " + tempDir.getAbsolutePath());
        }
        PlainFileSystemTorrentDisk tdisk = new PlainFileSystemTorrentDisk(metafile, tempDir);
        tdisk.init();
        this.peerListener = new IncomingPeerListener(this.port);
        this.peerListener.start();
        this.torrent = new Torrent(metafile, (TorrentDisk)tdisk, this.peerListener);
        this.filename = this.filename == null ? tempDir.getAbsolutePath() + "/" + metafile.getName() : tempDir.getAbsolutePath() + "/" + metafile.getName() + "/" + this.filename;
        this.tempDir = tempDir.getAbsolutePath();
    }

    @Override
    public void download() throws Exception {
        this.init();
        this.torrent.startDownload();
        while (!this.torrent.isCompleted()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ie) {
                break;
            }
            this.torrent.tick();
            logger.log(Level.INFO, "Got " + this.torrent.getPeersManager().getActivePeersNumber() + " peers, completed " + this.torrent.getTorrentDisk().getCompleted() + " bytes");
        }
        this.torrent.interrupt();
        this.peerListener.interrupt();
    }

    @Override
    public File getFile() {
        return new File(this.filename);
    }

    public File getTempDir() {
        return new File(this.tempDir);
    }
}

