/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.urlresolutionlibrary.streamable;

import gr.uoa.di.madgik.urlresolutionlibrary.exceptions.ParseException;
import gr.uoa.di.madgik.urlresolutionlibrary.streamable.Streamable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;

public class HTTPLocator
implements Streamable {
    private static Logger logger = Logger.getLogger(HTTPLocator.class.getName());
    public static final String HTTP_PROTOCOL = "http";
    public static final String HTTPS_PROTOCOL = "https";
    private static final int HTTPS_PORT = 443;
    private static final int HTTP_PORT = 80;
    private static final String NO_PASSWORD = "nopassword";
    private static final String CERTIFICATES_FILE_VAR = "CERTIFICATES_FILE_VAR";
    private boolean isSecure = false;
    private String url;
    private HttpClient httpClient;
    private String certificateFilename;
    private String host;
    private String path = "/";
    private int port = 80;
    private InputStream is;

    public HTTPLocator(String uri) throws ParseException {
        this.url = uri;
        this.parseURL(this.url);
        if (this.isSecure) {
            this.certificateFilename = this.getCertificateFileName();
        }
    }

    private String getCertificateFileName() throws ParseException {
        String certfname = null;
        String certificateMapFile = null;
        certificateMapFile = System.getenv(CERTIFICATES_FILE_VAR);
        if (certificateMapFile == null) {
            throw new ParseException("Certificate Map file variable not found. Please specify : CERTIFICATES_FILE_VAR enviroment variable");
        }
        Properties prop = new Properties();
        FileInputStream in = null;
        try {
            in = new FileInputStream(certificateMapFile);
        }
        catch (FileNotFoundException e1) {
            throw new ParseException("Certificate Map " + certificateMapFile + " file could not be loaded");
        }
        try {
            prop.load(in);
        }
        catch (IOException e) {
            throw new ParseException("Certificate Map " + certificateMapFile + " file could not be loaded");
        }
        try {
            ((InputStream)in).close();
        }
        catch (IOException e) {
            // empty catch block
        }
        certfname = prop.getProperty(this.host);
        return certfname;
    }

    private void parseURL(String url) throws ParseException {
        String[] parts;
        String tmpUri = url.trim();
        if (!tmpUri.startsWith("http://")) {
            if (!tmpUri.startsWith("https://")) {
                throw new ParseException("url is not in http(s) format");
            }
            this.isSecure = true;
            this.port = 443;
        }
        if ((parts = (tmpUri = this.isSecure ? tmpUri.substring("https://".length()) : tmpUri.substring("http://".length())).split("/", 2))[0].contains(":")) {
            String[] parts1 = parts[0].split(":");
            this.host = parts1[0];
            this.port = Integer.parseInt(parts1[1]);
        } else {
            this.host = parts[0];
        }
        if (parts.length == 2) {
            this.path = this.path + parts[1];
        }
        logger.log(Level.INFO, "Parsing results for : " + url);
        logger.log(Level.INFO, "Host \t : " + this.host);
        logger.log(Level.INFO, "Port \t : " + this.port);
        logger.log(Level.INFO, "Path \t : " + this.path);
        logger.log(Level.INFO, "Secure \t : " + this.isSecure);
    }

    @Override
    public InputStream getInputStream() throws Exception {
        URI uri = null;
        this.httpClient = new DefaultHttpClient();
        if (this.isSecure) {
            KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            keystore.load(null, NO_PASSWORD.toCharArray());
            TrustManager[] tm = null;
            if (this.certificateFilename != null && this.certificateFilename.trim().length() > 0) {
                FileInputStream is = new FileInputStream(this.certificateFilename);
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                Certificate cert = cf.generateCertificate(is);
                keystore.setCertificateEntry("cert", cert);
                String algo = TrustManagerFactory.getDefaultAlgorithm();
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(algo);
                tmf.init(keystore);
                tm = tmf.getTrustManagers();
            }
            SSLContext clientSSLContext = SSLContext.getInstance("TLS");
            clientSSLContext.init(null, tm, null);
            SSLSocketFactory socketFactory = new SSLSocketFactory(clientSSLContext);
            Scheme https = new Scheme(HTTPS_PROTOCOL, (SocketFactory)socketFactory, this.port);
            this.httpClient.getConnectionManager().getSchemeRegistry().register(https);
            uri = new URI(HTTPS_PROTOCOL, null, this.host, this.port, this.path, null, null);
        } else {
            Scheme https = new Scheme(HTTP_PROTOCOL, (SocketFactory)PlainSocketFactory.getSocketFactory(), this.port);
            this.httpClient.getConnectionManager().getSchemeRegistry().register(https);
            uri = new URI(HTTP_PROTOCOL, null, this.host, this.port, this.path, null, null);
        }
        HttpGet get = new HttpGet(uri);
        HttpResponse response = this.httpClient.execute((HttpUriRequest)get);
        HttpEntity entity = response.getEntity();
        this.is = entity.getContent();
        return this.is;
    }

    @Override
    public void close() {
        this.httpClient.getConnectionManager().shutdown();
        try {
            this.is.close();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "HTTP Locator inputstream close failed", e);
        }
    }
}

