/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.rr.plugins.impl;

import gr.uoa.di.madgik.rr.ResourceRegistry;
import gr.uoa.di.madgik.rr.ResourceRegistryException;
import gr.uoa.di.madgik.rr.plugins.Plugin;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HostFinderPlugin
extends Plugin {
    private static Logger logger = Logger.getLogger(HostFinderPlugin.class.getName());
    public static final String PROPERTIES_FILE = "deploy.properties";
    private Properties properties = null;

    private synchronized Properties getPropertyFile() throws IOException {
        if (this.properties != null) {
            return this.properties;
        }
        this.properties = new Properties();
        InputStream is = HostFinderPlugin.class.getResourceAsStream("/deploy.properties");
        this.properties.load(is);
        return this.properties;
    }

    private String getHostname() throws IOException {
        return this.getPropertyFile().getProperty("hostname");
    }

    private String getPort() throws IOException {
        return this.getPropertyFile().getProperty("port");
    }

    public HostFinderPlugin() {
        this.type = Plugin.Type.ONE_OFF;
    }

    public void setup() throws ResourceRegistryException {
    }

    protected void execute(Set<Class<?>> targets) throws ResourceRegistryException {
        try {
            System.out.println("getting hostname : ");
            System.out.println("getting port : ");
            String host = this.getHostname();
            String port = this.getPort();
            logger.log(Level.INFO, "hostname : " + host);
            logger.log(Level.INFO, "port     : " + port);
            System.out.println("hostname : " + host);
            System.out.println("port     : " + port);
            ResourceRegistry.getContext().setLocalNodeHostname(host);
            ResourceRegistry.getContext().setLocalNodePort(port);
        }
        catch (Exception e) {
            throw new ResourceRegistryException("could not resolve local node hostname or port", (Throwable)e);
        }
    }
}

