package gr.uoa.di.madgik.rr.element.search.index;

import gr.uoa.di.madgik.rr.RRContext;
import gr.uoa.di.madgik.rr.ResourceRegistryException;
import gr.uoa.di.madgik.rr.RRContext.DatastoreType;

import java.util.List;

public class FWIndexService extends DataSourceService
{
	public FWIndexService() throws ResourceRegistryException
	{
		super(FWIndexServiceDao.class);
		setType(Type.ForwardIndex);
	}
	
	@Override
	public String deepToString()
	{
		StringBuilder buf=new StringBuilder();
		buf.append("FWIndexService - ID : "+this.getID()+"\n");
		buf.append("FWIndexService - Endpoint: "+this.getEndpoint()+"\n");
		buf.append("FWIndexService - Hosting Node: "+this.getHostingNode()+"\n");
		buf.append("FWIndexService - Functionality : "+this.getFunctionality()+"\n");
		buf.append("FWIndexService - Scopes : ");
		for(String scope : this.getScopes()) buf.append(scope+" "); 
		return buf.toString();
	}
	
	@Override
	public boolean exists(RRContext.DatastoreType persistencyType) throws ResourceRegistryException
	{
		return exists(FWIndexServiceDao.class, persistencyType);
	}

	
	public static List<DataSourceService> getAll(boolean loadDetails) throws ResourceRegistryException
	{
		return DataSourceService.getAll(FWIndexServiceDao.class, DatastoreType.LOCAL, loadDetails);
	}

	public static List<DataSourceService> getAll(boolean loadDetails, DatastoreType persistencyType) throws ResourceRegistryException
	{
		return DataSourceService.getAll(FWIndexServiceDao.class, persistencyType, loadDetails);
	}
	
	public static DataSourceService getById(boolean loadDetails, String id) throws ResourceRegistryException 
	{
		FWIndexService f = new FWIndexService();
		f.setID(id);
		return f.load(loadDetails) == true ? f : null;
	}
}
