package gr.uoa.di.madgik.rr.element.metadata;

import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.w3c.dom.Element;

import gr.uoa.di.madgik.commons.utils.XMLUtils;
import gr.uoa.di.madgik.rr.ResourceRegistryException;
import gr.uoa.di.madgik.rr.element.IDaoElement;

public class ElementMetadataDao implements IDaoElement 
{
	
	private String ID;
	private String type;
	private long timestamp;
	private long metadataTimestamp=Calendar.getInstance().getTimeInMillis();
	private Set<String> propertyKeys = new HashSet<String>();
	private Set<String> propertyValues = new HashSet<String>();
	
	public static String FieldNamePropertyName = "FieldName";
	
	public String getID()
	{
		return ID;
	}

	public void setID(String iD)
	{
		ID = iD;
	}
	
	public String getType()
	{
		return type;
	}
	
	public void setType(String type)
	{
		this.type = type;
	}
	
	public long getTimestamp()
	{
		return timestamp;
	}
	
	public void setTimestamp(long timestamp)
	{
		this.timestamp = timestamp;
	}
	
	public long getMetadataTimestamp()
	{
		return metadataTimestamp;
	}
	
	public void setMetadataTimestamp(long timestamp)
	{
		this.metadataTimestamp = timestamp;
	}
	
	public Set<String> getPropertyKeys()
	{
		return propertyKeys;
	}
	
	public void setPropertyKeys(Set<String> propertyKeys)
	{
		this.propertyKeys = propertyKeys;
	}
	
	public Set<String> getPropertyValues()
	{
		return this.propertyValues;
	}
	
	public void setPropertyValues(Set<String> propertyValues)
	{
		this.propertyValues = propertyValues;
	}
	
	public void apply(IDaoElement target) throws ResourceRegistryException
	{
		if(!(target instanceof ElementMetadataDao)) throw new ResourceRegistryException("cannot apply to target of "+target);
		this.setID(((ElementMetadataDao)target).getID());
		this.setType(((ElementMetadataDao)target).getType());
		this.setMetadataTimestamp(((ElementMetadataDao)target).getMetadataTimestamp());
		this.setPropertyKeys(((ElementMetadataDao)target).getPropertyKeys());
		this.setPropertyValues(((ElementMetadataDao)target).getPropertyValues());
		
	}
	
	public String deepToString(){
		StringBuilder buf=new StringBuilder();
		buf.append("ID "+ID+"\n");
		buf.append("Type "+type+"\n");
		buf.append("timestamp "+metadataTimestamp+"\n");
		for(String propertyKey : this.getPropertyKeys())
			buf.append("PropertyKey "+propertyKey+"\n");
		for(String propertyValue : this.getPropertyValues())
			buf.append("PropertyValue "+propertyValue+"\n");
		return buf.toString();
	}
	
	@Override
	public void fromXML(Element element) throws ResourceRegistryException
	{
		try
		{
			if(!XMLUtils.AttributeExists(element, "id")) throw new ResourceRegistryException("id attribute not found in serialization");
			this.setID(XMLUtils.GetAttribute(element, "id"));
			this.setType(XMLUtils.GetChildText(XMLUtils.GetChildElementWithName(element, "type")));
			this.setMetadataTimestamp(Long.parseLong(XMLUtils.GetChildText(XMLUtils.GetChildElementWithName(element, "timestamp"))));
			List<Element> pXML=XMLUtils.GetChildElementsWithName(XMLUtils.GetChildElementWithName(element, "propertyKeys"), "propertyKey");
			for(Element item : pXML) this.propertyKeys.add(XMLUtils.GetChildText(item));
			pXML=XMLUtils.GetChildElementsWithName(XMLUtils.GetChildElementWithName(element, "propertyValues"), "propertyValues");
			for(Element item : pXML) this.propertyValues.add(XMLUtils.GetChildText(item));
		}catch(Exception ex)
		{
			throw new ResourceRegistryException("could not complete deserialization",ex);
		}
	}

	@Override
	public String toXML()
	{
		StringBuilder buf=new StringBuilder();
		buf.append("<elementMetadata id=\""+this.getID()+"\">");
		buf.append("<type>"+this.getType()+"</type>");
		buf.append("<timestamp>" + this.getMetadataTimestamp() +"</timestamp>");
		buf.append("<propertyKeys>");
		for(String propertyKey : this.getPropertyKeys())
			buf.append("<propertyKey>" + propertyKey + "</propertyKey>");
		buf.append("</propertyKeys>");
		buf.append("<propertyValues>");
		for(String propertyValue : this.getPropertyValues())
			buf.append("<propertyValue>" + propertyValue + "</propertyValue>");
		buf.append("</propertyValues>");
		
		buf.append("</elementMetadata>");
		return buf.toString();
	}

}
