package gr.uoa.di.madgik.rr.element.search;

import gr.uoa.di.madgik.commons.utils.XMLUtils;
import gr.uoa.di.madgik.rr.ResourceRegistryException;
import gr.uoa.di.madgik.rr.element.IDaoElement;

import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.w3c.dom.Element;

public class SearchableDao implements IDaoElement
{
	public String ID;
	private long timestamp = Calendar.getInstance().getTimeInMillis();
	public String collection;
	public String locator;
	public Set<String> capabilities=new HashSet<String>();
	public boolean order;
	public String field;
	public String expression;
	public Set<String> datasourceScopes = new HashSet<String>();
	
	public String deepToString(){
		StringBuilder buf=new StringBuilder();
		buf.append("searchable ID "+ID+"\n");
		buf.append("searchable collection "+collection+"\n");
		buf.append("searchable locator "+locator+"\n");
		buf.append("searchable order "+order+"\n");
		buf.append("searchable field "+field+"\n");
		if(expression!=null) buf.append("searchable expression " + expression + "\n");
		if(capabilities!=null){
			for(String c : capabilities) buf.append("searchable capability "+c+"\n");
		}
		return buf.toString();
	}

	public String getField()
	{
		return field;
	}

	public void setField(String field)
	{
		this.field = field;
	}
	
	public String getExpression()
	{
		return expression;
	}

	public void setExpression(String expression)
	{
		this.expression = expression;
	}

	public boolean isOrder()
	{
		return order;
	}
	public void setOrder(boolean order)
	{
		this.order = order;
	}
	public String getLocator()
	{
		return locator;
	}
	public void setLocator(String locator)
	{
		this.locator = locator;
	}
	public Set<String> getCapabilities()
	{
		return capabilities;
	}
	public void setCapabilities(Set<String> capabilities)
	{
		this.capabilities = capabilities;
	}
	public String getID()
	{
		return ID;
	}
	public long getTimestamp()
	{
		return timestamp;
	}
	public void setID(String iD)
	{
		ID = iD;
	}
	public void setTimestamp(long timestamp)
	{
		this.timestamp = timestamp;
	}
	public String getCollection()
	{
		return collection;
	}
	public void setCollection(String collection)
	{
		this.collection = collection;
	}
	public Set<String> getDatasourceScopes()
	{
		return datasourceScopes;
	}
	public void setDatasourceScopes(Set<String> datasourceScopes)
	{
		this.datasourceScopes = datasourceScopes;
	}
	
	public void apply(IDaoElement target) throws ResourceRegistryException
	{
		if(!(target instanceof SearchableDao)) throw new ResourceRegistryException("cannot apply to target of "+target);
		this.setCollection(((SearchableDao)target).getCollection());
		this.setField(((SearchableDao)target).getField());
		this.setLocator(((SearchableDao)target).getLocator());
		this.setExpression(((SearchableDao)target).getExpression());
		this.setOrder(((SearchableDao)target).isOrder());
		this.setCapabilities(((SearchableDao)target).getCapabilities());
		this.setDatasourceScopes(((SearchableDao)target).getDatasourceScopes());
	}

	public void fromXML(Element element) throws ResourceRegistryException
	{
		try
		{
			if(!XMLUtils.AttributeExists(element, "id")) throw new ResourceRegistryException("id attribute not found in serialization");
			this.setID(XMLUtils.GetAttribute(element, "id"));
			this.setCollection(XMLUtils.GetChildText(XMLUtils.GetChildElementWithName(element, "collection")));
			this.setField(XMLUtils.GetChildText(XMLUtils.GetChildElementWithName(element, "field")));
			this.setLocator(XMLUtils.GetChildText(XMLUtils.GetChildElementWithName(element, "locator")));
			this.setOrder(Boolean.parseBoolean(XMLUtils.GetChildText(XMLUtils.GetChildElementWithName(element, "order"))));
			List<Element> psXML=XMLUtils.GetChildElementsWithName(XMLUtils.GetChildElementWithName(element, "capabilities"), "capability");
			for(Element item : psXML) this.capabilities.add(XMLUtils.GetChildText(item).trim());
			this.setExpression(XMLUtils.GetChildText(XMLUtils.GetChildElementWithName(element, "expression")));
		}catch(Exception ex)
		{
			throw new ResourceRegistryException("could not complete deserialization",ex);
		}
	}

	public String toXML()
	{
		StringBuilder buf=new StringBuilder();
		buf.append("<searchable id=\""+this.getID()+"\">");
		buf.append("<collection>"+this.getCollection()+"</collection>");
		buf.append("<field>"+this.getField()+"</field>");
		buf.append("<locator>"+this.getLocator()+"</locator>");
		buf.append("<order>"+this.isOrder()+"</order>");
		buf.append("<capabilities>");
		for(String s : this.getCapabilities()) buf.append("<capability>"+s+"</capability>");
		buf.append("</capabilities>");
		if(this.getExpression() != null) buf.append("<expression>"+this.getExpression()+"</expression>");
		buf.append("</searchable>");
		return buf.toString();
	}
}
